/*
 * Original coded: 2005/2/26 by abe
 * Checked : 
 * Changelog:
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_evaluator.classificationRule;

import coin.Instances;
import coin.Rule;
import coin.Ruleset;
import coin.Evaluator;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * @author Hidenao Abe  (hidenao@users.sourceforge.jp)
 *
 */
public class RuleExternalEvaluator extends RuleEvaluator {
	
	public RuleExternalEvaluator(String name){
		super(name);
	}
	
	public RuleExternalEvaluator(){
		super();
	}

	public void evaluation(){ 
		
		String file_name=null;
		String measure_type=null;
		String measure_name=null;
		
		file_name = getParameter("ExternalInput");
		measure_type = getParameter("ExternalInput_Type");
		
		if(measure_type.equals(Evaluator.TYPE_STRING)){
			setTypeString();
		}
		else{
			setTypeValue();
		}

		//read file for external input of the rule evaluation measure
		try{
			InputStreamReader fr = new InputStreamReader(new FileInputStream(file_name),"JISAutoDetect");
			BufferedReader br = new BufferedReader(fr);
			
			String line = null;
			line = br.readLine();

			while(line != null && line.length() > 0){
				
				StringTokenizer strt = new StringTokenizer(line,",");
				
				String elem=null,model_file=null,local_id=null;
				int field_num = 0;
				
				while(strt.hasMoreElements()){
					elem = strt.nextToken();
					
					if(field_num==0){
						model_file = elem;
					}
					else if(field_num==1){
						local_id=elem;
					}
					else if(field_num==2){
						boolean evaluated=false;
						int i=0;
						for(i=0; evaluated==false && i<rulesets.size(); i++){
							int j=0;
							Ruleset rules = (Ruleset)rulesets.elementAt(i);
							if(rules.getID().equals(model_file)){
								Instances dset = (Instances)dsets.get(evalTable.get(rules));
								for(j=0; j<rules.size(); j++){
									Rule rule = rules.getRule(j);
									if(rule.getID().equals(local_id)){
										results.put(rule,elem.toString());
										evaluated=true;
										break;
									}
								}
							}
						}						
					}
					
					field_num++;
				}
				
				line = br.readLine();
			}
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}
		
		

	}

}
