/*
 * Original coded: 2003/12/11 by abe(abecci@anet.ne.jp)
 * Cheked : 2004/10/13 by abe(abe@med.shimane-u.ac.jp)
 *          2004/11/22 by abe(abe@med.shimane-u.ac.jp) and ohsaki(mohsaki@mail.doshisha.ac.jp)
 * Changelog:
 *   2004/12/18 add constructors to create an instance with the measurement name or without it
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_evaluator.classificationRule;

import coin.Instances;
import coin.Rule;
import coin.Ruleset;
import coin.Attribute;

/**
 * @author Hidenao Abe  (hidenao@users.sourceforge.jp)
 *
 */
public class RuleJMeasureEvaluator extends RuleEvaluator {
	
	public RuleJMeasureEvaluator(String name){
		super(name);
		this.setTypeValue();
	}
	
	public RuleJMeasureEvaluator(){
		super();
		this.setTypeValue();
	}

	public void evaluation(){ // J-Measure = (matches / dset.size())*(I_diff1 + I_diff2)
		                      // I_diff1 = Precision *log2(Precision/Prevalence)
		                      // I_diff2 = (1-Precision)*log2((1-Precision)/(1-Prevalence))
		
		countAllOfRulesStats();

		int i=0;
		for(i=0; i<rulesets.size(); i++){
			int j=0;
			Ruleset rules = (Ruleset)rulesets.elementAt(i);
			Instances dset = (Instances)dsets.get(evalTable.get(rules));
			for(j=0; j<rules.size(); j++){
				Rule rule = rules.getRule(j);
				Attribute att = dset.getAttributeInfo().getAttribute(rule.getConsequent().getAttName());
				double value = 0.0f;
				double corrects = (double)rule.getCorrects();
				double matches = (double)rule.getMatches();
				double numOfClass = (double)att.getNumOfNominalValue(rule.getConsequent().getValue());
				double sizeOfDSet = (double)dset.size();
				double I_diff1 = 0.0f;
				double I_diff2 = 0.0f;
				if(sizeOfDSet > 0.0f){
					if(corrects > 0.0f && matches > 0.0f && numOfClass > 0.0f){
						double precision = corrects / matches;
						double prevalence = numOfClass / sizeOfDSet;
						if(precision < 1.0f && prevalence < 1.0f){
							I_diff1 = (precision)*((Math.log(precision) -Math.log(prevalence))/Math.log(2.0));
							I_diff2 = (1-precision)*((Math.log(1-precision) - Math.log(1-prevalence))/Math.log(2.0));
						}
					}
					value = (matches / sizeOfDSet)*(I_diff1 + I_diff2);
				}
				
				results.put(rule,new Double(value));
			}
		}
	}

}
