/*
 * Original coded : 2004/01/?? by sato
 * Checked : 2004/10/08 by abe(abe@med.shimane-u.ac.jp) and ohsaki(mohsaki@mail.doshisha.ac.jp)
 *           2004/10/12 by abe(abe@med.shimane-u.ac.jp)
 * Changelog:
 *   2004/10/08 add the comment of the fomula of Odds Ratio
 *   2004/10/08 correct the fomula
 *   2004/10/12 refactor this ClassName from "RuleOREvaluator" to "RuleOddsRatioEvaluator"
 *   2004/12/18 add constructors to create an instance with the measurement name or without it
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_evaluator.classificationRule;


/**
 *  @author Hidenao Abe (hidenao@users.sourceforge.jp)
 */
import coin.Instances;
import coin.Rule;
import coin.Ruleset;
import coin.Attribute;

public class RuleOddsRatioEvaluator extends RuleEvaluator {
	
	public RuleOddsRatioEvaluator(String name){
		super(name);
		this.setTypeValue();
	}
	
	public RuleOddsRatioEvaluator(){
		super();
		this.setTypeValue();
	}

	public void evaluation(){ // Odds_Ratio(OR) = (Support * Specificity) / ((matchs - corrects)/#dset * (#class - corrects)/#dset)
		
		countAllOfRulesStats();

		int i=0;
		for(i=0; i<rulesets.size(); i++){
			int j=0;
			Ruleset rules = (Ruleset)rulesets.elementAt(i);
			Instances dset = (Instances)dsets.get(evalTable.get(rules));
			for(j=0; j<rules.size(); j++){
				Rule rule = rules.getRule(j);
				Attribute att = dset.getAttributeInfo().getAttribute(rule.getConsequent().getAttName());
				double corrects = (double)rule.getCorrects();
				double matches = (double)rule.getMatches();
				double numOfClass = (double)att.getNumOfNominalValue(rule.getConsequent().getValue());
				double sizeOfDSet = (double)dset.size();
				double TP = (corrects/sizeOfDSet)*((sizeOfDSet+corrects-matches-numOfClass)/sizeOfDSet);
				double TN = ((matches-corrects)/sizeOfDSet)*((numOfClass-corrects)/sizeOfDSet);
				double value = 0.0f;
				if(TP != 0 && TN != 0){
					value = TP/TN;
				}
				results.put(rule,new Double(value));
			}
		}
	}

}
