/*
 * Original coded: 2003/12/11 by abe(abecci@anet.ne.jp)
 * Checked : 2004/10/08 by abe(abe@med.shimane-u.ac.jp) and ohsaki(mohsaki@mail.doshisha.ac.jp)
 *           2004/10/12 by abe(abe@med.shimane-u.ac.jp)
 *
 * Changelog:
 *   2004/12/17 add number check for matches
 *   2004/12/18 add constructors to create an instance with the measurement name or without it
 * 
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_evaluator.classificationRule;

import coin.Instances;
import coin.Rule;
import coin.Ruleset;

/**
 * @author Hidenao Abe  (hidenao@users.sourceforge.jp)
 *
 */
public class RulePrecisionEvaluator extends RuleEvaluator {
	
	public RulePrecisionEvaluator(String name){
		super(name);
		this.setTypeValue();
	}
	
	public RulePrecisionEvaluator(){
		super();
		this.setTypeValue();
	}

	public void evaluation(){ // Precision = corrects / matches
		                      //           = #TP / (#TP+#TN)
		
		countAllOfRulesStats();

		int i=0;
		for(i=0; i<rulesets.size(); i++){
			int j=0;
			Ruleset rules = (Ruleset)rulesets.elementAt(i);
			Instances dset = (Instances)dsets.get(evalTable.get(rules));
			for(j=0; j<rules.size(); j++){
				Rule rule = rules.getRule(j);
				double value = 0.0f;
				if(rule.getMatches() > 0){
					value = (double)rule.getCorrects() / (double)rule.getMatches();
				}
				results.put(rule,new Double(value));
			}
		}
	}

}
