/*
 * Created on 2003/12/03 by abe
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_loader.classificationRuleset;

import java.util.Vector;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import coin.Attributes;
import coin.Clause;
import coin.Rule;

/**
 * @author Hidenao Abe  (hidenao@users.sourceforge.jp)
 *
 */
public class C5RulesetLoader extends RulesetLoader {

	public C5RulesetLoader(String fileName){
		super();
		
		this.filename = fileName;
		this.loadRuleset(fileName);
	}

	public C5RulesetLoader(String fileName, Attributes attInfo){
		
		super(attInfo);
		
		this.filename = fileName;
		this.loadRuleset(fileName);
		
	}
	
	private void loadRuleset(String fileName){
		
		String line=null;
		boolean isRuleReading=false;
		Vector line_buf=new Vector();
		
		try{
			InputStreamReader fr = new InputStreamReader(new FileInputStream(filename),"JISAutoDetect");
			BufferedReader br = new BufferedReader(fr);
			
			line = br.readLine();
			while(line != null){
				//System.out.println(isRuleReading);
				if(line.length()==0){
					line=null;
				}
				else if(line.matches(".*Rule.*")){
					line_buf.removeAllElements();
					isRuleReading=true;
					line_buf.add(line);
				}
				else if(line.matches(".*->.*")){
					line_buf.add(line);
					isRuleReading=false;
					rules.addRule(makeRule(line_buf));
					//System.out.println("[--"+line_buf.toString()+"--]");
				}
				else if(isRuleReading){
					line_buf.add(line);
				}
				else{
				}

				line = br.readLine();
			}
		}
		catch(FileNotFoundException fne){
			fne.printStackTrace();
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}
		
		rules.setID(fileName);
	}
	
	private Rule makeRule(Vector lines){
		
		Rule rule=null;
		//System.out.println(lines);
		
		rule = new Rule();
		
		int i;
		for(i=0; i<lines.size(); i++){
			String line=(String)lines.elementAt(i);
			//System.out.println(line);
			
			if(line.length()==0){ // skip blank line
				continue;
			}
			
			if(line.matches(".*Rule.*")){
				int j;
				StringBuffer id = new StringBuffer();
				for(j=line.indexOf("Rule")+5; j<line.indexOf(":"); j++){
					if(!Character.isSpaceChar(line.charAt(j))){
						id.append(line.charAt(j));
					}
				}
				rule.setId(id.toString());
				//System.out.println("id:"+id.toString());
			}
			else if(line.matches(".*->.*")){
				StringBuffer classValue = new StringBuffer();
				int j;
				int len_limit=0;
				if(line.indexOf("[")>0){
					len_limit=line.indexOf("[");
				}
				else{
					len_limit=line.length();
				}
				for(j=line.indexOf("class")+5; j<len_limit; j++){
					if(line.charAt(i)=='['){
						break;
					}
					else if(!Character.isSpaceChar(line.charAt(j)) &&  line.charAt(j)!= '\t'){
						classValue.append(line.charAt(j));
						//System.out.println(line.charAt(j));
					}
				}
				rule.setConsequent(new Clause("class",Clause.EQUAL, classValue.toString()));
				
			}
			else{
				Clause c = parseClause(line);
				if(rule.hasAttributeInAntecedents(c.getAttName())){
					Clause existing = rule.getAntecedent(c.getAttName());
					if(existing.getOperator() == Clause.GREATER && c.getOperator() == Clause.LESS){
						if(existing.getLowerFloatValue() < c.getLowerFloatValue()){
							existing.setUpperValue(c.getLowerValue());
							existing.setOperator(Clause.BETWEEN);
						}
						else{
							rule.addAntecedents(c);
						}
					}
					else if(c.getOperator() == Clause.GREATER && existing.getOperator() == Clause.LESS){
						if(c.getLowerFloatValue() < existing.getFloatValue()){
							existing.setUpperValue(existing.getLowerValue());
							existing.setLowerValue(c.getLowerValue());
							existing.setOperator(Clause.BETWEEN);
						}
						else{
							rule.addAntecedents(c);
						}
					}
					else if(existing.getOperator() == Clause.GREATER && c.getOperator() == Clause.GREATER){
						if(existing.getLowerFloatValue() < c.getFloatValue()){
							existing.setLowerValue(c.getLowerValue());
						}
					}
					else if(existing.getOperator() == Clause.LESS && c.getOperator() == Clause.LESS){
						if(existing.getLowerFloatValue() > c.getLowerFloatValue()){
							existing.setLowerValue(c.getLowerValue());
						}
					}
					else{
						rule.addAntecedents(c);
					}
				}
				else{
					rule.addAntecedents(c);
				}
			}
		}
		
		
		return rule;
	}
	
	private Clause parseClause(String line){
		
		Clause clause;
		StringBuffer attName, relation, value;
		
		attName = new StringBuffer();
		relation = new StringBuffer();
		value = new StringBuffer();
		
		int i;
		boolean isName=true,isRelation=false,isValue=false;
		for(i=0; i<line.length(); i++){
			char c = line.charAt(i);
			//System.out.println(c);
			if(Character.isSpaceChar(c) || c=='\t'){
				continue;
			}
			
			// parsing an line
			if(isName && (c == '<' || c=='=' || c=='>')){
				isName = false;
				isRelation = true;
				relation.append(c);
			}
			else if(isName){
				attName.append(c);
			}
			else if(isRelation && c!='='){
				isRelation = false;
				isValue = true;
				value.append(c);
			}
			else if(isRelation && c=='='){
				relation.append(c);
				isRelation = false;
				isValue=true;
			}
			else if(isRelation){
				relation.append(c);
			}
			else if(isValue){
				value.append(c);
			}
			else{
				System.out.println("I'm confused in paeseClause");
			}
		}
		
		//System.out.println("attName: "+attName);
		
		if(relation.toString().equals("<")){
			relation.append("=");
		}
		clause = new Clause(attName.toString(), Clause.getOperatorIndex(relation.toString()), value.toString());
		
		return clause;
	}
	
	public String toString(){
		
		StringBuffer result_buf = new StringBuffer();
		
		result_buf.append("filename : "+filename+"\n");
		result_buf.append("rule set :\n");
		result_buf.append(rules.toString());
		
		return result_buf.toString();
	}
	
	public static void main(String[] args){
		
		try{
			C5RulesetLoader crl = new C5RulesetLoader(args[0]);
			System.out.println(crl.toString());
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	

}
