/*
 * Created on 2003/12/03 by abe
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_loader.classificationRuleset;

import java.util.Vector;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import coin.Attributes;
import coin.Clause;
import coin.Rule;

/**
 * @author Hidenao Abe  (hidenao@users.sourceforge.jp)
 *
 */
public class CAMLETRulesetLoader extends RulesetLoader {

	public CAMLETRulesetLoader(String fileName){
		super();
		
		this.filename = fileName;
		this.loadRuleset(fileName);
	}

	public CAMLETRulesetLoader(String fileName, Attributes attInfo){
		
		super(attInfo);
		
		this.filename = fileName;
		this.loadRuleset(fileName);
		
	}
	
	private void loadRuleset(String fileName){
		
		String line=null;
		boolean isRuleReading=false;
		Vector line_buf=new Vector();
		
		try{
			InputStreamReader fr = new InputStreamReader(new FileInputStream(filename),"JISAutoDetect");
			BufferedReader br = new BufferedReader(fr);
			
			line = br.readLine();
			while(line != null){
				System.out.println(isRuleReading);
				if(line.length()==0){
					line=null;
				}
				else if(line.matches(".*rule ID.*")){
					line_buf.removeAllElements();
					isRuleReading=true;
					line_buf.add(line);
				}
				else if(line.matches(".*matchs.*")){
					line_buf.add(line);
					isRuleReading=false;
					rules.addRule(makeRule(line_buf));
				}
				else if(isRuleReading){
					line_buf.add(line);
				}
				else{
				}

				line = br.readLine();
			}
		}
		catch(FileNotFoundException fne){
			fne.printStackTrace();
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}
		
		rules.setID(fileName);
	}
	
	private Rule makeRule(Vector lines){
		
		Rule rule=null;
		
		rule = new Rule();
		
		boolean isCons=false;
		
		int i;
		for(i=0; i<lines.size(); i++){
			String line=(String)lines.elementAt(i);
			//System.out.println(line);
			
			if(line.length()==0){ // skip blank line
				continue;
			}
			
			if(line.matches(".*rule ID.*")){
				int j;
				StringBuffer id = new StringBuffer();
				for(j=line.indexOf("rule ID [")+9; j<line.indexOf("]:"); j++){
					if(!Character.isSpaceChar(line.charAt(j))){
						id.append(line.charAt(j));
					}
				}
				rule.setId(id.toString());
				System.out.println("id:"+id.toString());
			}
			else if(!isCons && line.matches(".*IF.*")){
				isCons=true;
				rule.addAntecedents(parseClause(line));
			}
			else if(isCons && !line.matches(".*THEN.*")){
				rule.addAntecedents(parseClause(line));
			}
			else if(isCons && line.matches(".*THEN.*")){
				isCons = false;
				
				StringBuffer classValue = new StringBuffer();
				int j;
				for(j=line.indexOf("THEN")+4; j<line.indexOf("("); j++){
					if(!Character.isSpaceChar(line.charAt(j)) &&  line.charAt(j)!= '\t'){
						classValue.append(line.charAt(j));
					}
				}
				rule.setConsequent(new Clause("class",Clause.EQUAL, classValue.toString()));
				
				StringBuffer precision = new StringBuffer();
				for(j=line.indexOf("("); j<line.indexOf(")"); j++){
					if(Character.isDigit(line.charAt(j)) || line.charAt(j) == '.'){
						precision.append(line.charAt(j));
					}
				}
				try{
					rule.setPrecision(Float.parseFloat(precision.toString()));
				}
				catch(NumberFormatException nfe){
					nfe.printStackTrace();
				}
				
				StringBuffer strength = new StringBuffer();
				for(j=line.indexOf("["); j<line.indexOf("]"); j++){
					if(Character.isDigit(line.charAt(j)) || line.charAt(j) == '.'){
						strength.append(line.charAt(j));
					}
				}
				try{
					rule.setStrength(Double.parseDouble(strength.toString()));
				}
				catch(NumberFormatException nfe){
					nfe.printStackTrace();
				}
				
			}
			else if(line.matches(".*match.*")){
				int j;
				StringBuffer matches = new StringBuffer();
				for(j=line.indexOf("(match"); j<line.indexOf(")"); j++){
					if(Character.isDigit(line.charAt(j)) || line.charAt(j) == '.'){
						matches.append(line.charAt(j));
					}
				}
				try{
					rule.setMatches(Long.parseLong(matches.toString()));
				}
				catch(NumberFormatException nfe){
					nfe.printStackTrace();
				}
				
				StringBuffer corrects = new StringBuffer();
				for(j=line.indexOf("(corrects"); j<line.length(); j++){
					if(Character.isDigit(line.charAt(j)) || line.charAt(j) == '.'){
						corrects.append(line.charAt(j));
					}
				}
				try{
					rule.setCorrects(Long.parseLong(corrects.toString()));
				}
				catch(NumberFormatException nfe){
					nfe.printStackTrace();
				}
			}
		}
		
		
		return rule;
	}
	
	private Clause parseClause(String line){
		
		Clause clause;
		StringBuffer lower,attName, relation, upper;
		
		lower = new StringBuffer();
		attName = new StringBuffer();
		relation = new StringBuffer();
		upper = new StringBuffer();
		
		int i,start=0;
		if(line.matches(".*IF.*")){
			start = line.indexOf("IF")+2;
		}
		boolean isLower=false,isRelation=false,isName=false,isUpper=false;
		for(i=start; i<line.length(); i++){
			char c = line.charAt(i);
			if(Character.isSpaceChar(c) || c=='\t'){
				continue;
			}
			
			// detect whether the first token is an attribute name or not
			if( !isLower && !isRelation && !isName && !isUpper && Character.isDigit(c)){
				isLower = true;
			}
			else if(!isLower && !isRelation && !isName && !isUpper && Character.isLetter(c)){
				isName=true;
			}
			
			// parse line
			if(isLower && (c == '<' || c=='=' || c=='>')){
				isLower = false;
				isRelation = true;
				relation.append(c);
			}
			else if(isLower){
				lower.append(c);
			}
			else if(isRelation && c!='='){
				isRelation = false;
				if(Character.isDigit(c)){
					isLower=true;
					lower.append(c);
				}
				else{
					isName=true;
					attName.append(c);
				}
			}
			else if(isRelation && c=='='){
				relation.append(c);
				isRelation = false;
				if(lower.length()==0){
					isLower=true;
				}
				else{
					isUpper=true;
				}
			}
			else if(isRelation){
				relation.append(c);
			}
			else if(isName && (c == '<' || c=='=' || c=='>')){
				isName = false;
				isRelation=true;
				relation.append(c);
			}
			else if(isName){
				attName.append(c);
			}
			else if(isUpper){
				upper.append(c);
			}
		}
		
		
		System.out.println("attName: "+attName);
		
		if(! isUpper){
			clause = new Clause(attName.toString(), Clause.getOperatorIndex(relation.toString()), lower.toString());
		}
		else{
			clause = new Clause(attName.toString(), Clause.getOperatorIndex(relation.toString()), lower.toString(), upper.toString());
		}
		
		return clause;
	}
	
	public String toString(){
		
		StringBuffer result_buf = new StringBuffer();
		
		result_buf.append("filename : "+filename+"\n");
		result_buf.append("rule set :\n");
		result_buf.append(rules.toString());
		
		return result_buf.toString();
	}
	
	public static void main(String[] args){
		
		try{
			CAMLETRulesetLoader crl = new CAMLETRulesetLoader(args[0]);
			System.out.println(crl.toString());
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	

}
