/*
 * Original coded: 2004/10/04 by Shinya Kitaguchi(kitaguti@ks.cs.inf.shizuoka.ac.jp)
 *
 * Change log:
 * 2005/06/07 upgrade loadRuleset to read PART ruleset from bagged/boosted PART
 * 
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_loader.classificationRuleset;

import java.util.Vector;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import coin.Attributes;
import coin.Clause;
import coin.Rule;

/**
 * @author Shinya Kitaguchi  
 * @author Hidenao Abe (hidenao@users.sourceforge.jp)
 */
public class PARTRulesetLoader extends RulesetLoader {

	public PARTRulesetLoader(String fileName){
		super();
		
		this.filename = fileName;
		this.loadRuleset(fileName);
	}

	public PARTRulesetLoader(String fileName, Attributes attInfo){
		
		super(attInfo);
		
		this.filename = fileName;
		this.loadRuleset(fileName);
		
	}
	
	private void loadRuleset(String fileName){
		
		String line=null;
		boolean isRulesetReading=false, isRuleReading=false;
		Vector line_buf=new Vector();
		
		try{
			InputStreamReader fr = new InputStreamReader(new FileInputStream(filename),"JISAutoDetect");
			BufferedReader br = new BufferedReader(fr);
			
			line = br.readLine();
			while(! line.matches("Time taken to build.*")){
				//System.out.println("line="+line);
				//System.out.println(isRulesetReading);
				if(line.matches(".*PART decision list.*")){
					isRulesetReading=true;
				}
				else if(isRulesetReading==true && line.matches("Number of Rules.*")){
					isRulesetReading=false;
				}
				else if(isRulesetReading==true && line.length()>0){
				  line_buf.removeAllElements();
				  while(line.length()>0 &&
				  		(line.indexOf("=") != 0 || line.indexOf("<") != 0 || line.indexOf(">") !=0)){				
				  	//System.out.println(isRuleReading);
				  	//System.out.println(line);
					if(isRuleReading==false){
						if(line.matches(".*=.*") ||
						   line.matches(".*>.*") ||
						   line.matches(".*<.*")){
							line_buf.removeAllElements();
							isRuleReading=true;
						}
						else{ break; }
					}
					
					if(isRuleReading==true && line.matches(".*:.*")){
						if(line.indexOf(":")>0){
						  line_buf.add(line.substring(0,line.indexOf(":")));
						  line_buf.add(line.substring(line.indexOf(":")));
						  rules.addRule(makeRule(line_buf));
						}
						line_buf.removeAllElements();
						isRuleReading=false;
						break;
					}
					else if(isRuleReading==true){
						if(line.matches(".*AND.*")){
							line_buf.add(line.substring(0,line.indexOf("AND")));
						}
						else{
							line_buf.add(line);
						}
					}
					else{
						break;
					}
					line=br.readLine();
				  }
				}
				line=br.readLine();
			}
		}
		catch(FileNotFoundException fne){
			fne.printStackTrace();
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}

		rules.setID(fileName);
	}
	
	private Rule makeRule(Vector lines){
		
		Rule rule=null;
		//System.out.println(lines);
		
		rule = new Rule();
		
		int i;
		for(i=0; i<lines.size(); i++){
			String line=(String)lines.elementAt(i);
			//System.out.println(line);
			
			if(line.length()==0){ // skip blank line
				continue;
			}
			
			if(line.matches(".*:.*")){
				//System.out.println(line);
				rule.setId(Integer.toString(rules.size()+1));	
				StringBuffer classValue = new StringBuffer();
				int j;
				for(j=line.indexOf(": ")+2; j<line.length(); j++){
					if(line.charAt(j)=='('){
						break;
					}
					else if(!Character.isSpaceChar(line.charAt(j)) &&  line.charAt(j)!= '\t'){
						classValue.append(line.charAt(j));
					}
				}
				rule.setConsequent(new Clause("class",Clause.EQUAL, classValue.toString()));
				
			}
			else{
				Clause c = parseClause(line);
				if(rule.hasAttributeInAntecedents(c.getAttName())){
					Clause existing = rule.getAntecedent(c.getAttName());
					if(existing.getOperator() == Clause.GREATER && c.getOperator() == Clause.LESS){
						if(existing.getLowerFloatValue() < c.getLowerFloatValue()){
							existing.setUpperValue(c.getLowerValue());
							existing.setOperator(Clause.BETWEEN);
						}
						else{
							rule.addAntecedents(c);
						}
					}
					else if(c.getOperator() == Clause.GREATER && existing.getOperator() == Clause.LESS){
						if(c.getLowerFloatValue() < existing.getFloatValue()){
							existing.setUpperValue(existing.getLowerValue());
							existing.setLowerValue(c.getLowerValue());
							existing.setOperator(Clause.BETWEEN);
						}
						else{
							rule.addAntecedents(c);
						}
					}
					else if(existing.getOperator() == Clause.GREATER && c.getOperator() == Clause.GREATER){
						if(existing.getLowerFloatValue() < c.getFloatValue()){
							existing.setLowerValue(c.getLowerValue());
						}
					}
					else if(existing.getOperator() == Clause.LESS && c.getOperator() == Clause.LESS){
						if(existing.getLowerFloatValue() > c.getLowerFloatValue()){
							existing.setLowerValue(c.getLowerValue());
						}
					}
					else{
						rule.addAntecedents(c);
					}
				}
				else{
					rule.addAntecedents(c);
				}
			}
		}
		
		
		return rule;
	}
	
	private Clause parseClause(String line){
		
		Clause clause;
		StringBuffer attName, relation, value;
		
		attName = new StringBuffer();
		relation = new StringBuffer();
		value = new StringBuffer();
		
		int i;
		boolean isName=true,isRelation=false,isValue=false;
		for(i=0; i<line.length(); i++){
			char c = line.charAt(i);
			//System.out.println(c);
			if(Character.isSpaceChar(c) || c=='\t'){
				continue;
			}
			
			// parsing an line
			if(isName && (c == '<' || c=='=' || c=='>')){
				isName = false;
				isRelation = true;
				relation.append(c);
			}
			else if(isName){
				attName.append(c);
			}
			else if(isRelation && c!='='){
				isRelation = false;
				isValue = true;
				value.append(c);
			}
			else if(isRelation && c=='='){
				relation.append(c);
				isRelation = false;
				isValue=true;
			}
			else if(isRelation){
				relation.append(c);
			}
			else if(isValue){
				value.append(c);
			}
			else{
				System.out.println("I'm confused in paeseClause");
			}
		}
		
		//System.out.println("attName: "+attName);
		
		if(relation.toString().equals("<")){
			relation.append("=");
		}
		clause = new Clause(attName.toString(), Clause.getOperatorIndex(relation.toString()), value.toString());
		
		//System.out.println(clause.toString());
		
		return clause;
	}
	
	public String toString(){
		
		StringBuffer result_buf = new StringBuffer();
		
		result_buf.append("filename : "+filename+"\n");
		result_buf.append("rule set :\n");
		result_buf.append(rules.toString());
		
		return result_buf.toString();
	}
	
	public static void main(String[] args){
		
		try{
			PARTRulesetLoader crl = new PARTRulesetLoader(args[0]);
			System.out.println(crl.toString());
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	

}
