/*
 * Created on 2003/12/04 by abe
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.mining_result_loader.classificationRuleset;

import coin.Attributes;
import coin.Ruleset;

/**
 * @author Hidenao Abe  (hidenao@users.sourceforge.jp)
 *
 */
public abstract class RulesetLoader {

	protected Ruleset rules;
	protected String filename;
	
	public RulesetLoader(){
		this.rules = new Ruleset();
	}
	
	public RulesetLoader(Attributes att){
		this.rules = new Ruleset();
		rules.setAttInfo(att);
	}
	
	private void loadRuleset(String filename){
	}

	public void setAttInfo(Attributes att){
		rules.setAttInfo(att);
	}
	
	public Ruleset getRuleset(){
		return(rules);
	}
	
	public String getFilename(){
		return(filename);
	}


}
