/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.portlet.AccessDeniedException;

public interface PortletWindow {
    public boolean isDetached();

    public boolean isMaximized();

    public boolean isMinimized();

    public State getWindowState();

    public void setWindowState(State var1) throws AccessDeniedException;

    public static class State
    implements Serializable {
        private static Map allStates = new HashMap();
        public static final State NORMAL = new State("Normal", 0);
        public static final State MAXIMIZED = new State("Maximized", 1);
        public static final State MINIMIZED = new State("Minimized", 2);
        public static final State DETACHED = new State("Detached", 3);
        public static final State MOVING = new State("Moving", 4);
        public static final State RESIZING = new State("Resizing", 5);
        public static final State CLOSED = new State("Closed", 6);
        private static final State[] STATES = new State[]{NORMAL, MAXIMIZED, MINIMIZED, DETACHED, MOVING, RESIZING, CLOSED};
        private String identifier;
        private int value;

        private State(String identifier, int value) {
            this.identifier = identifier;
            this.value = value;
            allStates.put(identifier, this);
        }

        public static State forIdentifier(String identifier) {
            return (State)allStates.get(identifier);
        }

        public int getId() {
            return this.value;
        }

        public String toString() {
            return this.identifier;
        }

        public Object readResolve() throws ObjectStreamException {
            try {
                return STATES[this.value];
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidObjectException("Unknown Portlet State");
            }
        }
    }
}

