/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Gif
extends Image
implements Element {
    Gif(Image image) {
        super(image);
    }

    public Gif(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Gif(URL uRL, float f, float f2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    public Gif(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public Gif(String string, float f, float f2) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string), f, f2);
    }

    public Gif(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.processParameters();
    }

    public Gif(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block6: {
            this.type = 31;
            InputStream inputStream = null;
            try {
                String string;
                if (this.rawData == null) {
                    inputStream = this.url.openStream();
                    string = this.url.toString();
                } else {
                    inputStream = new ByteArrayInputStream(this.rawData);
                    string = "Byte array";
                }
                if (inputStream.read() != 71) throw new BadElementException(string + " is not a valid GIF-file.");
                if (inputStream.read() != 73) throw new BadElementException(string + " is not a valid GIF-file.");
                if (inputStream.read() != 70) {
                    throw new BadElementException(string + " is not a valid GIF-file.");
                }
                Image.skip(inputStream, 3);
                this.scaledWidth = inputStream.read() + (inputStream.read() << 8);
                this.setRight(this.scaledWidth);
                this.scaledHeight = inputStream.read() + (inputStream.read() << 8);
                this.setTop(this.scaledHeight);
                Object var4_3 = null;
                if (inputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }
}

