/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.internal.OracleConnection;

class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 4096;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    char[] javaChars;
    int maxSize;
    int totalSize;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:14_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n2) {
        this(dBConversion, inputStream, n2, 1);
    }

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n2, short s2) {
        super(4096);
        this.istream = inputStream;
        this.conversion = n2;
        this.converter = dBConversion;
        this.maxSize = 0;
        this.totalSize = 0;
        this.numUnconvertedBytes = 0;
        this.endOfStream = false;
        this.nbytes = new int[1];
        this.csform = s2;
        switch (n2) {
            case 0: {
                this.javaChars = new char[4096];
                this.convbuf = new byte[4096];
                break;
            }
            case 1: {
                this.convbuf = new byte[2048];
                this.javaChars = new char[2048];
                break;
            }
            case 2: {
                this.convbuf = new byte[2048];
                this.javaChars = new char[4096];
                break;
            }
            case 3: {
                this.convbuf = new byte[1024];
                this.javaChars = new char[2048];
                break;
            }
            case 4: {
                int n3 = 4096 / this.converter.getMaxCharbyteSize();
                this.convbuf = new byte[n3 * 2];
                this.javaChars = new char[n3];
                break;
            }
            case 5: {
                if (this.converter.isUcs2CharSet()) {
                    this.convbuf = new byte[2048];
                    this.javaChars = new char[2048];
                    break;
                }
                this.convbuf = new byte[4096];
                this.javaChars = new char[4096];
                break;
            }
            case 7: {
                int n4 = 4096 / (s2 == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
                this.javaChars = new char[n4];
                break;
            }
            default: {
                this.convbuf = new byte[4096];
                this.javaChars = new char[4096];
            }
        }
    }

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n2, int n3) {
        this(dBConversion, inputStream, n2, 1);
        this.maxSize = n3;
        this.totalSize = 0;
    }

    public OracleConversionInputStream(DBConversion dBConversion, Reader reader, int n2, int n3, short s2) {
        this(dBConversion, (InputStream)null, n2, s2);
        this.reader = reader;
        this.maxSize = n3;
        this.totalSize = 0;
    }

    public void setFormOfUse(short s2) {
        this.csform = s2;
    }

    public boolean needBytes() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.pos < this.count) {
            return true;
        }
        if (this.istream != null) {
            return this.needBytesFromStream();
        }
        if (this.reader != null) {
            return this.needBytesFromReader();
        }
        return false;
    }

    public boolean needBytesFromReader() throws IOException {
        try {
            int n2 = 0;
            n2 = this.maxSize == 0 ? this.javaChars.length : Math.min(this.maxSize - this.totalSize, this.javaChars.length);
            if (n2 <= 0) {
                this.reader.close();
                this.close();
                return false;
            }
            int n3 = this.reader.read(this.javaChars, 0, n2);
            if (n3 == -1) {
                this.reader.close();
                this.close();
                return false;
            }
            this.totalSize += n3;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, n3, this.buf);
                        break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.javaChars, n3, this.buf);
                    break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, this.buf, 0, n3);
                    this.count = n3;
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        this.pos = 0;
        return true;
    }

    public boolean needBytesFromStream() throws IOException {
        if (!this.endOfStream) {
            try {
                int n2 = 0;
                n2 = this.maxSize == 0 ? this.convbuf.length : Math.min(this.maxSize - this.totalSize, this.convbuf.length);
                int n3 = 0;
                if (n2 <= 0) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 55);
                    }
                } else {
                    n3 = this.istream.read(this.convbuf, this.numUnconvertedBytes, n2 - this.numUnconvertedBytes);
                }
                if (n3 == -1) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 55);
                    }
                } else {
                    this.totalSize += (n3 += this.numUnconvertedBytes);
                }
                if (n3 <= 0) {
                    return false;
                }
                switch (this.conversion) {
                    case 0: {
                        this.nbytes[0] = n3;
                        int n4 = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                        this.numUnconvertedBytes = this.nbytes[0];
                        for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                            this.convbuf[i2] = this.convbuf[n3 - this.numUnconvertedBytes];
                        }
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, n4, this.buf);
                        break;
                    }
                    case 1: {
                        this.nbytes[0] = n3;
                        int n5 = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                        this.numUnconvertedBytes = this.nbytes[0];
                        for (int i3 = 0; i3 < this.numUnconvertedBytes; ++i3) {
                            this.convbuf[i3] = this.convbuf[n3 - this.numUnconvertedBytes];
                        }
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, n5, this.buf);
                        break;
                    }
                    case 2: {
                        int n6 = DBConversion.RAWBytesToHexChars(this.convbuf, n3, this.javaChars);
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, n6, this.buf);
                        break;
                    }
                    case 3: {
                        int n7 = DBConversion.RAWBytesToHexChars(this.convbuf, n3, this.javaChars);
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, n7, this.buf);
                        break;
                    }
                    case 4: {
                        int n8 = DBConversion.ucs2BytesToJavaChars(this.convbuf, n3, this.javaChars);
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, n8, this.buf);
                        break;
                    }
                    case 5: {
                        DBConversion.asciiBytesToJavaChars(this.convbuf, n3, this.javaChars);
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, n3, this.buf);
                        break;
                    }
                    default: {
                        System.arraycopy(this.convbuf, 0, this.buf, 0, n3);
                        this.count = n3;
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
            this.pos = 0;
            return true;
        }
        return false;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

