/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTIpro
extends T4CTTIMsg {
    short svrCharSet;
    short svrCharSetElem;
    byte svrFlags;
    byte[] proSvrStr;
    byte proSvrVer;
    short oVersion = (short)-1;
    boolean svrInfoAvailable = false;
    byte[] proCliVerTTC8 = new byte[]{6, 5, 4, 3, 2, 1, 0};
    byte[] proCliStrTTC8 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 50, 46, 48, 0};
    short NCHAR_CHARSET = 0;
    byte[] runtimeCapabilities = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:19_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4C8TTIpro(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        super((byte)1);
        this.setMarshalingEngine(t4CMAREngine);
    }

    byte[] receive() throws SQLException, IOException {
        int n2;
        if (this.meg.unmarshalSB1() != 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
        }
        this.meg.proSvrVer = this.proSvrVer = this.meg.unmarshalSB1();
        switch (this.proSvrVer) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            case 6: {
                this.oVersion = (short)8100;
                break;
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 444);
            }
        }
        this.meg.unmarshalSB1();
        this.proSvrStr = this.meg.unmarshalTEXT(50);
        this.oVersion = this.getOracleVersion();
        this.svrCharSet = (short)this.meg.unmarshalUB2();
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalUB2();
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
        if (this.proSvrVer < 5) {
            return null;
        }
        byte by = this.meg.types.getRep((byte)1);
        this.meg.types.setRep((byte)1, (byte)0);
        int n3 = this.meg.unmarshalUB2();
        this.meg.types.setRep((byte)1, by);
        byte[] byArray = this.meg.unmarshalNBytes(n3);
        int n4 = 6 + (byArray[5] & 0xFF) + (byArray[6] & 0xFF);
        this.NCHAR_CHARSET = (short)((byArray[n4 + 3] & 0xFF) << 8);
        this.NCHAR_CHARSET = (short)(this.NCHAR_CHARSET | (short)(byArray[n4 + 4] & 0xFF));
        if (this.proSvrVer < 6) {
            return null;
        }
        int n5 = this.meg.unmarshalUB1();
        byte[] byArray2 = new byte[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            byArray2[n2] = (byte)this.meg.unmarshalUB1();
        }
        n5 = this.meg.unmarshalUB1();
        if (n5 > 0) {
            this.runtimeCapabilities = new byte[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                this.runtimeCapabilities[n2] = (byte)this.meg.unmarshalUB1();
            }
        }
        return byArray2;
    }

    short getOracleVersion() {
        return this.oVersion;
    }

    byte[] getServerRuntimeCapabilities() {
        return this.runtimeCapabilities;
    }

    short getCharacterSet() {
        return this.svrCharSet;
    }

    short getncharCHARSET() {
        return this.NCHAR_CHARSET;
    }

    byte getFlags() {
        return this.svrFlags;
    }

    void marshal() throws SQLException, IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC8);
        this.meg.marshalB1Array(this.proCliStrTTC8);
    }

    void printServerInfo() {
        if (this.svrInfoAvailable) {
            int n2 = 0;
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("Protocol string  =");
            while (n2 < this.proSvrStr.length) {
                stringWriter.write((char)this.proSvrStr[n2++]);
            }
        }
    }
}

