/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.WebEnv;
import org.compiere.wstore.JSPEnv;

public class Counter
extends HttpServlet
implements Runnable {
    private static CLogger log = CLogger.getCLogger(Counter.class);
    public static final String NAME = "counter";
    private List<HttpServletRequest> m_requests = Collections.synchronizedList(new ArrayList());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("Counter.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Counter";
    }

    public void destroy() {
        log.info("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.m_requests.add(request);
        new Thread(this).start();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void run() {
        long time = System.currentTimeMillis();
        HttpServletRequest request = null;
        if (this.m_requests.size() > 0) {
            request = this.m_requests.remove(0);
        }
        if (request == null) {
            log.log(Level.SEVERE, "Nothing in queue");
            return;
        }
        Ctx ctx = JSPEnv.getCtx(request);
        String ref = request.getHeader("referer");
        if (ref == null || ref.length() == 0) {
            ref = request.getRequestURL().toString();
        }
        log.info("Referer=" + request.getHeader("referer") + " - URL=" + request.getRequestURL());
    }
}

