/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.BshClassManager;
import bsh.ClassPathException;
import bsh.Interpreter;
import bsh.UtilEvalError;
import bsh.classpath.BshClassLoader;
import bsh.classpath.BshClassPath;
import bsh.classpath.DiscreteFilesClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassManagerImpl
extends BshClassManager {
    static final String BSH_PACKAGE = "bsh";
    private BshClassPath baseClassPath;
    private boolean superImport;
    private BshClassPath fullClassPath;
    private Vector listeners = new Vector();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private BshClassLoader baseLoader;
    private Map loaderMap;
    static /* synthetic */ Class class$bsh$Interpreter;

    public ClassManagerImpl() {
        this.reset();
    }

    public Class classForName(String string) {
        ClassLoader classLoader;
        Class<?> clazz = (Class<?>)this.absoluteClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.absoluteNonClasses.get(string) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("absoluteNonClass list hit: " + string);
            }
            return null;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Trying to load class: " + string);
        }
        if ((classLoader = this.getLoaderForClass(string)) != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw BshClassManager.noClassDefFound(string, noClassDefFoundError);
            }
        }
        if (clazz == null) {
            if (string.startsWith(BSH_PACKAGE)) {
                try {
                    clazz = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = ClassManagerImpl.class$("bsh.Interpreter")) : class$bsh$Interpreter).getClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (this.baseLoader != null) {
                try {
                    clazz = this.baseLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    clazz = this.plainClassForName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        this.cacheClassInfo(string, clazz);
        return clazz;
    }

    public Class plainClassForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return Class.forName(string, true, classLoader);
        }
        return super.plainClassForName(string);
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.baseLoader != null) {
            uRL = this.baseLoader.getResource(string.substring(1));
        }
        if (uRL == null) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.baseLoader != null) {
            inputStream = this.baseLoader.getResourceAsStream(string.substring(1));
        }
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(string);
        }
        return inputStream;
    }

    ClassLoader getLoaderForClass(String string) {
        return (ClassLoader)this.loaderMap.get(string);
    }

    public void addClassPath(URL uRL) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL);
            this.classLoaderChanged();
        }
    }

    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader((BshClassManager)this, this.baseClassPath);
    }

    public void reloadClasses(String[] stringArray) throws ClassPathException {
        Object object2;
        Object object3;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        int n = 0;
        while (n < stringArray.length) {
            object3 = stringArray[n];
            this.baseClassPath.insureInitialized();
            object2 = this.baseClassPath.getClassSource((String)object3);
            if (object2 == null) {
                BshClassPath.getUserClassPath().insureInitialized();
                object2 = BshClassPath.getUserClassPath().getClassSource((String)object3);
            }
            if (object2 == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object3);
            }
            if (!(object2 instanceof BshClassPath.DirClassSource)) {
                throw new ClassPathException("Cannot reload class: " + (String)object3 + " from source: " + object2);
            }
            classSourceMap.put((String)object3, ((BshClassPath.DirClassSource)object2).getDir());
            ++n;
        }
        object3 = new DiscreteFilesClassLoader((BshClassManager)this, classSourceMap);
        object2 = classSourceMap.keySet().iterator();
        while (object2.hasNext()) {
            this.loaderMap.put((String)object2.next(), object3);
        }
        this.classLoaderChanged();
    }

    public void reloadPackage(String string) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string);
        }
        this.reloadClasses(set.toArray(new String[0]));
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    public void doSuperImport() throws UtilEvalError {
        try {
            this.getClassPath().insureInitialized();
            this.getClassNameByUnqName("");
        }
        catch (ClassPathException classPathException) {
            throw new UtilEvalError("Error importing classpath " + classPathException);
        }
        this.superImport = true;
    }

    protected boolean hasSuperImport() {
        return this.superImport;
    }

    public String getClassNameByUnqName(String string) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string);
    }

    public void addListener(BshClassManager.Listener listener) {
        Reference reference;
        this.listeners.addElement(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
        while ((reference = this.refQueue.poll()) != null) {
            boolean bl = this.listeners.removeElement(reference);
            if (bl || !Interpreter.DEBUG) continue;
            Interpreter.debug("tried to remove non-existent weak ref: " + reference);
        }
    }

    public void removeListener(BshClassManager.Listener listener) {
        throw new Error("unimplemented");
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    protected void classLoaderChanged() {
        Object object2;
        this.clearCaches();
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (WeakReference)enumeration.nextElement();
            BshClassManager.Listener listener = (BshClassManager.Listener)((Reference)object2).get();
            if (listener == null) {
                vector.add(object2);
                continue;
            }
            listener.classLoaderChanged();
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            this.listeners.removeElement(object2.nextElement());
        }
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Bsh Class Manager Dump: ");
        printWriter.println("----------------------- ");
        printWriter.println("baseLoader = " + this.baseLoader);
        printWriter.println("loaderMap= " + this.loaderMap);
        printWriter.println("----------------------- ");
        printWriter.println("baseClassPath = " + this.baseClassPath);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

