/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.ssl;

import com.sfcommerce.jpaymentcomponent.definitions.Definitions;
import com.sfcommerce.jpaymentcomponent.exceptions.CantConnectToServerException;
import com.sfcommerce.jpaymentcomponent.exceptions.CantTunnelThroughProxyException;
import com.sfcommerce.jpaymentcomponent.exceptions.CipherSuiteRefusedByServerException;
import com.sfcommerce.jpaymentcomponent.exceptions.CommunicationErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.ConfigNotInitializedException;
import com.sfcommerce.jpaymentcomponent.exceptions.ConnectionRefusedException;
import com.sfcommerce.jpaymentcomponent.exceptions.HostUnknownException;
import com.sfcommerce.jpaymentcomponent.exceptions.HttpErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.IncorrectParametersException;
import com.sfcommerce.jpaymentcomponent.exceptions.InternalServerErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidHTTPHeaderException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidRetriesException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidTimeoutException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidURLException;
import com.sfcommerce.jpaymentcomponent.exceptions.NullParameterException;
import com.sfcommerce.jpaymentcomponent.exceptions.RequestNotCompletedException;
import com.sfcommerce.jpaymentcomponent.exceptions.ServerCertifNotTrustedException;
import com.sfcommerce.jpaymentcomponent.exceptions.SocketCreationFailedException;
import com.sfcommerce.jpaymentcomponent.exceptions.SocketIOException;
import com.sfcommerce.jpaymentcomponent.exceptions.UnsupportedCipherSuiteException;
import com.sfcommerce.jpaymentcomponent.messages.ErrorsMsg;
import com.sfcommerce.jpaymentcomponent.ssl.SSLServerConnection;
import com.sfcommerce.jpaymentcomponent.ssl.ServerResponse;
import com.sfcommerce.jpaymentcomponent.ssl.SfCommerceTrustManagerImpl;
import com.sfcommerce.jpaymentcomponent.utilities.Config;
import com.sfcommerce.jpaymentcomponent.utilities.EventLog;
import com.sfcommerce.jpaymentcomponent.utilities.HttpHeader;
import com.sfcommerce.jpaymentcomponent.utilities.HttpRFC1866Encoder;
import com.sfcommerce.jpaymentcomponent.utilities.HttpResponseHeader;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Encoder;

public class SSLComm
implements ErrorsMsg,
Definitions {
    private static final String STATUS = "status=";
    private static final String CONNECTION_CLOSED = "Connection: ";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization: Basic ";
    private boolean server_Auth = false;
    String myResponse = null;
    String myHostname = null;
    int myPort = 0;

    public SSLComm() {
        if (System.getProperty("javax.net.ssl.trustStore") != null && System.getProperty("javax.net.ssl.trustStore").length() > 0) {
            this.server_Auth = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean send(String aURL, int aPort, String aRequest, boolean aRecovery, ServerResponse aServResponse) throws IncorrectParametersException, HostUnknownException, CantConnectToServerException, NullParameterException, CommunicationErrorException, SocketCreationFailedException, SocketIOException, ConfigNotInitializedException, InvalidTimeoutException, InvalidRetriesException, InvalidURLException, UnsupportedCipherSuiteException, CipherSuiteRefusedByServerException, ConnectionRefusedException, CantTunnelThroughProxyException, ServerCertifNotTrustedException, HttpErrorException {
        boolean bRet;
        boolean excepOccured;
        block66: {
            int bytesRead;
            BufferedReader dataIn;
            PrintWriter dataOut;
            SSLSocket sslSocket;
            block65: {
                sslSocket = null;
                SSLSocketFactory factory = null;
                int timeOut = 0;
                int retries = 0;
                dataOut = null;
                dataIn = null;
                excepOccured = false;
                Object strResponse = null;
                String[] cipherSuites = null;
                bRet = true;
                bytesRead = 0;
                boolean bProxyUsed = false;
                aServResponse.setFLookupFlag(false);
                if (aURL == null) {
                    throw new IncorrectParametersException("  ERROR(71) Url should be non null string.");
                }
                if (aPort <= 0) {
                    throw new IncorrectParametersException("  ERROR(69) Port number should be a positive integer.");
                }
                if (aRequest == null) {
                    throw new NullParameterException(" Request should be non null string");
                }
                this.myHostname = this.getHostNameFromURL(aURL);
                this.myPort = aPort;
                if (Config.getProperty("ProxyServer") != null && Config.getProperty("ProxyServer").length() > 0 && Config.getProperty("ProxyPort") != null && Config.getProperty("ProxyPort").length() > 0) {
                    bProxyUsed = true;
                }
                String encodedRequest = HttpRFC1866Encoder.encode(aRequest);
                String header = HttpHeader.build(aURL, new Integer(aPort), new Integer(encodedRequest.length()));
                StringBuffer message = new StringBuffer(header);
                message.append(encodedRequest);
                try {
                    timeOut = Integer.parseInt(Config.getProperty("Timeout")) * 1000;
                }
                catch (NumberFormatException nfe1) {
                    throw new InvalidTimeoutException("  ERROR(109) Timeout parameter  is invalid.");
                }
                if (timeOut < 0) {
                    throw new InvalidTimeoutException("  ERROR(109) Timeout parameter  is invalid.");
                }
                try {
                    retries = Integer.parseInt(Config.getProperty("Retries"));
                }
                catch (NumberFormatException nfe2) {
                    throw new InvalidRetriesException("  ERROR(110) Retries parameter  is invalid.");
                }
                if (retries < 0) {
                    throw new InvalidRetriesException("  ERROR(109) Timeout parameter  is invalid.");
                }
                if (bProxyUsed) {
                    Socket socket = this.connectThroughProxy();
                    if (this.server_Auth) {
                        factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    } else {
                        try {
                            SfCommerceTrustManagerImpl tm = new SfCommerceTrustManagerImpl();
                            KeyManager[] km = null;
                            TrustManager[] tma = new TrustManager[]{tm};
                            SSLContext sc = SSLContext.getInstance((String)"SSL");
                            sc.init(km, tma, new SecureRandom());
                            factory = sc.getSocketFactory();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    try {
                        sslSocket = (SSLSocket)factory.createSocket(socket, this.myHostname, this.myPort, true);
                    }
                    catch (UnknownHostException uhe) {
                        throw new HostUnknownException("  ERROR(73) Server name you specified is unknown.");
                    }
                    catch (ConnectException conex) {
                        throw new HostUnknownException("  ERROR(115) Connection refused by server. Check your PaymentServerPort.");
                    }
                    catch (SocketException sockex) {
                        throw new SocketCreationFailedException("  ERROR(120) Connection refused by Server. Check the location of your TrustManager keystore");
                    }
                    catch (IOException ioex) {
                        throw new SocketCreationFailedException("  ERROR(74) Socket creation failed, please try later.");
                    }
                }
                sslSocket = this.connectToPaymentServer(timeOut, retries);
                try {
                    if (Config.getProperty("Cipher").length() > 0) {
                        cipherSuites = new String[]{Config.getProperty("Cipher")};
                        sslSocket.setEnabledCipherSuites(cipherSuites);
                    }
                }
                catch (ConfigNotInitializedException note) {
                    throw note;
                }
                catch (IllegalArgumentException iae) {
                    throw new UnsupportedCipherSuiteException("  ERROR(107) The cipher you specified is not supported.");
                }
                try {
                    sslSocket.setSoTimeout(timeOut);
                }
                catch (SocketException sockEx) {
                    EventLog.log(0, "Can't set the Timeout for the value specified in your Config. File.");
                }
                try {
                    sslSocket.startHandshake();
                }
                catch (Exception e3) {
                    throw new ServerCertifNotTrustedException("  ERROR(121) Server certificate chain not trusted (" + e3.toString() + ")");
                }
                try {
                    dataIn = new BufferedReader(new InputStreamReader(sslSocket.getInputStream()));
                    dataOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sslSocket.getOutputStream())));
                }
                catch (IOException ioex) {
                    excepOccured = true;
                    throw new SocketIOException("  ERROR(76) Socket error occured, please try later. (" + ioex.toString() + ")");
                }
                finally {
                    if (excepOccured) {
                        try {
                            sslSocket.close();
                            dataIn.close();
                            dataOut.close();
                        }
                        catch (IOException io) {}
                    }
                }
                dataOut.println(message.toString());
                dataOut.flush();
                StringBuffer strHeader = new StringBuffer("");
                String strResp = null;
                char[] buffer = new char[8192];
                int nbread = 0;
                int index1 = 0;
                int index2 = 0;
                while ((strResp = dataIn.readLine()) != null && strResp.length() > 0) {
                    strHeader.append(strResp);
                    strResp = null;
                }
                HttpResponseHeader.isOK(strHeader.toString().trim());
                if (this.needMoreReadLine(strHeader.toString().trim())) {
                    this.myResponse = dataIn.readLine();
                    break block65;
                }
                nbread = dataIn.read(buffer);
                int i2 = 0;
                while (i2 < nbread) {
                    if (buffer[i2] == '\n') {
                        if (index2 == 0) {
                            index2 = i2;
                        } else {
                            index1 = index2;
                            index2 = i2;
                        }
                    }
                    ++i2;
                }
                this.myResponse = new String(buffer, index1, nbread - index1).trim();
            }
            Object var30_50 = null;
            try {
                sslSocket.close();
                dataIn.close();
                dataOut.close();
            }
            catch (IOException io) {}
            break block66;
            {
                catch (InterruptedIOException intioex) {
                    EventLog.log(1, "  ERROR(78) Communication error occured. Can't read the response for the TimeOut value specified in your configuration file.");
                    excepOccured = true;
                    Object var30_51 = null;
                    try {
                        sslSocket.close();
                        dataIn.close();
                        dataOut.close();
                    }
                    catch (IOException io) {}
                    break block66;
                }
                catch (IOException ioexcep) {
                    if (bytesRead == -1) {
                        excepOccured = true;
                    }
                    Object var30_52 = null;
                    try {
                        sslSocket.close();
                        dataIn.close();
                        dataOut.close();
                    }
                    catch (IOException io) {}
                    break block66;
                }
                catch (RequestNotCompletedException rncexp) {
                    EventLog.log(1, rncexp.getMessage());
                    excepOccured = true;
                    Object var30_53 = null;
                    try {
                        sslSocket.close();
                        dataIn.close();
                        dataOut.close();
                    }
                    catch (IOException io) {}
                    break block66;
                }
                catch (InternalServerErrorException isexp) {
                    EventLog.log(1, isexp.getMessage());
                    excepOccured = true;
                    Object var30_54 = null;
                    try {
                        sslSocket.close();
                        dataIn.close();
                        dataOut.close();
                    }
                    catch (IOException io) {}
                    break block66;
                }
                catch (InvalidHTTPHeaderException ihttph) {
                    EventLog.log(1, ihttph.getMessage());
                    excepOccured = true;
                    Object var30_55 = null;
                    try {
                        sslSocket.close();
                        dataIn.close();
                        dataOut.close();
                    }
                    catch (IOException io) {}
                }
            }
            catch (Throwable throwable) {
                Object var30_56 = null;
                try {
                    sslSocket.close();
                    dataIn.close();
                    dataOut.close();
                }
                catch (IOException io) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (!excepOccured) {
            this.myResponse = HttpRFC1866Encoder.decode(this.myResponse);
            aServResponse.setResponse(this.myResponse);
            bRet = true;
        } else {
            bRet = false;
            if (aRecovery) {
                aServResponse.setFLookupFlag(true);
            }
        }
        return bRet;
    }

    private String getHostNameFromURL(String aURL) throws InvalidURLException {
        try {
            int begIndex = aURL.indexOf("//");
            int endIndex = aURL.indexOf("/", begIndex += 2);
            return aURL.substring(begIndex, endIndex);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new InvalidURLException("  ERROR(88) Invalid URL.");
        }
    }

    private boolean needMoreReadLine(String szHeader) {
        return false;
    }

    private Socket connectThroughProxy() throws HostUnknownException, SocketCreationFailedException, CantConnectToServerException, ConfigNotInitializedException, CantTunnelThroughProxyException {
        Socket proxySocket = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            proxySocket = new Socket(Config.getProperty("ProxyServer"), Integer.parseInt(Config.getProperty("ProxyPort")));
            in = proxySocket.getInputStream();
            out = proxySocket.getOutputStream();
            String strPort = String.valueOf(this.myPort);
            StringBuffer conn = new StringBuffer("CONNECT " + this.myHostname + ":" + strPort + " HTTP/");
            conn.append(Config.getProperty("HTTPVersion"));
            conn.append("\n");
            conn.append("User-Agent: jPayment Proxy Enabled SSL Socket\n");
            try {
                if (Config.getProperty("ProxyUserId") != null && Config.getProperty("ProxyPwd") != null) {
                    StringBuffer proxyAuthStr = new StringBuffer(PROXY_AUTHORIZATION);
                    BASE64Encoder B64Encoder = new BASE64Encoder();
                    String pwd = Config.getProperty("ProxyUserId") + ":" + Config.getProperty("ProxyPwd");
                    proxyAuthStr.append(B64Encoder.encode(pwd.getBytes()));
                    proxyAuthStr.append("\n\n");
                    conn.append(proxyAuthStr.toString());
                } else {
                    conn.append("\n");
                }
            }
            catch (ConfigNotInitializedException confex) {
                confex.printStackTrace();
            }
            out.write(conn.toString().getBytes("ASCII7"));
            out.flush();
            byte[] msg = new byte[2048];
            int rdData = in.read(msg);
            String resp = new String(msg);
            if (resp.indexOf("200 Connection established") == -1) {
                throw new CantTunnelThroughProxyException("  ERROR(117) Unable to tunnel through Proxy server.  " + resp.substring(0, resp.indexOf(10)));
            }
            return proxySocket;
        }
        catch (UnknownHostException uknhost) {
            throw new HostUnknownException("  ERROR(118) Proxy Server you specified is unknown.");
        }
        catch (ConnectException connex) {
            throw new HostUnknownException("  ERROR(119) Connection refused by Proxy Server. Check your ProxyServerPort.");
        }
        catch (IOException ioex) {
            throw new SocketCreationFailedException("  ERROR(74) Socket creation failed, please try later. (" + ioex.toString() + ")");
        }
        catch (ConfigNotInitializedException note) {
            throw note;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocket connectToPaymentServer(int aTimeOut, int aRetries) throws HostUnknownException, SocketCreationFailedException, CantConnectToServerException {
        SSLSocket sslSocket = null;
        SocketFactory factory = null;
        boolean bExceptionOccured = false;
        boolean bExit = false;
        if (this.server_Auth) {
            factory = SSLSocketFactory.getDefault();
        } else {
            try {
                SfCommerceTrustManagerImpl tm = new SfCommerceTrustManagerImpl();
                KeyManager[] km = null;
                TrustManager[] tma = new TrustManager[]{tm};
                SSLContext sc = SSLContext.getInstance((String)"SSL");
                sc.init(km, tma, new SecureRandom());
                factory = sc.getSocketFactory();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        int i2 = 1;
        while (i2 <= aRetries) {
            bExceptionOccured = false;
            try {
                SSLServerConnection serverCon = new SSLServerConnection(factory);
                sslSocket = serverCon.connect(this.myHostname, this.myPort, aTimeOut);
            }
            catch (HostUnknownException uhex) {
                bExceptionOccured = true;
                bExit = true;
                throw uhex;
            }
            catch (SocketCreationFailedException scex) {
                bExceptionOccured = true;
                if (i2 == aRetries) {
                    bExit = true;
                    throw scex;
                }
            }
            catch (InterruptedIOException ie) {
                bExceptionOccured = true;
                if (i2 == aRetries) {
                    bExit = true;
                    throw new CantConnectToServerException("  ERROR(75) Can't connect to Server for Timeout value specified. Retry later.");
                }
            }
            finally {
                if (!bExceptionOccured) break;
                if (i2 >= aRetries || bExit) {
                    // empty if block
                }
            }
            ++i2;
        }
        return sslSocket;
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider((java.security.Provider)new Provider());
        try {
            if (Config.getProperty("Keystore") != null && Config.getProperty("Keystore").length() > 0) {
                System.setProperty("javax.net.ssl.trustStore", Config.getProperty("Keystore"));
            }
        }
        catch (Exception e2) {}
    }
}

