/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.util.CellReference;

public class AreaReference {
    private CellReference[] cells;
    private int dim;

    public AreaReference(String reference) {
        String[] refs = this.seperateAreaRefs(reference);
        this.dim = refs.length;
        this.cells = new CellReference[this.dim];
        for (int i2 = 0; i2 < this.dim; ++i2) {
            this.cells[i2] = new CellReference(refs[i2]);
        }
    }

    public int getDim() {
        return this.dim;
    }

    public CellReference[] getCells() {
        return this.cells;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        for (int i2 = 0; i2 < this.dim; ++i2) {
            retval.append(':');
            retval.append(this.cells[i2].toString());
        }
        retval.deleteCharAt(0);
        return retval.toString();
    }

    private String[] seperateAreaRefs(String reference) {
        String[] retval = null;
        int length = reference.length();
        int loc = reference.indexOf(58, 0);
        if (loc == -1) {
            retval = new String[]{reference};
        } else {
            retval = new String[2];
            int sheetStart = reference.indexOf("!");
            retval[0] = reference.substring(0, sheetStart + 1) + reference.substring(sheetStart + 1, loc);
            retval[1] = reference.substring(0, sheetStart + 1) + reference.substring(loc + 1);
        }
        return retval;
    }
}

