/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;

public class RequestParser {
    private static HttpUtils parser = new HttpUtils();

    public static Hashtable parse(HttpServletRequest request) throws IOException, ParseException {
        BufferedReader reader = request.getReader();
        reader.mark(request.getContentLength() + 1);
        String encodedRequestString = reader.readLine();
        reader.reset();
        return RequestParser.parse(encodedRequestString);
    }

    public static Hashtable parse(String urlEncodedString) throws ParseException {
        try {
            Hashtable params = HttpUtils.parseQueryString((String)urlEncodedString);
            Enumeration enumeration = params.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object obj = params.get(key);
                String[] value = (String[])obj;
                if (value.length > 0) {
                    params.put(key, value[0].trim());
                    continue;
                }
                params.put(key, "");
            }
            return params;
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Undecodable URL character sequence detected in POST or GET request. Verify that request being sent conforms to HTTP URL encoded standard.", 0);
        }
    }
}

