/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.ldap;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.AuthenticationException;
import javax.naming.ldap.InitialLdapContext;
import org.compiere.ldap.LdapMessage;
import org.compiere.ldap.LdapResult;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MLdapUser;
import org.compiere.util.CLogger;

public class LdapConnectionHandler
extends Thread {
    private Socket m_socket = null;
    private MLdapProcessor m_model = null;
    private static CLogger log = CLogger.getCLogger(LdapConnectionHandler.class);

    public LdapConnectionHandler(Socket socket, MLdapProcessor model) {
        try {
            this.m_socket = socket;
            this.m_socket.setTcpNoDelay(true);
            this.m_model = model;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public void run() {
        try {
            if (this.m_socket == null || this.m_socket.isClosed()) {
                return;
            }
            LdapMessage msg = new LdapMessage();
            MLdapUser ldapUser = new MLdapUser();
            LdapResult result = new LdapResult();
            boolean activeSession = true;
            while (activeSession) {
                InputStream in = this.m_socket.getInputStream();
                BufferedOutputStream out = new BufferedOutputStream(this.m_socket.getOutputStream());
                byte[] buffer = new byte[512];
                int length = in.read(buffer, 0, 512);
                result.reset(msg, ldapUser);
                msg.reset(result);
                msg.decode(buffer, length);
                if (msg.getOperation() == 98) {
                    out.close();
                } else {
                    byte[] bytes = result.getResult(this.m_model, this.m_socket.getInetAddress().getHostName(), this.m_socket.getInetAddress().getHostAddress());
                    out.write(bytes);
                    out.flush();
                    if (!result.getDone()) continue;
                    out.close();
                }
                break;
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        try {
            this.m_socket.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Socket", e);
        }
        this.m_socket = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LdapConnectionHandler[");
        sb.append(this.hashCode()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://10.104.139.160:389");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "cn=cboss@compiere.org,o=GardenWorld,ou=LawnCare");
        env.put("java.naming.security.credentials", "carlboss");
        try {
            new InitialLdapContext(env, null);
            System.out.println("Successfully authenticated ...");
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

