/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.server.CompiereServer;
import org.compiere.util.Ctx;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class Scheduler
extends CompiereServer {
    private MScheduler m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private Trx m_trx = null;

    public Scheduler(MScheduler model) {
        super(model, 240);
        this.m_model = model;
    }

    protected void doWork() {
        this.m_summary = new StringBuffer(this.m_model.toString()).append(" - ");
        MProcess process = this.m_model.getProcess();
        try {
            Ctx ctx = this.m_model.getCtx();
            ctx.setAD_Client_ID(this.m_model.getAD_Client_ID());
            ctx.setContext("AD_Client_ID", this.m_model.getAD_Client_ID());
            ctx.setAD_Org_ID(this.m_model.getAD_Org_ID());
            ctx.setContext("AD_Org_ID", this.m_model.getAD_Org_ID());
            ctx.setAD_User_ID(this.m_model.getUpdatedBy());
            ctx.setContext("AD_User_ID", this.m_model.getUpdatedBy());
            ctx.setContext("#SalesRep_ID", this.m_model.getUpdatedBy());
            this.m_trx = Trx.get(Trx.createTrxName("Scheduler"), true);
            this.m_summary.append(this.m_model.execute(this.m_trx));
            this.m_trx.commit();
        }
        catch (Exception e) {
            if (this.m_trx != null) {
                this.m_trx.rollback();
            }
            this.log.log(Level.WARNING, process.toString(), e);
            this.m_summary.append(e.toString());
        }
        if (this.m_trx != null) {
            this.m_trx.close();
        }
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

