/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jCharts.Chart;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.encoders.JPEGEncoder;
import org.jCharts.encoders.JPEGEncoder13;
import org.jCharts.encoders.PNGEncoder;
import org.jCharts.encoders.SVGEncoder;
import org.jCharts.test.AxisChartTestBase;
import org.jCharts.test.StockTestDriver;

public final class ChartTestDriver {
    private static final String SVG = ".svg";
    private static final String PNG = ".png";
    private static final String JPEG = ".jpg";
    private static final String JPEG_LEGACY = ".jpeg";
    static final String OUTPUT_PATH = "./";
    static final String EXTENSION = ".jpeg";

    public static void main(String[] stringArray) throws ChartDataException {
        AxisChartTestBase.axisChartTest("stockChart", new StockTestDriver());
    }

    static void exportImage(Chart chart, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (".jpeg".equals(SVG)) {
                SVGEncoder.encode(chart, fileOutputStream);
            } else if (".jpeg".equals(PNG)) {
                PNGEncoder.encode(chart, fileOutputStream);
            } else if (".jpeg".equals(JPEG)) {
                JPEGEncoder.encode(chart, 1.0f, fileOutputStream);
            } else if (".jpeg".equals(".jpeg")) {
                JPEGEncoder13.encode(chart, 1.0f, fileOutputStream);
            } else {
                System.out.println("unknown file type to encode: .jpeg");
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

