/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.sso;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.tc5.sso.ClusteredSingleSignOn;
import org.jboss.web.tomcat.tc5.sso.SSOClusterManager;
import org.jboss.web.tomcat.tc5.sso.SingleSignOnEntry;
import org.jgroups.View;

public final class TreeCacheSSOClusterManager
implements SSOClusterManager,
TreeCacheListener {
    private static final String CREDENTIALS = "credentials";
    private static final String SSO = "SSO";
    private static final String SESSIONS = "sessions";
    private static final String KEY = "key";
    public static final String DEFAULT_GLOBAL_CACHE_NAME = "jboss.cache:service=TomcatClusteringCache";
    private static final String[] GET_SIGNATURE = new String[]{(class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCacheSSOClusterManager.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = TreeCacheSSOClusterManager.class$("java.lang.Object")) : class$java$lang$Object).getName()};
    private static final String[] PUT_SIGNATURE = new String[]{(class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCacheSSOClusterManager.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = TreeCacheSSOClusterManager.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = TreeCacheSSOClusterManager.class$("java.lang.Object")) : class$java$lang$Object).getName()};
    private static final String[] REMOVE_SIGNATURE = new String[]{(class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = TreeCacheSSOClusterManager.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn).getName()};
    private LinkedList beingLocallyAdded = new LinkedList();
    private LinkedList beingLocallyRemoved = new LinkedList();
    private LinkedList beingRemotelyRemoved = new LinkedList();
    private ObjectName cacheObjectName = null;
    private String cacheName = null;
    private CredentialUpdater credentialUpdater = null;
    private InitialContext initialContext = null;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private Logger log = Logger.getLogger((String)this.getClass().getName());
    private boolean registeredAsListener = false;
    private MBeanServer server = MBeanServerLocator.locate();
    private ClusteredSingleSignOn ssoValve = null;
    private boolean started = false;
    private boolean treeCacheAvailable = false;
    private boolean missingCacheErrorLogged = false;
    static /* synthetic */ Class class$org$jboss$cache$Fqn;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jboss$cache$TreeCacheListener;

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String objectName) throws Exception {
        if (objectName == null) {
            this.setCacheObjectName(null);
        } else if (!objectName.equals(this.cacheName)) {
            this.setCacheObjectName(new ObjectName(objectName));
        }
    }

    public ObjectName getCacheObjectName() {
        return this.cacheObjectName;
    }

    public void setCacheObjectName(ObjectName objectName) throws Exception {
        if (objectName != null && objectName.equals(this.cacheObjectName) || this.cacheObjectName != null && this.cacheObjectName.equals(objectName) || objectName == null && this.cacheObjectName == null) {
            return;
        }
        this.removeAsTreeCacheListener(this.cacheObjectName);
        this.cacheObjectName = objectName;
        String string = this.cacheName = objectName == null ? null : objectName.getCanonicalName();
        if (!this.isTreeCacheAvailable(true)) {
            if (this.started) {
                this.logMissingCacheError();
            } else {
                this.log.info((Object)("Cannot find TreeCache using " + this.cacheName + " -- tree" + "CacheName must be set to point to a running TreeCache " + "before ClusteredSingleSignOn can handle requests"));
            }
        }
    }

    public void addSession(String ssoId, Session session) {
        if (ssoId == null || session == null) {
            return;
        }
        if (!this.isTreeCacheAvailable(false)) {
            this.logMissingCacheError();
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addSession(): adding Session " + session.getId() + " to cached session set for SSO " + ssoId));
        }
        Fqn fqn = this.getSessionsFqn(ssoId);
        UserTransaction tx = null;
        try {
            tx = this.getNewTransaction();
            tx.begin();
            Set sessions = this.getSessionSet(fqn, true);
            sessions.add(session.getId());
            this.putInTreeCache(fqn, sessions);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            String sessId = session == null ? "NULL" : session.getId();
            this.log.error((Object)("caught exception adding session " + sessId + " to SSO id " + ssoId), (Throwable)e);
        }
    }

    public ClusteredSingleSignOn getSingleSignOnValve() {
        return this.ssoValve;
    }

    public void setSingleSignOnValve(ClusteredSingleSignOn valve) {
        this.ssoValve = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String ssoId) {
        if (!this.isTreeCacheAvailable(false)) {
            this.logMissingCacheError();
            return;
        }
        if (this.beingLocallyRemoved.contains(ssoId)) {
            return;
        }
        this.beingLocallyRemoved.add(ssoId);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering logout of SSO " + ssoId + " in clustered cache"));
        }
        Fqn fqn = this.getSingleSignOnFqn(ssoId);
        try {
            this.removeFromTreeCache(fqn);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception attempting to remove node " + fqn.toString() + " from TreeCache"), (Throwable)e);
        }
        finally {
            this.beingLocallyRemoved.remove(ssoId);
        }
    }

    public SingleSignOnEntry lookup(String ssoId) {
        if (!this.isTreeCacheAvailable(false)) {
            this.logMissingCacheError();
            return null;
        }
        SingleSignOnEntry entry = null;
        Fqn fqn = this.getCredentialsFqn(ssoId);
        try {
            SSOCredentials data = (SSOCredentials)this.getFromTreeCache(fqn);
            if (data != null) {
                entry = new SingleSignOnEntry(null, data.getAuthType(), data.getUsername(), data.getPassword());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("caught exception looking up SSOCredentials for SSO id " + ssoId), (Throwable)e);
        }
        return entry;
    }

    public void register(String ssoId, String authType, String username, String password) {
        if (!this.isTreeCacheAvailable(false)) {
            this.logMissingCacheError();
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String ssoId, Session session) {
        if (!this.isTreeCacheAvailable(false)) {
            this.logMissingCacheError();
            return;
        }
        if (this.beingRemotelyRemoved.contains(ssoId)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removeSession(): removing Session " + session.getId() + " from cached session set for SSO " + ssoId));
        }
        Fqn fqn = this.getSessionsFqn(ssoId);
        UserTransaction tx = null;
        boolean removing = false;
        try {
            tx = this.getNewTransaction();
            tx.begin();
            Set sessions = this.getSessionSet(fqn, false);
            if (sessions != null) {
                sessions.remove(session.getId());
                if (sessions.size() == 0) {
                    this.beingLocallyRemoved.add(ssoId);
                    removing = true;
                    this.removeFromTreeCache(this.getSingleSignOnFqn(ssoId));
                } else {
                    this.putInTreeCache(fqn, sessions);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            String sessId = session == null ? "NULL" : session.getId();
            this.log.error((Object)("caught exception removing session " + sessId + " from SSO id " + ssoId), (Throwable)e);
        }
        finally {
            if (removing) {
                this.beingLocallyRemoved.remove(ssoId);
            }
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        if (!this.isTreeCacheAvailable(false)) {
            this.logMissingCacheError();
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updating credentials for SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    public void nodeCreated(Fqn fqn) {
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(Fqn fqn) {
        String ssoId = this.getIdFromFqn(fqn);
        if (this.beingLocallyRemoved.contains(ssoId)) {
            return;
        }
        this.beingRemotelyRemoved.add(ssoId);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received a node removed message for SSO " + ssoId));
            }
            this.ssoValve.deregister(ssoId);
        }
        finally {
            this.beingRemotelyRemoved.remove(ssoId);
        }
    }

    public void nodeModified(Fqn fqn) {
        if (!CREDENTIALS.equals(this.getTypeFromFqn(fqn))) {
            return;
        }
        String ssoId = this.getIdFromFqn(fqn);
        if (this.beingLocallyAdded.contains(ssoId)) {
            return;
        }
        SingleSignOnEntry sso = this.ssoValve.localLookup(ssoId);
        if (sso == null || sso.getCanReauthenticate()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("received a credentials modified message for SSO " + ssoId));
        }
        this.credentialUpdater.enqueue(sso, ssoId);
    }

    public void viewChange(View new_view) {
    }

    public void nodeEvicted(Fqn fqn) {
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("TreeCacheSSOClusterManager already Started");
        }
        this.credentialUpdater = new CredentialUpdater();
        this.started = true;
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("TreeCacheSSOClusterManager not Started");
        }
        this.credentialUpdater.stop();
        this.started = false;
        this.lifecycle.fireLifecycleEvent("stop", null);
    }

    private Object getFromTreeCache(Fqn fqn) throws Exception {
        Object[] args = new Object[]{fqn, KEY};
        return this.server.invoke(this.getCacheObjectName(), "get", args, GET_SIGNATURE);
    }

    private Fqn getCredentialsFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid, CREDENTIALS};
        return new Fqn(objs);
    }

    private Fqn getSessionsFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid, SESSIONS};
        return new Fqn(objs);
    }

    private Fqn getSingleSignOnFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid};
        return new Fqn(objs);
    }

    private String getIdFromFqn(Fqn fqn) {
        return (String)fqn.get(1);
    }

    private InitialContext getInitialContext() throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext();
        }
        return this.initialContext;
    }

    private Set getSessionSet(Fqn fqn, boolean create) throws Exception {
        HashSet sessions = (HashSet)this.getFromTreeCache(fqn);
        if (create && sessions == null) {
            sessions = new HashSet();
        }
        return sessions;
    }

    private String getTypeFromFqn(Fqn fqn) {
        return (String)fqn.get(fqn.size() - 1);
    }

    private UserTransaction getNewTransaction() throws NamingException {
        try {
            UserTransaction t = (UserTransaction)this.getInitialContext().lookup("UserTransaction");
            return t;
        }
        catch (NamingException n) {
            this.initialContext = null;
            throw n;
        }
    }

    private synchronized boolean isTreeCacheAvailable(boolean forceCheck) {
        if (forceCheck || !this.treeCacheAvailable) {
            boolean available;
            boolean bl = available = this.cacheObjectName != null;
            if (available) {
                Set<ObjectInstance> s = this.server.queryMBeans(this.cacheObjectName, null);
                boolean bl2 = available = s.size() > 0;
                if (available) {
                    try {
                        this.registerAsTreeCacheListener(this.cacheObjectName);
                        this.setMissingCacheErrorLogged(false);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Caught exception registering as listener to " + this.cacheObjectName), (Throwable)e);
                        available = false;
                    }
                }
            }
            this.treeCacheAvailable = available;
        }
        return this.treeCacheAvailable;
    }

    private void putInTreeCache(Fqn fqn, Object data) throws Exception {
        Object[] args = new Object[]{fqn, KEY, data};
        this.server.invoke(this.getCacheObjectName(), "put", args, PUT_SIGNATURE);
    }

    private void registerAsTreeCacheListener(ObjectName listenTo) throws Exception {
        this.server.invoke(listenTo, "addTreeCacheListener", new Object[]{this}, new String[]{(class$org$jboss$cache$TreeCacheListener == null ? (class$org$jboss$cache$TreeCacheListener = TreeCacheSSOClusterManager.class$("org.jboss.cache.TreeCacheListener")) : class$org$jboss$cache$TreeCacheListener).getName()});
        this.registeredAsListener = true;
    }

    private void removeAsTreeCacheListener(ObjectName removeFrom) throws Exception {
        if (this.registeredAsListener && removeFrom != null) {
            this.server.invoke(removeFrom, "removeTreeCacheListener", new Object[]{this}, new String[]{(class$org$jboss$cache$TreeCacheListener == null ? (class$org$jboss$cache$TreeCacheListener = TreeCacheSSOClusterManager.class$("org.jboss.cache.TreeCacheListener")) : class$org$jboss$cache$TreeCacheListener).getName()});
        }
    }

    private void removeFromTreeCache(Fqn fqn) throws Exception {
        this.server.invoke(this.getCacheObjectName(), "remove", new Object[]{fqn}, REMOVE_SIGNATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSSOData(String ssoId, String authType, String username, String password) {
        SSOCredentials data = new SSOCredentials(authType, username, password);
        this.beingLocallyAdded.add(ssoId);
        try {
            this.putInTreeCache(this.getCredentialsFqn(ssoId), data);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception attempting to add TreeCache nodes for SSO " + ssoId), (Throwable)e);
        }
        finally {
            this.beingLocallyAdded.remove(ssoId);
        }
    }

    private boolean isMissingCacheErrorLogged() {
        return this.missingCacheErrorLogged;
    }

    private void setMissingCacheErrorLogged(boolean missingCacheErrorLogged) {
        this.missingCacheErrorLogged = missingCacheErrorLogged;
    }

    private void logMissingCacheError() {
        StringBuffer msg = new StringBuffer("Cannot find TreeCache using ");
        msg.append(this.getCacheName());
        msg.append(" -- TreeCache must be started before ClusteredSingleSignOn ");
        msg.append("can handle requests");
        if (this.isMissingCacheErrorLogged()) {
            this.log.warn((Object)msg);
        } else {
            this.log.error((Object)msg);
            this.setMissingCacheErrorLogged(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SSOCredentials
    implements Serializable {
        static final long serialVersionUID = 5704877226920571663L;
        private String authType = null;
        private String password = null;
        private String username = null;

        private SSOCredentials(String authType, String username, String password) {
            this.authType = authType;
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getAuthType() {
            return this.authType;
        }

        private String getPassword() {
            return this.password;
        }
    }

    private class SSOWrapper {
        private SingleSignOnEntry sso = null;
        private String id = null;

        private SSOWrapper(SingleSignOnEntry entry, String ssoId) {
            this.sso = entry;
            this.id = ssoId;
        }
    }

    private class CredentialUpdater
    implements Runnable {
        private HashSet awaitingUpdate = new HashSet();
        private Thread updateThread = new Thread((Runnable)this, "SSOClusterManager.CredentialUpdater");
        private boolean updateThreadSleeping = false;
        private boolean queueEmpty = true;
        private boolean stopped = false;

        private CredentialUpdater() {
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopped) {
                try {
                    this.updateThreadSleeping = false;
                    SSOWrapper[] ssos = null;
                    HashSet hashSet = this.awaitingUpdate;
                    synchronized (hashSet) {
                        ssos = new SSOWrapper[this.awaitingUpdate.size()];
                        ssos = this.awaitingUpdate.toArray(ssos);
                        this.awaitingUpdate.clear();
                        this.queueEmpty = true;
                    }
                    for (int i = 0; i < ssos.length; ++i) {
                        this.processUpdate(ssos[i]);
                    }
                    if (this.queueEmpty) {
                        try {
                            this.updateThreadSleeping = true;
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            if (!TreeCacheSSOClusterManager.this.log.isTraceEnabled()) continue;
                            TreeCacheSSOClusterManager.this.log.trace((Object)"CredentialUpdater: interrupted");
                        }
                        continue;
                    }
                    if (!TreeCacheSSOClusterManager.this.log.isTraceEnabled()) continue;
                    TreeCacheSSOClusterManager.this.log.trace((Object)"CredentialUpdater: more updates added while handling existing updates");
                }
                catch (Exception e) {
                    TreeCacheSSOClusterManager.this.log.error((Object)"CredentialUpdater thread caught an exception", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(SingleSignOnEntry sso, String ssoId) {
            HashSet hashSet = this.awaitingUpdate;
            synchronized (hashSet) {
                this.awaitingUpdate.add(new SSOWrapper(sso, ssoId));
                this.queueEmpty = false;
            }
            if (this.updateThreadSleeping) {
                this.updateThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUpdate(SSOWrapper wrapper) {
            block7: {
                if (wrapper.sso.getCanReauthenticate()) {
                    return;
                }
                Fqn fqn = TreeCacheSSOClusterManager.this.getCredentialsFqn(wrapper.id);
                try {
                    SSOCredentials data = (SSOCredentials)TreeCacheSSOClusterManager.this.getFromTreeCache(fqn);
                    if (data == null) break block7;
                    String authType = data.getAuthType();
                    String username = data.getUsername();
                    String password = data.getPassword();
                    if (TreeCacheSSOClusterManager.this.log.isTraceEnabled()) {
                        TreeCacheSSOClusterManager.this.log.trace((Object)("CredentialUpdater: Updating credentials for SSO " + wrapper.sso));
                    }
                    SingleSignOnEntry singleSignOnEntry = wrapper.sso;
                    synchronized (singleSignOnEntry) {
                        Principal p = wrapper.sso.getPrincipal();
                        wrapper.sso.updateCredentials(p, authType, username, password);
                    }
                }
                catch (Exception e) {
                    TreeCacheSSOClusterManager.this.log.error((Object)("Exception attempting to get SSOCredentials from TreeCache node " + fqn.toString()), (Throwable)e);
                }
            }
        }

        private void stop() {
            this.stopped = true;
        }
    }
}

