/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JCAConnectionFactory;
import org.jboss.management.j2ee.JCAResourceMBean;
import org.jboss.management.j2ee.statistics.JCAConnectionPoolStatsImpl;
import org.jboss.management.j2ee.statistics.JCAStatsImpl;

public class JCAResource
extends J2EEResource
implements JCAResourceMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JCAResource == null ? (class$org$jboss$management$j2ee$JCAResource = JCAResource.class$("org.jboss.management.j2ee.JCAResource")) : class$org$jboss$management$j2ee$JCAResource));
    private List connectionFactories = new ArrayList();
    private ObjectName cmServiceName;
    private ObjectName poolServiceName;
    private JCAStatsImpl stats;
    static /* synthetic */ Class class$org$jboss$management$j2ee$JCAResource;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName jsr77RAParentName, ObjectName cmServiceName, ObjectName mcfServiceName, ObjectName poolServiceName) {
        ObjectName jsr77Name = null;
        try {
            JCAResource jcaRes = new JCAResource(resName, jsr77RAParentName, cmServiceName, poolServiceName);
            jsr77Name = jcaRes.getObjectName();
            mbeanServer.registerMBean(jcaRes, jsr77Name);
            log.debug((Object)("Created JSR-77 JCAResource: " + resName));
            ObjectName jcaFactoryName = JCAConnectionFactory.create(mbeanServer, resName, jsr77Name, cmServiceName, mcfServiceName);
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JCAResource: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            ObjectName search = new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JCAResource" + "," + "name=" + resName + "," + "*");
            Set<ObjectName> resNames = mbeanServer.queryNames(search, null);
            if (!resNames.isEmpty()) {
                ObjectName jcaRes = resNames.iterator().next();
                String[] factories = (String[])mbeanServer.getAttribute(jcaRes, "connectionFactories");
                for (int n = 0; n < factories.length; ++n) {
                    ObjectName cf = new ObjectName(factories[n]);
                    mbeanServer.unregisterMBean(cf);
                    Hashtable<String, String> props = cf.getKeyPropertyList();
                    props.put("j2eeType", "JCAManagedConnectionFactory");
                    props.remove("JCAResource");
                    ObjectName mcf = new ObjectName(cf.getDomain(), props);
                    mbeanServer.unregisterMBean(mcf);
                }
                mbeanServer.unregisterMBean(jcaRes);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Could not destroy JSR-77 JCAResource", (Throwable)e);
        }
    }

    public JCAResource(String resName, ObjectName jsr77ParentName, ObjectName cmServiceName, ObjectName poolServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("JCAResource", resName, jsr77ParentName);
        this.cmServiceName = cmServiceName;
        this.poolServiceName = poolServiceName;
    }

    public String[] getconnectionFactories() {
        return this.connectionFactories.toArray(new String[this.connectionFactories.size()]);
    }

    public String getconnectionFactory(int i) {
        if (i >= 0 && i < this.connectionFactories.size()) {
            return (String)this.connectionFactories.get(i);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JCAConnectionFactory".equals(lType)) {
            this.connectionFactories.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JCAConnectionFactory".equals(lType)) {
            this.connectionFactories.remove(pChild.getCanonicalName());
        }
    }

    public Stats getstats() {
        try {
            ObjectName jsr77CFName = JCAResource.newObjectName(this.getconnectionFactory(0));
            Object[] params = new Object[]{this.poolServiceName};
            String[] sig = new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JCAResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()};
            JCAConnectionPoolStatsImpl cfStats = (JCAConnectionPoolStatsImpl)this.server.invoke(jsr77CFName, "getPoolStats", params, sig);
            JCAConnectionPoolStats[] poolStats = new JCAConnectionPoolStatsImpl[]{cfStats};
            this.stats = new JCAStatsImpl(null, poolStats);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to create JCAStats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        if (this.stats != null) {
            this.stats.reset();
        }
    }

    public String toString() {
        return "JCAResource { " + super.toString() + " } [ " + "Connection Factories: " + this.connectionFactories + " ]";
    }

    protected Hashtable getParentKeys(ObjectName parentName) {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        Hashtable<String, String> nameProps = parentName.getKeyPropertyList();
        String adapterName = nameProps.get("name");
        String serverName = nameProps.get("J2EEServer");
        keys.put("J2EEServer", serverName);
        keys.put("ResourceAdapter", adapterName);
        return keys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

