/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxtags.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.ajaxtags.helpers.AjaxHtmlHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

public class AjaxAreaTag
extends BodyTagSupport {
    private String ajaxFlag = "ajax";
    private String style;
    private String styleClass;
    private String ajaxAnchors = "false";
    private boolean ajax = false;

    public String getAjaxFlag() {
        return this.ajaxFlag;
    }

    public void setAjaxFlag(String ajaxFlag) {
        this.ajaxFlag = ajaxFlag;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getAjaxAnchors() {
        return this.ajaxAnchors;
    }

    public void setAjaxAnchors(String ajaxAnchors) {
        this.ajaxAnchors = ajaxAnchors;
    }

    public int doStartTag() throws JspException {
        this.initParameters();
        if (this.ajax) {
            try {
                this.pageContext.getOut().clearBuffer();
            }
            catch (IOException ex) {
                throw new JspException(ex.getMessage());
            }
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.print("<div");
            if (StringUtils.isNotBlank((String)this.id)) {
                out.print(" id='" + this.id + "'");
            }
            if (StringUtils.isNotBlank((String)this.styleClass)) {
                out.print(" class='" + this.styleClass + "'");
            }
            if (StringUtils.isNotBlank((String)this.style)) {
                out.print(" style='" + this.style + "'");
            }
            out.print(">");
        }
        catch (IOException ex) {
            throw new JspException(ex.getMessage());
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        String body = this.bodyContent.getString();
        try {
            body = this.processContent(body);
            out.println(body);
            if (!this.ajax) {
                out.println("</div>");
            }
        }
        catch (IOException ex) {
            throw new JspException(ex.getMessage());
        }
        return this.ajax ? 5 : 6;
    }

    public void release() {
        this.ajaxFlag = null;
        this.style = null;
        this.ajaxAnchors = null;
        this.styleClass = null;
        super.release();
    }

    protected void initParameters() throws JspException {
        if (this.ajaxFlag != null) {
            this.ajaxFlag = (String)ExpressionEvaluatorManager.evaluate((String)"ajaxFlag", (String)this.ajaxFlag, (Class)String.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (this.style != null) {
            this.style = (String)ExpressionEvaluatorManager.evaluate((String)"style", (String)this.style, (Class)String.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (this.styleClass != null) {
            this.styleClass = (String)ExpressionEvaluatorManager.evaluate((String)"styleClass", (String)this.styleClass, (Class)String.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (this.ajaxAnchors != null) {
            this.ajaxAnchors = (String)ExpressionEvaluatorManager.evaluate((String)"ajaxAnchors", (String)this.ajaxAnchors, (Class)String.class, (Tag)this, (PageContext)this.pageContext);
        }
        this.ajax = Boolean.valueOf(this.pageContext.getRequest().getParameter(this.ajaxFlag));
    }

    protected String processContent(String content) {
        return Boolean.valueOf(this.ajaxAnchors) != false ? AjaxHtmlHelper.ajaxAnchors(content, this.id, this.ajaxFlag) : content;
    }
}

