/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class PAttributeInstance {
    private int m_M_Warehouse_ID;
    private int m_M_Product_ID;
    private int m_M_AttributeSetInstance_ID = -1;
    private String m_M_AttributeSetInstanceName = null;
    private String m_sql;
    private static CLogger log = CLogger.getCLogger(PAttributeInstance.class);
    private String m_sqlMinLife = "";

    public PAttributeInstance(Ctx ctx, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        this.init(M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
    }

    private void init(int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        log.info("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID);
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_Product_ID = M_Product_ID;
        try {
            this.dynInit(C_BPartner_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void dynInit(int C_BPartner_ID) {
        log.config("C_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID != 0) {
            int ShelfLifeMinPct = 0;
            int ShelfLifeMinDays = 0;
            String sql = "SELECT bp.ShelfLifeMinPct, bpp.ShelfLifeMinPct, bpp.ShelfLifeMinDays FROM C_BPartner bp  LEFT OUTER JOIN C_BPartner_Product bpp ON (bp.C_BPartner_ID=bpp.C_BPartner_ID AND bpp.M_Product_ID=?) WHERE bp.C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_M_Product_ID);
                pstmt.setInt(2, C_BPartner_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ShelfLifeMinPct = rs.getInt(1);
                    int pct = rs.getInt(2);
                    if (pct > 0) {
                        ShelfLifeMinDays = pct;
                    }
                    ShelfLifeMinDays = rs.getInt(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (ShelfLifeMinPct > 0) {
                this.m_sqlMinLife = " AND COALESCE(TRUNC(((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))/p.GuaranteeDays)*100),0)>=" + ShelfLifeMinPct;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinPct=" + ShelfLifeMinPct);
            }
            if (ShelfLifeMinDays > 0) {
                this.m_sqlMinLife = this.m_sqlMinLife + " AND COALESCE((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate)),0)>=" + ShelfLifeMinDays;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinDays=" + ShelfLifeMinDays);
            }
        }
        this.refresh();
    }

    private void refresh() {
        String sql = this.m_sql;
        log.finest(sql);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Warehouse_ID);
            pstmt.setInt(2, this.m_M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }
}

