/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRegion;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;

public class WLocation
extends HttpServlet {
    private static final long serialVersionUID = 2010029311395028276L;
    protected static CLogger log = CLogger.getCLogger(WLocation.class);
    private static final String P_TARGET = "TARGET";
    private static final String P_C_LOCATION_ID = "C_LOCATION_ID";
    private static final String P_ADDRESS1 = "ADDRESS1";
    private static final String P_ADDRESS2 = "ADDRESS2";
    private static final String P_CITY = "CITY";
    private static final String P_POSTAL = "POSTAL";
    private static final String P_C_COUNTRY_ID = "C_COUNTRY_ID";
    private static final String P_C_REGION_ID = "C_REGION_ID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WLocation.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.fine("");
        WWindowStatus ws = WWindowStatus.get(request);
        if (ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String columnName = WebUtil.getParameter(request, "ColumnName");
        log.info("ColumnName=" + columnName + " - " + ws.toString());
        GridField mField = ws.curTab.getField(columnName);
        log.config("ColumnName=" + columnName + ", MField=" + mField);
        if (mField == null || columnName == null || columnName.equals("")) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "ParameterMissing"));
            return;
        }
        MLocation location = null;
        Object value = mField.getValue();
        location = value != null && value instanceof Integer ? new MLocation(ws.ctx, (Integer)value, null) : new MLocation(ws.ctx, 0, null);
        String targetBase = "parent.WWindow.WForm." + columnName;
        String action = request.getRequestURI();
        WebDoc doc = WebDoc.createPopup(mField.getHeader());
        doc.addPopupClose();
        boolean hasDependents = ws.curTab.hasDependants(columnName);
        boolean hasCallout = mField.getCallout().length() > 0;
        button reset = new button();
        reset.addElement("Reset");
        String script2 = targetBase + "F.value='';" + targetBase + "D.value='';closePopup();";
        if (hasDependents || hasCallout) {
            script2 = script2 + "startUpdate(" + targetBase + "F);";
        }
        reset.setOnClick(script2);
        doc.getTable().addElement((Element)new tr().addElement((Element)this.fillForm(ws, action, location, targetBase, hasDependents || hasCallout)).addElement((Element)reset));
        doc.addPopupClose();
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.fine("");
        WWindowStatus ws = WWindowStatus.get(request);
        if (ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int C_Location_ID = WebUtil.getParameterAsInt(request, P_C_LOCATION_ID);
        String targetBase = "parent.WWindow.WForm.C_Location_ID";
        MLocation location = new MLocation(ws.ctx, C_Location_ID, null);
        log.fine("doPost updating C_Location_ID=" + C_Location_ID + " - " + targetBase);
        location.setAddress1(WebUtil.getParameter(request, P_ADDRESS1));
        location.setAddress2(WebUtil.getParameter(request, P_ADDRESS2));
        location.setCity(WebUtil.getParameter(request, P_CITY));
        location.setPostal(WebUtil.getParameter(request, P_POSTAL));
        location.setC_Country_ID(WebUtil.getParameterAsInt(request, P_C_COUNTRY_ID));
        location.setC_Region_ID(WebUtil.getParameterAsInt(request, P_C_REGION_ID));
        WebDoc doc = WebDoc.createPopup("WLocation");
        doc.addPopupClose();
        location.save();
        C_Location_ID = location.getC_Location_ID();
        td center = doc.addPopupCenter(false);
        if (C_Location_ID == 0) {
            center.addElement((Element)new p((Element)new b("ERROR - Location=0")));
        }
        center.addElement((Element)new p().addElement(location.toString()));
        script script2 = new script(new StringBuffer().append(targetBase).append("D.value='").append(C_Location_ID).append("';").append(targetBase).append("F.value='").append(location.toString()).append("';closePopup();").toString());
        doc.getBody().addElement((Element)script2);
        log.fine("script=" + script2.toString());
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private form fillForm(WWindowStatus ws, String action, MLocation location, String targetBase, boolean addStart) {
        form myForm = null;
        myForm = new form(action);
        myForm.addElement((Element)new input("hidden", P_TARGET, targetBase));
        myForm.addElement((Element)new input("hidden", P_C_LOCATION_ID, location.getC_Location_ID()));
        table table2 = new table();
        table2.setID("WLocation");
        tr line = new tr();
        line.addElement((Element)new td(Msg.getMsg(ws.ctx, "Address") + " 1").setAlign("right"));
        input myInput = null;
        myInput = new input("text", P_ADDRESS1, location.getAddress1());
        myInput.setMaxlength(50).setSize(50);
        line.addElement((Element)new td((Element)myInput).setAlign("left").setColSpan(5));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.getMsg(ws.ctx, "Address") + " 2").setAlign("right"));
        myInput = new input("text", P_ADDRESS2, location.getAddress2());
        myInput.setMaxlength(50).setSize(50);
        line.addElement((Element)new td((Element)myInput).setAlign("left").setColSpan(5));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.getMsg(ws.ctx, "City")).setAlign("right"));
        myInput = new input("text", P_CITY, location.getCity());
        myInput.setMaxlength(30).setSize(30);
        line.addElement((Element)new td((Element)myInput).setAlign("left"));
        if (location.getCountry().isHasRegion()) {
            line.addElement((Element)new td(Msg.getMsg(ws.ctx, "Region")).setAlign("right"));
            line.addElement((Element)new td((Element)this.getRegion(location, ws)).setAlign("left"));
        }
        line.addElement((Element)new td(Msg.getMsg(ws.ctx, "Postal")).setAlign("right"));
        myInput = new input("text", P_POSTAL, location.getPostal());
        myInput.setMaxlength(10).setSize(6);
        line.addElement((Element)new td((Element)myInput).setAlign("left"));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.getMsg(ws.ctx, "Country")).setAlign("right"));
        line.addElement((Element)new td((Element)this.getCountry(location, ws)).setAlign("left").setColSpan(5));
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td("&nbsp;"));
        input submit = new input("submit", "Submit", "Submit");
        line.addElement((Element)new td((Element)submit).setAlign("right").setColSpan(5));
        table2.addElement((Element)line);
        myForm.addElement((Element)table2);
        return myForm;
    }

    private select getCountry(MLocation location, WWindowStatus ws) {
        MCountry[] countries = MCountry.getCountries(location.getCtx());
        int comp = location.getC_Country_ID();
        if (comp == 0) {
            comp = ws.ctx.getContextAsInt("C_Country_ID");
        }
        option[] options = new option[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            options[i] = new option(String.valueOf(countries[i].getC_Country_ID()));
            options[i].addElement(AmpiereUtil.maskHTML(countries[i].getName()));
            if (comp != countries[i].getC_Country_ID()) continue;
            options[i].setSelected(true);
        }
        select select2 = new select(P_C_COUNTRY_ID, options);
        return select2;
    }

    private select getRegion(MLocation location, WWindowStatus ws) {
        MRegion[] regions = MRegion.getRegions(location.getCtx(), location.getC_Country_ID());
        int comp = location.getC_Region_ID();
        if (comp == 0) {
            comp = ws.ctx.getContextAsInt("C_Region_ID");
        }
        option[] options = new option[regions.length];
        for (int i = 0; i < regions.length; ++i) {
            options[i] = new option(String.valueOf(regions[i].getC_Region_ID()));
            options[i].addElement(AmpiereUtil.maskHTML(regions[i].getName()));
            if (comp != regions[i].getC_Region_ID()) continue;
            options[i].setSelected(true);
        }
        select select2 = new select(P_C_REGION_ID, options);
        return select2;
    }
}

