/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.GenerateInvoiceFromOrderForm;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.WebSessionCtx;

public class GenerateInvoiceFromOrderAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ORDER_LIST = "orderlist";
    private static final String INVOICE_LIST = "invoicelist";
    private static final String ACTION_FORM = "GenerateInvoiceFromOrderForm";
    private static final String ERROR_FORWARD = "error";
    private static final int ORDER_BUSINESS_PARTNER_COLUMN_ID = 2762;

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(ORDER_LIST);
        GenerateInvoiceFromOrderForm myForm = (GenerateInvoiceFromOrderForm)request.getAttribute(ACTION_FORM);
        String column = myForm.getChangedColumn();
        if (column.equals("organizationId")) {
            actionForward = mapping.findForward(ORDER_LIST);
        } else if (column.equals("businessPartnerId")) {
            actionForward = mapping.findForward(ORDER_LIST);
        } else if (column.equals("businessPartnerName")) {
            MLookup lookup = null;
            try {
                lookup = MLookupFactory.get(wsc.ctx, 0, 2762, 19, wsc.language, "C_BPartner_ID", 0, false, "UPPER(NAME) LIKE '" + myForm.getBusinessPartnerName().toUpperCase() + "%' ");
                Iterator<NamePair> keyNames = ((Lookup)lookup).getData(true, false, true, false).iterator();
                if (keyNames.hasNext()) {
                    KeyNamePair keyName = (KeyNamePair)keyNames.next();
                    myForm.setBusinessPartnerId(keyName.getKey());
                    myForm.setBusinessPartnerName(keyName.getName());
                } else {
                    myForm.setBusinessPartnerId(999999999);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MLookupFactory.get AD_Column_ID=2762", e);
            }
            actionForward = mapping.findForward(ORDER_LIST);
        } else if (myForm.getOrderIdList() != null && myForm.getOrderIdList().length > 0) {
            myForm.setMainWindowTitle(wsc.ctx.getContext("FormName") + " - " + wsc.loginInfo);
            myForm.setPageTitle(wsc.ctx.getContext("FormName"));
            this.generateInvoices(wsc.ctx, myForm);
            actionForward = mapping.findForward(INVOICE_LIST);
        } else {
            actionForward = mapping.findForward(ORDER_LIST);
        }
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void generateInvoices(Ctx ctx, GenerateInvoiceFromOrderForm form2) {
        String whereClause = this.getWhereClause(form2.getOrderIdList());
        String sql = "UPDATE C_Order SET IsSelected = 'N' WHERE IsSelected='Y' AND AD_Client_ID=" + ctx.getAD_Client_ID();
        int no = DB.executeUpdate(sql, null);
        sql = "UPDATE C_Order SET IsSelected='Y' WHERE " + whereClause;
        no = DB.executeUpdate(sql, null);
        if (no == 0) {
            form2.setResultInfo("No Invoices");
            return;
        }
        int processId = 134;
        MProcess process = MProcess.get(ctx, processId);
        MPInstance instance = new MPInstance(ctx, processId, 0);
        if (!instance.save()) {
            form2.setResultInfo(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            return;
        }
        ProcessInfo pi = new ProcessInfo("VInOutGen", processId);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        pi.setAD_User_ID(ctx.getAD_User_ID());
        pi.setAD_Client_ID(ctx.getAD_Client_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        if (!ip.save()) {
            form2.setResultInfo("No Parameter added");
            return;
        }
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        if (!ip.save()) {
            form2.setResultInfo("No Parameter added");
            return;
        }
        boolean processOK = false;
        if (process.isJavaProcess()) {
            Trx trx = Trx.get(Trx.createTrxName("WebPrc"), true);
            try {
                processOK = process.processIt(pi, trx);
                trx.commit();
                trx.close();
            }
            catch (Throwable t) {
                trx.rollback();
                trx.close();
            }
            if (!processOK || pi.isError()) {
                processOK = false;
            }
            if (processOK) {
                ProcessInfoUtil.setLogFromDB(pi);
                StringBuffer iText = new StringBuffer();
                iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg(ctx, "InvGenerateInfo")).append(")<br>").append(pi.getLogInfo(true)).append("<br><br>");
                form2.setResultInfo(iText.toString());
                sql = "UPDATE C_Order SET IsSelected='N' WHERE " + whereClause;
                no = DB.executeUpdate(sql, null);
                this.log.config("Reset=" + no);
            } else {
                this.log.log(Level.SEVERE, "Error:" + pi.getSummary());
            }
        }
    }

    private String getWhereClause(int[] orderIds) {
        StringBuffer sb = new StringBuffer("");
        if (orderIds.length > 0) {
            sb.append("C_Order_ID");
            if (orderIds.length > 1) {
                sb.append(" IN (");
            } else {
                sb.append("=");
            }
            for (int i2 = 0; i2 < orderIds.length; ++i2) {
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(orderIds[i2]));
            }
            if (orderIds.length > 1) {
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

