/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.model.JobParameterValue;
import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.apps.scheduler.web.struts.schedule.JobEditForm;
import com.jware.base.error.JwareApplicationException;
import com.jware.base.web.struts.jWareBaseAction;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public final class JobEditAction
extends jWareBaseAction {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public ActionForward doExecute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JobEditForm info = (JobEditForm)form2;
        info.setJobParameters(request);
        MessageResources messages = this.getResources(request);
        if (this.isCancelled(request)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)(" " + mapping.getAttribute() + " - HtmlexpDefineEditAction transaction was cancelled"));
            }
            this.removeFormBean(mapping, request);
            return mapping.findForward("success");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JobEditAction:  Processing actions");
        }
        JobDetail jobDetail = new JobDetail();
        jobDetail.setGroup(info.getGroupName());
        jobDetail.setName(info.getName());
        jobDetail.setDescription(info.getDescription());
        jobDetail.setVolatility(info.isVolatility());
        jobDetail.setDurability(info.isDurable());
        jobDetail.setRequestsRecovery(info.isRecoveryRequesting());
        String className = info.getJobClass();
        List parameters = info.getJobParameters();
        jobDetail.setJobDataMap(new JobDataMap());
        Class<?> jobClass = null;
        try {
            jobClass = Class.forName(className);
            jobDetail.setJobClass(jobClass);
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                JobParameterValue jobParameterValue = (JobParameterValue)parameters.get(i2);
                String parameterName = jobParameterValue.getParameterName();
                String parameterValue = jobParameterValue.getParameterValue();
                if (parameterName == null || parameterName.trim().length() <= 0 || parameterValue == null || parameterValue.trim().length() <= 0) continue;
                jobDetail.getJobDataMap().put(parameterName, parameterValue);
            }
            boolean replace = true;
            Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
            scheduler.addJob(jobDetail, replace);
            session.setAttribute("jobName", (Object)info.getName());
            session.setAttribute("groupName", (Object)info.getGroupName());
        }
        catch (ClassNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("JobEditAction: " + className + " class is not found"));
            }
            Object[] args = new String[]{className};
            throw new JwareApplicationException("E500002", args, e);
        }
        catch (SchedulerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("JobEditAction: scheduler Error " + e.getMessage()));
            }
            throw new JwareApplicationException("E600001", e);
        }
        catch (IllegalArgumentException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("JobEditAction: scheduler Error " + e.getMessage()));
            }
            throw new JwareApplicationException("E600002", e);
        }
        return mapping.findForward("success");
    }

    protected void removeFormBean(ActionMapping mapping, HttpServletRequest request) {
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.removeAttribute(mapping.getAttribute());
            } else {
                HttpSession session = request.getSession();
                session.removeAttribute(mapping.getAttribute());
            }
        }
    }
}

