/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.model.JobDetailViewHelper;
import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.base.web.struts.jWareBaseAction;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public final class JobScheduleList
extends jWareBaseAction {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public ActionForward doExecute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources messages = this.getResources(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JobDefinitionList:  Processing actions");
        }
        ArrayList<JobDetailViewHelper> jobList = new ArrayList<JobDetailViewHelper>();
        Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
        try {
            String[] jobGroups = scheduler.getJobGroupNames();
            ArrayList<String> addedJobs = new ArrayList<String>(jobGroups.length);
            for (int i2 = 0; i2 < jobGroups.length; ++i2) {
                String groupName = jobGroups[i2];
                String[] jobs = scheduler.getJobNames(groupName);
                for (int j = 0; j < jobs.length; ++j) {
                    String job = jobs[j];
                    JobDetailViewHelper viewHelper = new JobDetailViewHelper();
                    JobDetail jobDetail = scheduler.getJobDetail(job, groupName);
                    String key = job + groupName;
                    if (addedJobs.contains(key)) continue;
                    viewHelper.setJobDetail(jobDetail);
                    viewHelper.putParamValue("jobName", job);
                    viewHelper.putParamValue("groupName", groupName);
                    jobList.add(viewHelper);
                    addedJobs.add(key);
                }
            }
        }
        catch (SchedulerException e) {
            throw new Exception("When reading the jobs", e);
        }
        request.setAttribute("jobScheduleList", jobList);
        return mapping.findForward("success");
    }
}

