/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.apps.scheduler.web.struts.schedule.JobUITriggerForm;
import com.jware.base.error.JwareApplicationException;
import com.jware.base.web.struts.jWareBaseAction;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.UICronTrigger;

public final class JobUITriggerEditAction
extends jWareBaseAction {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public ActionForward doExecute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JobUITriggerForm info = (JobUITriggerForm)form2;
        MessageResources messages = this.getResources(request);
        if (this.isCancelled(request)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)(" " + mapping.getAttribute() + " - JobUITriggerEditAction transaction was cancelled"));
            }
            this.removeFormBean(mapping, request);
            return mapping.findForward("success");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JobUITriggerEditAction:  Processing actions");
        }
        String startTime = info.getStartTime();
        String stopTime = info.getStopTime();
        boolean startTimeHasValue = startTime != null && startTime.length() > 0;
        boolean stopTimeHasValue = stopTime != null && stopTime.length() > 0;
        UICronTrigger trigger = new UICronTrigger();
        trigger.setJobGroup(info.getJobGroup());
        trigger.setJobName(info.getJobName());
        trigger.setGroup(info.getTriggerGroup());
        trigger.setName(info.getTriggerName());
        if (info.getYears() != null) {
            trigger.setYears(info.getYears());
        }
        if (info.getMonths() != null) {
            trigger.setMonths(info.getMonths());
        }
        if (info.getDaysOfMonth() != null) {
            trigger.setDaysOfMonth(info.getDaysOfMonth());
        }
        if (info.getDaysOfWeek() != null) {
            trigger.setDaysOfWeek(info.getDaysOfWeek());
        }
        if (info.getHours() != null) {
            trigger.setHours(info.getHours());
        }
        if (info.getMinutes() != null) {
            trigger.setMinutes(info.getMinutes());
        }
        if (info.getSeconds() != null) {
            trigger.setSeconds(info.getSeconds());
        }
        trigger.setDescription(info.getDescription());
        if (startTimeHasValue) {
            trigger.setStartTime(info.getStartTimeAsDate());
        }
        if (stopTimeHasValue) {
            trigger.setEndTime(info.getStopTimeAsDate());
        }
        trigger.setVolatility(false);
        try {
            Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
            scheduler.scheduleJob((Trigger)trigger);
        }
        catch (SchedulerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JobCronTriggerEditAction:  Scheduler Error occurs.");
            }
            throw new JwareApplicationException("E600001", e);
        }
        return mapping.findForward("success");
    }

    protected void removeFormBean(ActionMapping mapping, HttpServletRequest request) {
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.removeAttribute(mapping.getAttribute());
            } else {
                HttpSession session = request.getSession();
                session.removeAttribute(mapping.getAttribute());
            }
        }
    }
}

