/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.web.struts.schedule.JobDetailForm;
import com.jware.apps.scheduler.web.struts.schedule.JobListenerForm;
import com.jware.apps.scheduler.web.struts.schedule.ScheduleBase;
import com.jware.apps.scheduler.web.struts.schedule.SchedulerChooseForm;
import com.jware.apps.scheduler.web.struts.schedule.SchedulerDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerControler
extends ScheduleBase {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources messages = this.getResources(request);
        String command = this.getCommand(request);
        this.log.info((Object)("command is = " + command));
        SchedulerChooseForm scheduleInfo = (SchedulerChooseForm)form2;
        if (scheduleInfo == null) {
            scheduleInfo = new SchedulerChooseForm();
        }
        String newSchedulerName = scheduleInfo.getChoosenSchedulerName();
        Scheduler choosenScheduler = null;
        try {
            choosenScheduler = newSchedulerName != null && newSchedulerName.length() > 0 ? new StdSchedulerFactory().getScheduler(newSchedulerName) : StdSchedulerFactory.getDefaultScheduler();
            if ("start".equalsIgnoreCase(command)) {
                choosenScheduler.start();
            } else if ("stop".equalsIgnoreCase(command)) {
                choosenScheduler.shutdown();
                choosenScheduler = StdSchedulerFactory.getDefaultScheduler();
            } else if ("pause".equalsIgnoreCase(command)) {
                choosenScheduler.pause();
            } else if ("waitAndStop".equalsIgnoreCase(command)) {
                choosenScheduler.shutdown(true);
            } else if ("pauseAll".equalsIgnoreCase(command)) {
                choosenScheduler.pauseAll();
            } else if ("resumeAll".equalsIgnoreCase(command)) {
                choosenScheduler.resumeAll();
            }
            this.populateSchedulerForm(choosenScheduler, scheduleInfo);
            request.setAttribute("ChoosenScheduler", (Object)choosenScheduler);
            request.setAttribute("SchedulerChooseForm", (Object)scheduleInfo);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("success");
    }

    private void populateSchedulerForm(Scheduler choosenScheduler, SchedulerChooseForm form2) throws Exception {
        Collection scheduleCollection = new StdSchedulerFactory().getAllSchedulers();
        Iterator itr = scheduleCollection.iterator();
        form2.setSchedulers(new ArrayList());
        try {
            form2.setChoosenSchedulerName(choosenScheduler.getSchedulerName());
            while (itr.hasNext()) {
                Scheduler scheduler = (Scheduler)itr.next();
                form2.getSchedulers().add(scheduler);
            }
        }
        catch (SchedulerException e) {
            throw new Exception(e);
        }
        SchedulerDTO schedForm = new SchedulerDTO();
        schedForm.setSchedulerName(choosenScheduler.getSchedulerName());
        schedForm.setNumJobsExecuted(String.valueOf(choosenScheduler.getMetaData().numJobsExecuted()));
        if (choosenScheduler.getMetaData().jobStoreSupportsPersistence()) {
            schedForm.setPersistenceType("DataBase");
        } else {
            schedForm.setPersistenceType("RAM");
        }
        schedForm.setRunningSince(String.valueOf(choosenScheduler.getMetaData().runningSince()));
        if (choosenScheduler.isShutdown()) {
            schedForm.setState("\u505c\u6b62\u4e2d");
        } else if (choosenScheduler.isPaused()) {
            schedForm.setState("\u66ab\u505c\u4e2d");
        } else {
            schedForm.setState("\u8d77\u52d5\u4e2d");
        }
        schedForm.setThreadPoolSize(String.valueOf(choosenScheduler.getMetaData().getThreadPoolSize()));
        schedForm.setVersion(choosenScheduler.getMetaData().getVersion());
        schedForm.setSummary(choosenScheduler.getMetaData().getSummary());
        List jobDetails = choosenScheduler.getCurrentlyExecutingJobs();
        for (JobExecutionContext job : jobDetails) {
            JobDetail jobDetail = job.getJobDetail();
            JobDetailForm jobForm = new JobDetailForm();
            jobForm.setGroupName(jobDetail.getGroup());
            jobForm.setName(jobDetail.getName());
            jobForm.setDescription(jobDetail.getDescription());
            jobForm.setJobClass(jobDetail.getJobClass().getName());
            form2.getExecutingJobs().add(jobForm);
        }
        String[] calendars = choosenScheduler.getCalendarNames();
        List jobListeners = choosenScheduler.getGlobalJobListeners();
        for (JobListener jobListener : jobListeners) {
            JobListenerForm listenerForm = new JobListenerForm();
            listenerForm.setListenerName(jobListener.getName());
            listenerForm.setListenerClass(jobListener.getClass().getName());
            schedForm.getGlobalJobListeners().add(listenerForm);
        }
        form2.setScheduler(schedForm);
    }

    private String getCommand(HttpServletRequest request) {
        String result = null;
        String button2 = request.getParameter("start.x");
        if (button2 != null && !"".equals(button2)) {
            return "start";
        }
        button2 = request.getParameter("start.y");
        if (button2 != null && !"".equals(button2)) {
            return "start";
        }
        button2 = request.getParameter("pause.x");
        if (button2 != null && !"".equals(button2)) {
            return "pause";
        }
        button2 = request.getParameter("pause.y");
        if (button2 != null && !"".equals(button2)) {
            return "pause";
        }
        button2 = request.getParameter("stop.x");
        if (button2 != null && !"".equals(button2)) {
            return "stop";
        }
        button2 = request.getParameter("stop.y");
        if (button2 != null && !"".equals(button2)) {
            return "stop";
        }
        button2 = request.getParameter("waitAndStopScheduler.x");
        if (button2 != null && !"".equals(button2)) {
            return "waitAndStopScheduler";
        }
        button2 = request.getParameter("waitAndStopScheduler.y");
        if (button2 != null && !"".equals(button2)) {
            return "waitAndStopScheduler";
        }
        button2 = request.getParameter("btnPauseAllJobs.x");
        if (button2 != null && !"".equals(button2)) {
            return "btnPauseAllJobs";
        }
        button2 = request.getParameter("btnPauseAllJobs.y");
        if (button2 != null && !"".equals(button2)) {
            return "btnPauseAllJobs";
        }
        button2 = request.getParameter("btnResumeAllJobs.x");
        if (button2 != null && !"".equals(button2)) {
            return "btnResumeAllJobs";
        }
        button2 = request.getParameter("btnResumeAllJobs.y");
        if (button2 != null && !"".equals(button2)) {
            return "btnResumeAllJobs";
        }
        return result;
    }
}

