/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;

public class XHtmlUtils {
    protected static Log log = LogFactory.getLog(XHtmlUtils.class);
    private static String errorFileName = "/tmp/tidy.err";

    public static String convertHTML2XHTML(String htmlContents) throws Exception {
        return XHtmlUtils.convertHTML2XHTML(htmlContents, true);
    }

    public static String convertHTML2XHTML(String htmlContents, boolean intend) throws Exception {
        StringBuffer result = new StringBuffer();
        ByteArrayInputStream in = null;
        ByteArrayOutputStream out = null;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter((Writer)new FileWriter(errorFileName), true);
        }
        catch (Exception e) {
            log.info((Object)(errorFileName + " -- Error file path not exist. "));
        }
        Tidy tidy = new Tidy();
        tidy.setXmlOut(true);
        tidy.setCharEncoding(3);
        if (intend) {
            tidy.setIndentContent(true);
        } else {
            tidy.setIndentContent(false);
        }
        tidy.setXHTML(true);
        tidy.setQuoteNbsp(true);
        tidy.setDocType("omit");
        tidy.setTidyMark(false);
        tidy.setIndentAttributes(true);
        tidy.setQuoteAmpersand(true);
        tidy.setNumEntities(true);
        try {
            if (pw != null) {
                tidy.setErrout(pw);
            }
            in = new ByteArrayInputStream(htmlContents.getBytes("UTF-8"));
            out = new ByteArrayOutputStream();
            Document doc = tidy.parseDOM((InputStream)in, (OutputStream)out);
            result.append(out.toString("UTF-8"));
            for (int i2 = 0; i2 < result.length(); ++i2) {
                char nextCh;
                char ch = result.charAt(i2);
                if (Character.isDefined(ch) && ch <= '\ufff0') continue;
                result.setCharAt(i2, ' ');
                if (i2 >= result.length() - 1 || (nextCh = result.charAt(i2 + 1)) != '/') continue;
                result.setCharAt(i2, '<');
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result.toString();
    }
}

