/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.properties.TableProperties;

public class DisplayPropertiesLoaderServlet
extends HttpServlet {
    public static final String PROPERTIES_PARAMETER = "properties.filename";
    private static final long serialVersionUID = 899149338534L;
    private static Log log = LogFactory.getLog(DisplayPropertiesLoaderServlet.class);

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String file = this.getInitParameter(PROPERTIES_PARAMETER);
        if (log.isDebugEnabled()) {
            log.debug((Object)("properties.filename=" + file));
        }
        if (file != null) {
            InputStream propStream = servletConfig.getServletContext().getResourceAsStream(file);
            if (propStream == null) {
                log.warn((Object)("unable to find " + file));
                return;
            }
            Properties props = new Properties();
            try {
                props.load(propStream);
            }
            catch (IOException e) {
                throw new ServletException("Cannot load " + file + ": " + e.getMessage(), (Throwable)e);
            }
            TableProperties.setUserProperties(props);
        } else {
            log.warn((Object)Messages.getString("DisplayPropertiesLoaderServlet.missingparameter", new Object[]{PROPERTIES_PARAMETER}));
        }
    }
}

