/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.lang.reflect.Method;
import java.net.URLEncoder;
import org.displaytag.Messages;

public final class CompatibleUrlEncoder {
    private static Method encodeMethod14;

    private CompatibleUrlEncoder() {
    }

    public static String encode(String url, String encoding) {
        if (encodeMethod14 != null) {
            Object[] methodArgs = new Object[]{url, encoding != null ? encoding : "UTF8"};
            try {
                return (String)encodeMethod14.invoke(null, methodArgs);
            }
            catch (Throwable ex) {
                throw new RuntimeException(Messages.getString("CompatibleUrlEncoder.errorinvoking", new Object[]{encoding, ex.getMessage()}));
            }
        }
        return URLEncoder.encode(url);
    }

    static {
        try {
            Class<?> urlEncoderClass = Class.forName("java.net.URLEncoder");
            encodeMethod14 = urlEncoderClass.getMethod("encode", String.class, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

