/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.udf;

import COM.ibm.db2.app.UDF;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.compiere.udf.Compiere;
import org.compiere.udf.Currency;

public class PaymentTerm
extends UDF {
    public static int dueDays(int p_C_PaymentTerm_ID, Timestamp p_DocDate, Timestamp p_PayDate) throws SQLException {
        if (p_C_PaymentTerm_ID == 0 || p_DocDate == null) {
            return 0;
        }
        Timestamp PayDate = p_PayDate;
        if (PayDate == null) {
            PayDate = new Timestamp(System.currentTimeMillis());
        }
        PayDate = Compiere.trunc(PayDate);
        Timestamp DueDate = null;
        String sql = "SELECT * FROM C_PaymentTerm WHERE C_PaymentTerm_ID=?";
        PreparedStatement pstmt = Compiere.getInstance().prepareStatement(sql);
        pstmt.setInt(1, p_C_PaymentTerm_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            boolean IsDueFixed = "Y".equals(rs.getString("IsDueFixed"));
            if (IsDueFixed) {
                int FixMonthDay = rs.getInt("FixMonthDay");
                int FixMonthOffset = rs.getInt("FixMonthOffset");
                int FixMonthCutoff = rs.getInt("FixMonthCutoff");
                DueDate = PaymentTerm.calculateDateDue(p_DocDate, FixMonthDay, FixMonthOffset, FixMonthCutoff);
            } else {
                int NetDays = rs.getInt("NetDays");
                DueDate = Compiere.addDays(p_DocDate, NetDays);
            }
        }
        rs.close();
        pstmt.close();
        if (DueDate == null) {
            return 0;
        }
        return Compiere.getDaysBetween(DueDate, PayDate);
    }

    public static int invoiceDueDays(int p_C_Invoice_ID, Timestamp p_PayDate) throws SQLException {
        if (p_C_Invoice_ID == 0) {
            return 0;
        }
        int retValue = 0;
        String sql = "SELECT C_PaymentTerm_ID, DateInvoiced FROM C_Invoice WHERE C_Invoice_ID=?";
        PreparedStatement pstmt = Compiere.getInstance().prepareStatement(sql);
        pstmt.setInt(1, p_C_Invoice_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int C_PaymentTerm_ID = rs.getInt(1);
            Timestamp DocDate = rs.getTimestamp(2);
            retValue = PaymentTerm.dueDays(C_PaymentTerm_ID, DocDate, p_PayDate);
        }
        rs.close();
        pstmt.close();
        return retValue;
    }

    public static Timestamp dueDate(int p_C_PaymentTerm_ID, Timestamp p_DocDate) throws SQLException {
        if (p_C_PaymentTerm_ID == 0 || p_DocDate == null) {
            return null;
        }
        Timestamp DueDate = Compiere.trunc(p_DocDate);
        String sql = "SELECT * FROM C_PaymentTerm WHERE C_PaymentTerm_ID=?";
        PreparedStatement pstmt = Compiere.getInstance().prepareStatement(sql);
        pstmt.setInt(1, p_C_PaymentTerm_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            boolean IsDueFixed = "Y".equals(rs.getString("IsDueFixed"));
            if (IsDueFixed) {
                int FixMonthDay = rs.getInt("FixMonthDay");
                int FixMonthOffset = rs.getInt("FixMonthOffset");
                int FixMonthCutoff = rs.getInt("FixMonthCutoff");
                DueDate = PaymentTerm.calculateDateDue(p_DocDate, FixMonthDay, FixMonthOffset, FixMonthCutoff);
            } else {
                int NetDays = rs.getInt("NetDays");
                if (NetDays != 0) {
                    DueDate = Compiere.addDays(DueDate, NetDays);
                }
            }
        }
        rs.close();
        pstmt.close();
        return DueDate;
    }

    public static Timestamp invoiceDueDate(int p_C_Invoice_ID) throws SQLException {
        if (p_C_Invoice_ID == 0) {
            return null;
        }
        Timestamp DueDate = null;
        String sql = "SELECT C_PaymentTerm_ID, DateInvoiced FROM C_Invoice WHERE C_Invoice_ID=?";
        PreparedStatement pstmt = Compiere.getInstance().prepareStatement(sql);
        pstmt.setInt(1, p_C_Invoice_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int C_PaymentTerm_ID = rs.getInt(1);
            Timestamp DocDate = rs.getTimestamp(2);
            DueDate = PaymentTerm.dueDate(C_PaymentTerm_ID, DocDate);
        }
        rs.close();
        pstmt.close();
        return DueDate;
    }

    private static Timestamp calculateDateDue(Timestamp DocDate, int FixMonthDay, int FixMonthOffset, int FixMonthCutoff) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DocDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int maxDayCut = cal.getActualMaximum(5);
        if (FixMonthCutoff > maxDayCut) {
            cal.set(5, maxDayCut);
        } else {
            cal.set(5, FixMonthCutoff);
        }
        if (DocDate.after(cal.getTime())) {
            ++FixMonthOffset;
        }
        cal.add(2, FixMonthOffset);
        int maxDay = cal.getActualMaximum(5);
        if (FixMonthDay > maxDay) {
            cal.set(5, maxDay);
        } else if (FixMonthDay >= 30 && maxDay > FixMonthDay) {
            cal.set(5, maxDay);
        } else {
            cal.set(5, FixMonthDay);
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static double discountD(double p_Amount, int p_C_Currency_ID, int p_C_PaymentTerm_ID, Timestamp p_DocDate, Timestamp p_PayDate) throws SQLException {
        return PaymentTerm.discount(new BigDecimal(p_Amount), p_C_Currency_ID, p_C_PaymentTerm_ID, p_DocDate, p_PayDate);
    }

    public static double discount(BigDecimal p_Amount, int p_C_Currency_ID, int p_C_PaymentTerm_ID, Timestamp p_DocDate, Timestamp p_PayDate) throws SQLException {
        if (p_Amount == null || p_C_PaymentTerm_ID == 0 || p_DocDate == null) {
            return 0.0;
        }
        if (p_Amount.signum() == 0) {
            return 0.0;
        }
        Timestamp PayDate = p_PayDate;
        if (PayDate == null) {
            PayDate = new Timestamp(System.currentTimeMillis());
        }
        PayDate = Compiere.trunc(PayDate);
        BigDecimal discount = null;
        String sql = "SELECT * FROM C_PaymentTerm WHERE C_PaymentTerm_ID=?";
        PreparedStatement pstmt = Compiere.getInstance().prepareStatement(sql);
        pstmt.setInt(1, p_C_PaymentTerm_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int DiscountDays = rs.getInt("DiscountDays");
            int DiscountDays2 = rs.getInt("DiscountDays2");
            int GraceDays = rs.getInt("GraceDays");
            boolean IsNextBusinessDay = "Y".equals(rs.getString("IsNextBusinessDay"));
            BigDecimal Discount = rs.getBigDecimal("Discount");
            BigDecimal Discount2 = rs.getBigDecimal("Discount2");
            Timestamp Discount1Date = Compiere.addDays(p_DocDate, DiscountDays + GraceDays);
            Timestamp Discount2Date = Compiere.addDays(p_DocDate, DiscountDays2 + GraceDays);
            if (IsNextBusinessDay) {
                Discount1Date = Compiere.nextBusinessDay(Discount1Date);
                Discount2Date = Compiere.nextBusinessDay(Discount2Date);
            }
            if ((discount = !PayDate.after(Discount1Date) ? p_Amount.multiply(Discount) : (!PayDate.after(Discount2Date) ? p_Amount.multiply(Discount2) : Compiere.ZERO)).signum() != 0) {
                discount = discount.divide(Compiere.HUNDRED, 6, 4);
                discount = BigDecimal.valueOf(Currency.round(discount, p_C_Currency_ID, "N"));
            }
        }
        rs.close();
        pstmt.close();
        return discount.doubleValue();
    }
}

