/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.YAxis;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.RectMapArea;
import org.jCharts.properties.BarChartProperties;

abstract class BarChart {
    BarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Rectangle2D.Float float_;
        Graphics2D graphics2D = axisChart.getGraphics2D();
        BarChartProperties barChartProperties = (BarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        float f = axisChart.getYAxis().getZeroLineCoordinate();
        float f2 = axisChart.getXAxis().getScalePixelWidth() * barChartProperties.getPercentage();
        if (axisChart.getAxisProperties().hasUserDefinedScale()) {
            float_ = new Rectangle2D.Float(axisChart.getXAxis().getOrigin(), axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f, axisChart.getXAxis().getPixelLength(), axisChart.getYAxis().getPixelLength() - 2.0f);
            graphics2D.setClip(float_);
        }
        float_ = new Rectangle2D.Float(axisChart.getXAxis().getTickStartX() - f2 / 2.0f, f, f2, 0.0f);
        graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
        graphics2D.setStroke(barChartProperties.getOutlineStroke());
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataItems()) {
            if (iAxisChartDataSet.getValue(0, n) != 0.0) {
                if (iAxisChartDataSet.getValue(0, n) < 0.0) {
                    float_.y = f;
                    float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(0, n), axisChart.getYAxis());
                } else {
                    float_.y = axisChart.getYAxis().computeAxisCoordinate(iAxisChartDataSet.getValue(0, n));
                    float_.height = f - float_.y;
                }
                if (float_.height != 0.0f) {
                    graphics2D.fill(float_);
                    if (barChartProperties.getShowOutlinesFlag()) {
                        graphics2D.setPaint(barChartProperties.getOutlinePaint());
                        graphics2D.draw(float_);
                        graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
                    }
                    if (axisChart.getGenerateImageMapFlag()) {
                        axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(0, n), axisChart.getIDataSeries().getXAxisLabel(n), iAxisChartDataSet.getLegendLabel(0)));
                    }
                }
            }
            float_.x += axisChart.getXAxis().getScalePixelWidth();
            ++n;
        }
    }

    static float computeScaleHeightOfValue(double d, YAxis yAxis) {
        return (float)Math.abs(d * yAxis.getOneUnitPixelSize());
    }
}

