/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.cm;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.compiere.model.X_CM_BroadcastServer;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;

public class CacheHandler {
    protected String[] cacheURLs;
    protected CLogger log;

    public CacheHandler(String thisURL, CLogger tLog, Ctx ctx, String trxName) {
        int[] theseServers = X_CM_BroadcastServer.getAllIDs((String)"CM_BroadcastServer", (String)"CM_WebProject_ID=0", (String)trxName);
        if (theseServers != null && theseServers.length > 0) {
            String[] thisURLs = new String[theseServers.length];
            for (int i = 0; i < theseServers.length; ++i) {
                X_CM_BroadcastServer thisServer = new X_CM_BroadcastServer(ctx, theseServers[i], trxName);
                thisURLs[i] = thisServer.getIP_Address();
            }
            this.cacheURLs = thisURLs;
        } else {
            String[] thisURLs = new String[]{thisURL};
            this.cacheURLs = thisURLs;
        }
        this.log = tLog;
    }

    public CacheHandler(String[] thisURLs, CLogger tLog) {
        this.log = tLog;
        this.cacheURLs = thisURLs;
    }

    public void cleanTemplate(Integer ID) {
        this.cleanTemplate("" + ID);
    }

    public void cleanTemplate(String ID) {
        this.runURLRequest("Template", ID);
    }

    public void emptyTemplate() {
        this.runURLRequest("Template", "0");
    }

    public void cleanContainer(Integer ID) {
        this.cleanContainer("" + ID);
    }

    public void cleanContainer(String ID) {
        this.runURLRequest("Container", ID);
    }

    public void cleanContainerTree(Integer ID) {
        this.cleanContainerTree("" + ID);
    }

    public void cleanContainerTree(String ID) {
        this.runURLRequest("ContainerTree", ID);
    }

    public void cleanContainerElement(Integer ID) {
        this.cleanContainerElement("" + ID);
    }

    public void cleanContainerElement(String ID) {
        this.runURLRequest("ContainerElement", ID);
    }

    private void runURLRequest(String cache, String ID) {
        String thisURL = null;
        for (int i = 0; i < this.cacheURLs.length; ++i) {
            try {
                thisURL = "http://" + this.cacheURLs[i] + "/cache/Service?Cache=" + cache + "&ID=" + ID;
                URL url = new URL(thisURL);
                Proxy thisProxy = Proxy.NO_PROXY;
                URLConnection urlConn = url.openConnection(thisProxy);
                urlConn.setUseCaches(false);
                urlConn.connect();
                InputStreamReader stream = new InputStreamReader(urlConn.getInputStream());
                StringBuffer srvOutput = new StringBuffer();
                try {
                    int c;
                    while ((c = ((Reader)stream).read()) != -1) {
                        srvOutput.append((char)c);
                    }
                    continue;
                }
                catch (Exception E2) {
                    E2.printStackTrace();
                    continue;
                }
            }
            catch (IOException E) {
                if (this.log == null) continue;
                this.log.warning("Can't clean cache at:" + thisURL + " be carefull, your deployment server may use invalid or old cache data!");
            }
        }
    }

    public static String convertJNPURLToCacheURL(String JNPURL) {
        if (JNPURL.indexOf("jnp://") >= 0) {
            JNPURL = JNPURL.substring(JNPURL.indexOf("jnp://") + 6);
        }
        if (JNPURL.indexOf(":") >= 0) {
            JNPURL = JNPURL.substring(0, JNPURL.indexOf(":"));
        }
        if (JNPURL.length() > 0) {
            return JNPURL;
        }
        return null;
    }
}

