/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.esb;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.compiere.common.ChangeVO;
import org.compiere.common.QueryVO;
import org.compiere.controller.UIField;
import org.compiere.controller.UIFieldVO;
import org.compiere.controller.UIFieldVOFactory;
import org.compiere.controller.UITab;
import org.compiere.controller.UITabVOFactory;
import org.compiere.controller.UIWindow;
import org.compiere.controller.UIWindowVO;
import org.compiere.controller.UIWindowVOFactory;
import org.compiere.esb.GwtServerUtil;
import org.compiere.model.CTreeNode;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNodeMM;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.model.MUserQuery;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CContext;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtServer {
    private CContext m_context = null;
    private Login m_login = null;
    private Locale m_loc = null;
    private CCache<Integer, UIWindow> m_windows = new CCache("AD_Window", 20, 0);
    private CCache<Integer, UITab> m_tabs = new CCache("AD_Tab", 20, 0);
    private CCache<Integer, UIField> m_fields = new CCache("AD_Field", 200, 0);
    private HashMap<Integer, ArrayList<String[]>> m_results = new HashMap();
    private static CLogger log = CLogger.getCLogger(GwtServer.class);
    protected HashMap<Integer, ProcessInfo> processes = new HashMap();
    private static int curZoomWindowNO = 0;

    public GwtServer() {
        if (this.m_context == null) {
            this.m_context = new CContext();
        }
    }

    public Login getLogin() {
        if (this.m_login == null) {
            this.m_login = new Login((Ctx)this.m_context);
        }
        return this.m_login;
    }

    public CContext getContext() {
        return this.m_context;
    }

    public void setLocale(Locale loc) {
        this.m_loc = loc;
    }

    public Locale getLocale() {
        if (this.m_loc == null) {
            return Locale.US;
        }
        return this.m_loc;
    }

    public ArrayList<CTreeNode> getMenuTree() {
        int AD_Tree_ID = this.getTreeID();
        log.fine("AD_Tree_ID=" + AD_Tree_ID + " - " + Env.getAD_Language((Ctx)this.m_context));
        return this.getMenuTree(AD_Tree_ID, false);
    }

    private int getTreeID() {
        int AD_Role_ID = this.m_context.getAD_Role_ID();
        int AD_Tree_ID = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        return AD_Tree_ID;
    }

    public ArrayList<CTreeNode> getMenuFavorites() {
        MUser user = MUser.get((Ctx)this.getContext());
        int AD_Tree_ID = user.getAD_Tree_MenuFavorite_ID();
        if (AD_Tree_ID == 0) {
            return new ArrayList<CTreeNode>();
        }
        return this.getMenuTree(AD_Tree_ID, false);
    }

    public ArrayList<CTreeNode> getMenuCreateNew() {
        MUser user = MUser.get((Ctx)this.getContext());
        int AD_Tree_ID = user.getAD_Tree_MenuNew_ID();
        if (AD_Tree_ID == 0) {
            return new ArrayList<CTreeNode>();
        }
        return this.getMenuTree(AD_Tree_ID, false);
    }

    private ArrayList<CTreeNode> getMenuTree(int AD_Tree_ID, boolean edit) {
        MTree tree = new MTree((Ctx)this.m_context, AD_Tree_ID, edit, true, null);
        CTreeNode root = tree.getRoot();
        Enumeration en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            CTreeNode nd = (CTreeNode)en.nextElement();
            if (!nd.isTask() && !nd.isWorkbench() && !nd.isWorkFlow() && nd.getNode_ID() != 383) continue;
            CTreeNode parent = (CTreeNode)nd.getParent();
            parent.remove((MutableTreeNode)nd);
        }
        tree.trimTree();
        en = root.preorderEnumeration();
        ArrayList<CTreeNode> retValue = new ArrayList<CTreeNode>();
        while (en.hasMoreElements()) {
            CTreeNode nd = (CTreeNode)en.nextElement();
            if (nd.getAD_Form_ID() == 116 || nd.getAD_Form_ID() == 117 || nd.getAD_Form_ID() == 119 || nd.getAD_Form_ID() == 105 || nd.getAD_Form_ID() == 106 || nd.getAD_Form_ID() == 102 || nd.getAD_Window_ID() == 298 || nd.getAD_Window_ID() == 283 || nd.getAD_Window_ID() == 153 || nd.getAD_Window_ID() == 162 || nd.getAD_Window_ID() == 118 || nd.getAD_Window_ID() == 255 || nd.getAD_Workflow_ID() == 106 || nd.getAD_Workflow_ID() == 104 || nd.getAD_Workflow_ID() == 112 || nd.getAD_Workflow_ID() == 113 || nd.getAD_Workflow_ID() == 110 || nd.getAD_Workflow_ID() == 111) continue;
            retValue.add(nd);
        }
        return retValue;
    }

    public boolean updateFavorites(boolean add, int Node_ID) {
        MUser user = MUser.get((Ctx)this.getContext());
        return user.addUserMenuFavorite(Node_ID, 0);
    }

    public boolean updateFavorites(List<Integer> menuIDs) {
        MUser user = MUser.get((Ctx)this.getContext());
        MTree menuTree = null;
        menuTree = user.getUserFavoriteTree();
        if (menuTree == null) {
            return false;
        }
        return this.updateUserTree(menuIDs, menuTree);
    }

    public boolean updateCreateNew(boolean add, int Node_ID) {
        MUser user = MUser.get((Ctx)this.getContext());
        return user.addUserMenuNewFavorite(Node_ID, 0);
    }

    public boolean updateCreateNew(List<Integer> menuIDs) {
        MUser user = MUser.get((Ctx)this.getContext());
        MTree menuTree = null;
        menuTree = user.getUserNewFavoriteTree();
        if (menuTree == null) {
            return false;
        }
        return this.updateUserTree(menuIDs, menuTree);
    }

    private boolean updateUserTree(List<Integer> menuIDs, MTree menuTree) {
        CTreeNode root = menuTree.getRoot();
        if (root != null) {
            Enumeration nodes = root.preorderEnumeration();
            while (nodes.hasMoreElements()) {
                CTreeNode nd = (CTreeNode)nodes.nextElement();
                if (menuIDs.contains(nd.getNode_ID())) continue;
                MTreeNodeMM node = null;
                node = MTreeNodeMM.get((MTree)menuTree, (int)nd.getNode_ID());
                if (node == null || node.delete(true)) continue;
                return false;
            }
        }
        int seq = 0;
        for (int id : menuIDs) {
            MTreeNodeMM node = null;
            node = MTreeNodeMM.get((MTree)menuTree, (int)id);
            if (node == null) {
                node = new MTreeNodeMM(menuTree, id);
            }
            node.setSeqNo(++seq);
            if (node.save()) continue;
            return false;
        }
        return true;
    }

    public int getRequests() {
        return GwtServerUtil.getRequests((Ctx)this.m_context);
    }

    public int getNotes() {
        return GwtServerUtil.getNotes((Ctx)this.m_context);
    }

    public UIWindow getWindow(int windowNo, int AD_Window_ID, int AD_Menu_ID) {
        UIWindowVOFactory winFactory = new UIWindowVOFactory();
        UIWindowVO winVO = winFactory.get((Ctx)this.m_context, AD_Window_ID, AD_Menu_ID);
        if (winVO == null) {
            log.config("No Window - AD_Window_ID=" + AD_Window_ID + ",AD_Menu_ID=" + AD_Menu_ID);
            return null;
        }
        UIWindow win = new UIWindow(winVO, this.m_context);
        AD_Window_ID = win.getAD_Window_ID();
        this.m_windows.put((Object)new Integer(AD_Window_ID), (Object)win);
        int AD_UserDef_Win_ID = win.getAD_UserDef_Win_ID();
        UIFieldVOFactory fieldFactory = new UIFieldVOFactory();
        win.setFields(fieldFactory.getAll((Ctx)this.m_context, AD_Window_ID, AD_UserDef_Win_ID));
        UITabVOFactory tabFactory = new UITabVOFactory();
        win.setTabVOs(tabFactory.getAll((Ctx)this.m_context, AD_Window_ID, AD_UserDef_Win_ID), windowNo);
        log.fine(win.toString());
        return win;
    }

    protected UIWindow getWindow(int windowNo, int AD_Window_ID) {
        UIWindow win = (UIWindow)this.m_windows.get((Object)new Integer(AD_Window_ID));
        if (win == null) {
            win = this.getWindow(windowNo, AD_Window_ID, 0);
        }
        return win;
    }

    public UITab getTab(int AD_Tab_ID) {
        Integer tabKey = new Integer(AD_Tab_ID);
        UITab tab = (UITab)this.m_tabs.get((Object)tabKey);
        if (tab == null) {
            this.fillTabsFields();
            tab = (UITab)this.m_tabs.get((Object)tabKey);
        }
        return tab;
    }

    public UIField getField(int AD_Field_ID, int windowNo) {
        Integer key = new Integer(AD_Field_ID);
        UIField field = (UIField)this.m_fields.get((Object)key);
        if (field == null) {
            UIFieldVOFactory fieldFactory;
            UIFieldVO vo;
            this.fillTabsFields();
            field = (UIField)this.m_fields.get((Object)key);
            if (field == null && (vo = (fieldFactory = new UIFieldVOFactory()).get((Ctx)this.m_context, AD_Field_ID)) != null) {
                field = new UIField(vo);
                field.initialize(this.m_context, windowNo);
                log.warning("Loaded directly: " + field);
                this.m_fields.put((Object)key, (Object)field);
            }
        }
        return field;
    }

    private void fillTabsFields() {
        for (UIWindow win : this.m_windows.values()) {
            ArrayList tabs = win.getTabs();
            for (int j = 0; j < tabs.size(); ++j) {
                UITab winTab = (UITab)tabs.get(j);
                Integer tabKey = new Integer(winTab.getAD_Tab_ID());
                this.m_tabs.put((Object)tabKey, (Object)winTab);
                ArrayList fields = winTab.getFields();
                for (int k = 0; k < fields.size(); ++k) {
                    UIField field = (UIField)fields.get(k);
                    Integer fieldKey = new Integer(field.getAD_Field_ID());
                    this.m_fields.put((Object)fieldKey, (Object)field);
                }
            }
        }
    }

    public int evaluateQuery(int AD_Tab_ID, QueryVO queryVO, HashMap<String, String> context) {
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return -1;
        }
        return tab.evaluateQuery(queryVO, context, this.m_context);
    }

    public int executeQuery(int AD_Tab_ID, QueryVO queryVO, HashMap<String, String> context, int queryResultID) {
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return -1;
        }
        ArrayList result = tab.executeQueryString(queryVO, context, this.m_context);
        if (result == null) {
            log.config("Not Result for AD_Tab_ID=" + AD_Tab_ID);
            return -1;
        }
        MRole role = MRole.get((Ctx)this.m_context, (int)this.m_context.getAD_Role_ID(), (int)this.m_context.getAD_User_ID(), (boolean)false);
        if (role.isQueryMax(result.size())) {
            this.m_results.put(queryResultID, new ArrayList());
            return -1;
        }
        this.m_results.put(queryResultID, result);
        return result.size();
    }

    public String[][] getResults(int queryResultID, int fromRow, int noRows) {
        int index;
        if (noRows < 0) {
            log.config("Invalid: fromRow=" + fromRow + ",noRows" + noRows);
            return null;
        }
        if (noRows == 0) {
            return new String[0][];
        }
        ArrayList<String[]> resultAll = this.m_results.get(queryResultID);
        if (resultAll == null) {
            log.config("No Results for queryResultID=" + queryResultID);
            return null;
        }
        if (resultAll.size() < fromRow) {
            log.config("Insufficient Results for queryResultID=" + queryResultID + ", Length=" + resultAll.size() + ", fromRow=" + fromRow);
            return null;
        }
        if (resultAll.size() < noRows) {
            log.config("Insufficient Rows for queryResultID=" + queryResultID + ", Length=" + resultAll.size() + ", fromRow=" + fromRow + ", noRows=" + noRows);
            noRows = resultAll.size();
        }
        String[][] result = new String[noRows][];
        for (int i = 0; i < noRows && (index = i + fromRow) < resultAll.size(); ++i) {
            result[i] = resultAll.get(index);
        }
        return result;
    }

    public String[] requery(int queryResultID, int row) {
        String[][] results = this.getResults(queryResultID, row, 1);
        return results[0];
    }

    public String sort(int queryResultID, int relColumnNo, boolean ascending) {
        return "Not implemented";
    }

    public void releaseResults() {
        this.m_results = new HashMap();
    }

    public void releaseResults(ArrayList<Integer> resultIDs) {
        System.out.println("before cached id:" + this.m_results.keySet());
        for (int queryResultID : resultIDs) {
            this.m_results.remove(queryResultID);
        }
        System.out.println("after cached id:" + this.m_results.keySet());
    }

    public ChangeVO newRow(int windowNo, int AD_Tab_ID, Map<String, String> context) {
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return null;
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        ctx.setIsSOTrx(windowNo, tab.isSOTrx());
        ChangeVO change = tab.newRow(ctx, windowNo);
        return change;
    }

    public ChangeVO refreshRow(int windowNo, int AD_Tab_ID, int queryResultID, int relRowNo, Map<String, String> context) {
        if (context == null || context.size() == 0) {
            return new ChangeVO(true, "No Context");
        }
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return new ChangeVO(true, "@NotFound@ @AD_Tab_ID@=" + AD_Tab_ID);
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        ChangeVO retValue = tab.refreshRow(ctx, windowNo);
        if (retValue.hasError()) {
            return retValue;
        }
        ArrayList<String[]> data = this.m_results.get(queryResultID);
        if (data == null) {
            retValue.addError("Data Not Found");
        } else {
            String[] dataRow = (String[])retValue.rowData.clone();
            data.set(relRowNo, dataRow);
            int j = 0;
            for (UIField field : tab.getFields()) {
                if (field.isEncryptedField() || field.isEncryptedColumn() || "Password".equals(field.getColumnName())) {
                    retValue.rowData[j] = "";
                }
                ++j;
            }
        }
        return retValue;
    }

    public ChangeVO updateRow(int windowNo, int AD_Tab_ID, int queryResultID, int relRowNo, Map<String, String> context, boolean force) {
        if (context == null || context.size() == 0) {
            return new ChangeVO(true, "No Context");
        }
        ArrayList<String[]> data = this.m_results.get(queryResultID);
        if (data == null) {
            return new ChangeVO(true, "Cached Data Not Found");
        }
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return new ChangeVO(true, Msg.translate((Ctx)this.m_context, (String)("@NotFound@ @AD_Tab_ID@=" + AD_Tab_ID)));
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        ChangeVO retValue = force ? tab.saveRow(ctx, windowNo, false, null) : tab.saveRow(ctx, windowNo, false, data.get(relRowNo));
        if (retValue.hasError()) {
            return retValue;
        }
        String[] dataRow = (String[])retValue.rowData.clone();
        data.set(relRowNo, dataRow);
        int j = 0;
        for (UIField field : tab.getFields()) {
            if (field.isEncryptedField() || field.isEncryptedColumn() || "Password".equals(field.getColumnName())) {
                retValue.rowData[j] = "";
            }
            ++j;
        }
        return retValue;
    }

    public ChangeVO updateRow(int windowNo, int AD_Tab_ID, int queryResultID, int relRowNo, Map<String, String> context) {
        return this.updateRow(windowNo, AD_Tab_ID, queryResultID, relRowNo, context, false);
    }

    public ChangeVO insertRow(int windowNo, int AD_Tab_ID, int queryResultID, int curRow, Map<String, String> context) {
        if (context == null || context.size() == 0) {
            return new ChangeVO(true, "No Context");
        }
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return new ChangeVO(true, "@NotFound@ @AD_Tab_ID@=" + AD_Tab_ID);
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        ChangeVO retValue = tab.saveRow(ctx, windowNo, true);
        if (retValue.hasError()) {
            return retValue;
        }
        ArrayList<String[]> data = this.m_results.get(queryResultID);
        if (data == null) {
            retValue.addError("Data Not Found");
        } else {
            String[] dataRow = retValue.rowData;
            if (curRow >= data.size()) {
                data.add(dataRow);
            } else {
                data.add(curRow, dataRow);
            }
        }
        return retValue;
    }

    public ChangeVO deleteRow(int windowNo, int AD_Tab_ID, int queryResultID, int relRowNo) {
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return new ChangeVO(true, "@NotFound@ @AD_Tab_ID@=" + AD_Tab_ID);
        }
        ArrayList<String[]> data = this.m_results.get(queryResultID);
        if (data == null) {
            return new ChangeVO(true, "Data Not Found");
        }
        String[] rowData = data.get(relRowNo);
        HashMap<String, String> context = new HashMap<String, String>();
        String[] columns = tab.getColumnNames();
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            context.put(column, rowData[i]);
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        ChangeVO retValue = tab.deleteRow(ctx, windowNo);
        if (retValue.hasError()) {
            return retValue;
        }
        data.remove(relRowNo);
        return retValue;
    }

    public ChangeVO fieldChanged(int windowNo, int AD_Field_ID, int AD_Tab_ID, String oldValue, String newValue, Map<String, String> context) {
        if (oldValue == null || oldValue.equals("NULLValue")) {
            oldValue = "";
        }
        if (newValue == null || newValue.equals("NULLValue")) {
            newValue = "";
        }
        if (oldValue.equals(newValue)) {
            return null;
        }
        UITab tab = this.getTab(AD_Tab_ID);
        if (tab == null) {
            log.config("Not found AD_Tab_ID=" + AD_Tab_ID);
            return null;
        }
        UIField field = this.getField(AD_Field_ID, windowNo);
        if (field == null) {
            log.warning("Cannot find AD_Field_ID=" + AD_Field_ID);
            return null;
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        ChangeVO change = tab.fieldChanged(ctx, windowNo, field, oldValue, newValue);
        ctx.setContext(windowNo, field.getColumnName(), change.newConfirmedFieldValue);
        tab.refreshDropDowns(change, windowNo, ctx);
        return change;
    }

    public ArrayList<NamePair> getLookupValueDirect(int AD_Field_ID, ArrayList<String> keyValues, boolean cache) {
        int windowNo = 0;
        ArrayList<NamePair> displayValues = new ArrayList<NamePair>();
        UIField field = this.getField(AD_Field_ID, windowNo);
        if (field == null) {
            log.warning("Cannot find AD_Field_ID=" + AD_Field_ID);
        }
        for (int i = 0; i < keyValues.size(); ++i) {
            String key = keyValues.get(i);
            String value = null;
            if (field != null) {
                value = field.getLookupDisplay(this.m_context, windowNo, key, cache);
            }
            if (value == null) {
                value = key == null ? "" : "<" + key + ">";
            }
            ValueNamePair pp = new ValueNamePair(key, value);
            displayValues.add((NamePair)pp);
        }
        return displayValues;
    }

    public ArrayList<NamePair> getLookupData(int windowNo, int AD_Field_ID, Map<String, String> context, boolean refresh) {
        UIField field = this.getField(AD_Field_ID, windowNo);
        if (field == null) {
            log.warning("Cannot find AD_Field_ID=" + AD_Field_ID);
            return null;
        }
        CContext ctx = new CContext(this.m_context.entrySet());
        ctx.addWindow(windowNo, context);
        if (field.isLookup()) {
            return field.getLookupData((Ctx)ctx, windowNo, refresh);
        }
        log.warning("No Lookup: " + field.getColumnName());
        return null;
    }

    public void setProcessInfo(int windowNO, ProcessInfo pi) {
        this.processes.put(new Integer(windowNO), pi);
    }

    public ProcessInfo getProcessInfo(int windowNO) {
        return this.processes.get(new Integer(windowNO));
    }

    public int getZoomWindowNO() {
        return curZoomWindowNO += 100;
    }

    public Boolean savePreferences(Map ctx) {
        String uiTheme;
        String showAdvanced;
        String autoCommit;
        CContext cContext = this.getContext();
        MUser user = MUser.get((Ctx)cContext);
        MUserPreference preference = user.getPreference();
        String printerName = (String)ctx.get("PrinterName");
        if (printerName != null && printerName.trim().equalsIgnoreCase("")) {
            cContext.setPrinterName(printerName);
            preference.setPrinterName(printerName);
        }
        if ((autoCommit = (String)ctx.get("AutoCommit")) != null) {
            cContext.setAutoCommit(autoCommit.trim().equalsIgnoreCase("Y"));
            preference.setIsAutoCommit(autoCommit.trim().equalsIgnoreCase("Y"));
        }
        if ((showAdvanced = (String)ctx.get("#ShowAdvanced")) != null) {
            cContext.setContext("#ShowAdvanced", showAdvanced);
            preference.setIsShowAdvanced(showAdvanced.trim().equalsIgnoreCase("Y"));
        }
        if ((uiTheme = (String)ctx.get("#UITheme")) != null && !uiTheme.trim().equalsIgnoreCase("")) {
            cContext.setContext("#UITheme", uiTheme);
            preference.setUITheme(uiTheme);
        }
        return preference.save();
    }

    public Boolean deleteSavedSearch(int tab_ID, String savedSearchName) {
        CContext cContext = this.getContext();
        MUserQuery query = MUserQuery.getForUser((Ctx)cContext, (int)tab_ID, (String)savedSearchName);
        if (query != null && query.deleteLines() && query.delete(true)) {
            return true;
        }
        return false;
    }
}

