/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class CalloutAssignment
extends CalloutEngine {
    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutAssignment.isCalloutActive() || value == null) {
            return "";
        }
        int S_ResourceAssignment_ID = (Integer)value;
        if (S_ResourceAssignment_ID == 0) {
            return "";
        }
        CalloutAssignment.setCalloutActive(true);
        int M_Product_ID = 0;
        String Name = null;
        String Description = null;
        BigDecimal Qty = null;
        String sql = "SELECT p.M_Product_ID, ra.Name, ra.Description, ra.Qty FROM S_ResourceAssignment ra INNER JOIN M_Product p ON (p.S_Resource_ID=ra.S_Resource_ID) WHERE ra.S_ResourceAssignment_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, S_ResourceAssignment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_Product_ID = rs.getInt(1);
                Name = rs.getString(2);
                Description = rs.getString(3);
                Qty = rs.getBigDecimal(4);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "product", (Throwable)e);
        }
        this.log.fine("S_ResourceAssignment_ID=" + S_ResourceAssignment_ID + " - M_Product_ID=" + M_Product_ID);
        if (M_Product_ID != 0) {
            mTab.setValue("M_Product_ID", (Object)new Integer(M_Product_ID));
            if (Description != null) {
                Name = Name + " (" + Description + ")";
            }
            if (!".".equals(Name)) {
                mTab.setValue("Description", (Object)Name);
            }
            String variable = "Qty";
            if (mTab.getTableName().startsWith("C_Order")) {
                variable = "QtyOrdered";
            } else if (mTab.getTableName().startsWith("C_Invoice")) {
                variable = "QtyInvoiced";
            }
            if (Qty != null) {
                mTab.setValue(variable, (Object)Qty);
            }
        }
        CalloutAssignment.setCalloutActive(false);
        return "";
    }
}

