/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.Callout;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class CalloutEngine
implements Callout {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static boolean s_calloutActive = false;

    public String start(Ctx ctx, String methodName, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        Method method;
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("No Method Name");
        }
        String retValue = "";
        StringBuffer msg = new StringBuffer(methodName).append(" - ").append(mField.getColumnName()).append("=").append(value).append(" (old=").append(oldValue).append(") {active=").append(CalloutEngine.isCalloutActive()).append("}");
        if (!CalloutEngine.isCalloutActive()) {
            this.log.info(msg.toString());
        }
        if ((method = this.getMethod(methodName)) == null) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 5 && argLength != 6) {
            throw new IllegalArgumentException("Method " + methodName + " has invalid no of arguments: " + argLength);
        }
        try {
            Object[] args = null;
            args = argLength == 6 ? new Object[]{ctx, new Integer(WindowNo), mTab, mField, value, oldValue} : new Object[]{ctx, new Integer(WindowNo), mTab, mField, value};
            retValue = (String)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            CalloutEngine.setCalloutActive(false);
            Throwable ex = e.getCause();
            if (ex == null) {
                ex = e;
            }
            this.log.log(Level.SEVERE, "start: " + methodName, ex);
            ex.printStackTrace(System.err);
            retValue = ex.getLocalizedMessage();
        }
        return retValue;
    }

    public String convert(String methodName, String value) {
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("No Method Name");
        }
        String retValue = null;
        StringBuffer msg = new StringBuffer(methodName).append(" - ").append(value);
        this.log.info(msg.toString());
        Method method = this.getMethod(methodName);
        if (method == null) {
            throw new IllegalArgumentException("Method not found: " + methodName);
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 1) {
            throw new IllegalArgumentException("Method " + methodName + " has invalid no of arguments: " + argLength);
        }
        try {
            Object[] args = new Object[]{value};
            retValue = (String)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            CalloutEngine.setCalloutActive(false);
            this.log.log(Level.SEVERE, "convert: " + methodName, (Throwable)e);
            e.printStackTrace(System.err);
        }
        return retValue;
    }

    private Method getMethod(String methodName) {
        Method[] allMethods = this.getClass().getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!methodName.equals(allMethods[i].getName())) continue;
            return allMethods[i];
        }
        return null;
    }

    protected static boolean isCalloutActive() {
        return s_calloutActive;
    }

    protected static void setCalloutActive(boolean active) {
        s_calloutActive = active;
    }

    public String dateAcct(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutEngine.isCalloutActive()) {
            return "";
        }
        if (value == null || !(value instanceof Timestamp)) {
            return "";
        }
        mTab.setValue("DateAcct", value);
        return "";
    }

    public String rate(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutEngine.isCalloutActive() || value == null) {
            return "";
        }
        CalloutEngine.setCalloutActive(true);
        BigDecimal rate1 = (BigDecimal)value;
        BigDecimal rate2 = Env.ZERO;
        BigDecimal one = new BigDecimal(1.0);
        if (rate1.doubleValue() != 0.0) {
            rate2 = one.divide(rate1, 12, 4);
        }
        if (mField.getColumnName().equals("MultiplyRate")) {
            mTab.setValue("DivideRate", (Object)rate2);
        } else {
            mTab.setValue("MultiplyRate", (Object)rate2);
        }
        this.log.info(mField.getColumnName() + "=" + rate1 + " => " + rate2);
        CalloutEngine.setCalloutActive(false);
        return "";
    }
}

