/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MMeasure;
import org.compiere.model.X_PA_Achievement;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MAchievement
extends X_PA_Achievement {
    private static CLogger s_log = CLogger.getCLogger(MAchievement.class);

    public static MAchievement[] get(MMeasure measure) {
        return MAchievement.getOfMeasure(measure.getCtx(), measure.getPA_Measure_ID());
    }

    public static MAchievement[] getOfMeasure(Ctx ctx, int PA_Measure_ID) {
        ArrayList<MAchievement> list = new ArrayList<MAchievement>();
        String sql = "SELECT * FROM PA_Achievement WHERE PA_Measure_ID=? AND IsAchieved='Y' ORDER BY SeqNo, DateDoc";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, PA_Measure_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAchievement(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAchievement[] retValue = new MAchievement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAchievement(Ctx ctx, int PA_Achievement_ID, String trxName) {
        super(ctx, PA_Achievement_ID, trxName);
    }

    public MAchievement(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAchievement[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isAchieved()) {
            if (this.getManualActual().signum() == 0) {
                this.setManualActual(Env.ONE);
            }
            if (this.getDateDoc() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            this.updateAchievementGoals();
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateAchievementGoals();
        }
        return success;
    }

    private void updateAchievementGoals() {
        MMeasure measure = MMeasure.get(this.getCtx(), this.getPA_Measure_ID());
        measure.updateGoals();
    }
}

