/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.logging.Level;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MLot;
import org.compiere.model.MLotCtl;
import org.compiere.model.MSerNoCtl;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;

public class MAttributeSetInstance
extends X_M_AttributeSetInstance {
    private static CLogger s_log = CLogger.getCLogger(MAttributeSetInstance.class);
    private MAttributeSet m_mas = null;
    private DateFormat m_dateFormat = DisplayType.getDateFormat((int)15);

    public static MAttributeSetInstance get(Ctx ctx, int M_AttributeSetInstance_ID, int M_Product_ID) {
        MAttributeSetInstance retValue = null;
        if (M_AttributeSetInstance_ID != 0) {
            s_log.fine("From M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
            return new MAttributeSetInstance(ctx, M_AttributeSetInstance_ID, null);
        }
        s_log.fine("From M_Product_ID=" + M_Product_ID);
        if (M_Product_ID == 0) {
            return null;
        }
        String sql = "SELECT M_AttributeSet_ID, M_AttributeSetInstance_ID FROM M_Product WHERE M_Product_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int M_AttributeSet_ID = rs.getInt(1);
                retValue = new MAttributeSetInstance(ctx, 0, M_AttributeSet_ID, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        return retValue;
    }

    public MAttributeSetInstance(Ctx ctx, int M_AttributeSetInstance_ID, String trxName) {
        super(ctx, M_AttributeSetInstance_ID, trxName);
        if (M_AttributeSetInstance_ID == 0) {
            // empty if block
        }
    }

    public MAttributeSetInstance(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttributeSetInstance(Ctx ctx, int M_AttributeSetInstance_ID, int M_AttributeSet_ID, String trxName) {
        this(ctx, M_AttributeSetInstance_ID, trxName);
        this.setM_AttributeSet_ID(M_AttributeSet_ID);
    }

    public void setMAttributeSet(MAttributeSet mas) {
        this.m_mas = mas;
        this.setM_AttributeSet_ID(mas.getM_AttributeSet_ID());
    }

    public MAttributeSet getMAttributeSet() {
        if (this.m_mas == null && this.getM_AttributeSet_ID() != 0) {
            this.m_mas = new MAttributeSet(this.getCtx(), this.getM_AttributeSet_ID(), this.get_TrxName());
        }
        return this.m_mas;
    }

    public void setDescription() {
        MAttributeInstance mai;
        int i;
        this.getMAttributeSet();
        if (this.m_mas == null) {
            this.setDescription("");
            return;
        }
        StringBuffer sb = new StringBuffer();
        MAttribute[] attributes = this.m_mas.getMAttributes(true);
        for (i = 0; i < attributes.length; ++i) {
            mai = attributes[i].getMAttributeInstance(this.getM_AttributeSetInstance_ID());
            if (mai == null || mai.getValue() == null) continue;
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(mai.getValue());
        }
        if (this.m_mas.isSerNo() && this.getSerNo() != null) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(this.m_mas.getSerNoCharStart()).append(this.getSerNo()).append(this.m_mas.getSerNoCharEnd());
        }
        if (this.m_mas.isLot() && this.getLot() != null) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(this.m_mas.getLotCharStart()).append(this.getLot()).append(this.m_mas.getLotCharEnd());
        }
        if (this.m_mas.isGuaranteeDate() && this.getGuaranteeDate() != null) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(this.m_dateFormat.format(this.getGuaranteeDate()));
        }
        attributes = this.m_mas.getMAttributes(false);
        for (i = 0; i < attributes.length; ++i) {
            mai = attributes[i].getMAttributeInstance(this.getM_AttributeSetInstance_ID());
            if (mai == null || mai.getValue() == null) continue;
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(mai.getValue());
        }
        this.setDescription(sb.toString());
    }

    public Timestamp getGuaranteeDate(boolean getNew) {
        int days;
        if (getNew && (days = this.getMAttributeSet().getGuaranteeDays()) > 0) {
            Timestamp ts = TimeUtil.addDays((Timestamp)new Timestamp(System.currentTimeMillis()), (int)days);
            this.setGuaranteeDate(ts);
        }
        return this.getGuaranteeDate();
    }

    public String getLot(boolean getNew, int M_Product_ID) {
        if (getNew) {
            this.createLot(M_Product_ID);
        }
        return this.getLot();
    }

    public KeyNamePair createLot(int M_Product_ID) {
        KeyNamePair retValue = null;
        int M_LotCtl_ID = this.getMAttributeSet().getM_LotCtl_ID();
        if (M_LotCtl_ID != 0) {
            MLotCtl ctl = new MLotCtl(this.getCtx(), M_LotCtl_ID, null);
            MLot lot = ctl.createLot(M_Product_ID);
            this.setM_Lot_ID(lot.getM_Lot_ID());
            this.setLot(lot.getName());
            retValue = new KeyNamePair(lot.getM_Lot_ID(), lot.getName());
        }
        return retValue;
    }

    public void setLot(String Lot, int M_Product_ID) {
        MLot mLot = MLot.getProductLot(this.getCtx(), M_Product_ID, Lot, this.get_TrxName());
        if (mLot != null) {
            this.setM_Lot_ID(mLot.getM_Lot_ID());
        }
        this.setLot(Lot);
    }

    public boolean isExcludeLot(int AD_Column_ID, boolean isSOTrx) {
        this.getMAttributeSet();
        if (this.m_mas != null) {
            return this.m_mas.isExcludeLot(AD_Column_ID, isSOTrx);
        }
        return false;
    }

    public String getSerNo(boolean getNew) {
        int M_SerNoCtl_ID;
        if (getNew && (M_SerNoCtl_ID = this.getMAttributeSet().getM_SerNoCtl_ID()) != 0) {
            MSerNoCtl ctl = new MSerNoCtl(this.getCtx(), M_SerNoCtl_ID, this.get_TrxName());
            this.setSerNo(ctl.createSerNo());
        }
        return this.getSerNo();
    }

    public boolean isExcludeSerNo(int AD_Column_ID, boolean isSOTrx) {
        this.getMAttributeSet();
        if (this.m_mas != null) {
            return this.m_mas.isExcludeSerNo(AD_Column_ID, isSOTrx);
        }
        return false;
    }
}

