/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_BankStatementLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankStatementLine
extends X_C_BankStatementLine {
    public MBankStatementLine(Ctx ctx, int C_BankStatementLine_ID, String trxName) {
        super(ctx, C_BankStatementLine_ID, trxName);
        if (C_BankStatementLine_ID == 0) {
            this.setStmtAmt(Env.ZERO);
            this.setTrxAmt(Env.ZERO);
            this.setInterestAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setIsReversal(false);
        }
    }

    public MBankStatementLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatementLine(MBankStatement statement) {
        this(statement.getCtx(), 0, statement.get_TrxName());
        this.setClientOrg((PO)statement);
        this.setC_BankStatement_ID(statement.getC_BankStatement_ID());
        this.setStatementLineDate(statement.getStatementDate());
    }

    public MBankStatementLine(MBankStatement statement, int lineNo) {
        this(statement);
        this.setLine(lineNo);
    }

    public void setPayment(MPayment payment) {
        this.setC_Payment_ID(payment.getC_Payment_ID());
        this.setC_Currency_ID(payment.getC_Currency_ID());
        BigDecimal amt = payment.getPayAmt(true);
        this.setTrxAmt(amt);
        this.setStmtAmt(amt);
        this.setDescription(payment.getDescription());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setStatementLineDate(Timestamp StatementLineDate) {
        super.setStatementLineDate(StatementLineDate);
        this.setValutaDate(StatementLineDate);
        this.setDateAcct(StatementLineDate);
    }

    @UICallout
    public void setStatementLineDate(String oldStatementLineDate, String newStatementLineDate, int windowNo) throws Exception {
        if (newStatementLineDate == null || newStatementLineDate.length() == 0) {
            return;
        }
        Timestamp statementLineDate = PO.convertToTimestamp((String)newStatementLineDate);
        if (statementLineDate == null) {
            return;
        }
        this.setStatementLineDate(statementLineDate);
    }

    @UICallout
    public void setChargeAmt(String oldChargeAmt, String newChargeAmt, int windowNo) throws Exception {
        if (newChargeAmt == null || newChargeAmt.length() == 0) {
            return;
        }
        BigDecimal ChargeAmt = new BigDecimal(newChargeAmt);
        super.setChargeAmt(ChargeAmt);
        this.setAmt(windowNo, "ChargeAmt");
    }

    @UICallout
    public void setInterestAmt(String oldInterestAmt, String newInterestAmt, int windowNo) throws Exception {
        if (newInterestAmt == null || newInterestAmt.length() == 0) {
            return;
        }
        BigDecimal InterestAmt = new BigDecimal(newInterestAmt);
        super.setInterestAmt(InterestAmt);
        this.setAmt(windowNo, "InterestAmt");
    }

    @UICallout
    public void setStmtAmt(String oldStmtAmt, String newStmtAmt, int windowNo) throws Exception {
        if (newStmtAmt == null || newStmtAmt.length() == 0) {
            return;
        }
        BigDecimal StmtAmt = new BigDecimal(newStmtAmt);
        super.setStmtAmt(StmtAmt);
        this.setAmt(windowNo, "StmtAmt");
    }

    private void setAmt(int windowNo, String columnName) {
        BigDecimal trx;
        BigDecimal stmt = this.getStmtAmt();
        if (stmt == null) {
            stmt = Env.ZERO;
        }
        if ((trx = this.getTrxAmt()) == null) {
            trx = Env.ZERO;
        }
        BigDecimal bd = stmt.subtract(trx);
        if (columnName.equals("ChargeAmt")) {
            BigDecimal charge = this.getChargeAmt();
            if (charge == null) {
                charge = Env.ZERO;
            }
            bd = bd.subtract(charge);
            this.setInterestAmt(bd);
        } else {
            BigDecimal interest = this.getInterestAmt();
            if (interest == null) {
                interest = Env.ZERO;
            }
            bd = bd.subtract(interest);
            this.setChargeAmt(bd);
        }
    }

    @UICallout
    public void setC_Payment_ID(String oldC_Payment_ID, String newC_Payment_ID, int windowNo) throws Exception {
        if (newC_Payment_ID == null || newC_Payment_ID.length() == 0) {
            return;
        }
        int C_Payment_ID = Integer.parseInt(newC_Payment_ID);
        if (C_Payment_ID == 0) {
            return;
        }
        this.setC_Payment_ID(C_Payment_ID);
        BigDecimal stmt = this.getStmtAmt();
        if (stmt == null) {
            stmt = Env.ZERO;
        }
        String sql = "SELECT PayAmt FROM C_Payment_v WHERE C_Payment_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Payment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal bd = rs.getBigDecimal(1);
                this.setTrxAmt(bd);
                if (stmt.signum() == 0) {
                    this.setStmtAmt(bd);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.setAmt(windowNo, "C_Payment_ID");
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getChargeAmt().signum() != 0 && this.getC_Charge_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"C_Charge_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM C_BankStatementLine WHERE C_BankStatement_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_BankStatement_ID());
            this.setLine(ii);
        }
        if (this.getC_Payment_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            this.setC_BPartner_ID(payment.getC_BPartner_ID());
            if (payment.getC_Invoice_ID() != 0) {
                this.setC_Invoice_ID(payment.getC_Invoice_ID());
            }
        }
        if (this.getC_Invoice_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        }
        BigDecimal amt = this.getStmtAmt();
        amt = amt.subtract(this.getTrxAmt());
        if ((amt = amt.subtract(this.getInterestAmt())).compareTo(this.getChargeAmt()) != 0) {
            this.setChargeAmt(amt);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateHeader();
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.updateHeader();
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE C_BankStatement bs SET StatementDifference=(SELECT COALESCE( SUM(StmtAmt), 0 ) FROM C_BankStatementLine bsl WHERE bsl.C_BankStatement_ID=bs.C_BankStatement_ID AND bsl.IsActive='Y') WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE C_BankStatement bs SET EndingBalance=BeginningBalance+StatementDifference WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }
}

