/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostQueue;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.X_M_CostDetail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCostDetail
extends X_M_CostDetail {
    private static CLogger s_log = CLogger.getCLogger(MCostDetail.class);

    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE FROM M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_OrderLine_ID=" + C_OrderLine_ID + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_OrderLine_ID=? AND M_AttributeSetInstance_ID=?", C_OrderLine_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_OrderLine_ID(C_OrderLine_ID);
        } else {
            cd.setDeltaAmt(cd.getAmt().subtract(Amt));
            cd.setDeltaQty(cd.getQty().subtract(Qty));
            if (cd.isDelta()) {
                cd.setProcessed(false);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Ctx)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE FROM M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_InvoiceLine_ID=" + C_InvoiceLine_ID + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_InvoiceLine_ID=? AND M_AttributeSetInstance_ID=?", C_InvoiceLine_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        } else {
            cd.setDeltaAmt(cd.getAmt().subtract(Amt));
            cd.setDeltaQty(cd.getQty().subtract(Qty));
            if (cd.isDelta()) {
                cd.setProcessed(false);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Ctx)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE FROM M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InOutLine_ID=" + M_InOutLine_ID + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InOutLine_ID=? AND M_AttributeSetInstance_ID=?", M_InOutLine_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InOutLine_ID(M_InOutLine_ID);
            cd.setIsSOTrx(IsSOTrx);
        } else {
            cd.setDeltaAmt(cd.getAmt().subtract(Amt));
            cd.setDeltaQty(cd.getQty().subtract(Qty));
            if (cd.isDelta()) {
                cd.setProcessed(false);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Ctx)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE FROM M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InventoryLine_ID=" + M_InventoryLine_ID + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InventoryLine_ID=? AND M_AttributeSetInstance_ID=?", M_InventoryLine_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InventoryLine_ID(M_InventoryLine_ID);
        } else {
            cd.setDeltaAmt(cd.getAmt().subtract(Amt));
            cd.setDeltaQty(cd.getQty().subtract(Qty));
            if (cd.isDelta()) {
                cd.setProcessed(false);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Ctx)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE FROM M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_MovementLine_ID=" + M_MovementLine_ID + " AND IsSOTrx=" + (from ? "'Y'" : "'N'") + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_MovementLine_ID=? AND M_AttributeSetInstance_ID=? AND IsSOTrx=" + (from ? "'Y'" : "'N'"), M_MovementLine_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_MovementLine_ID(M_MovementLine_ID);
            cd.setIsSOTrx(from);
        } else {
            cd.setDeltaAmt(cd.getAmt().subtract(Amt));
            cd.setDeltaQty(cd.getQty().subtract(Qty));
            if (cd.isDelta()) {
                cd.setProcessed(false);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Ctx)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE FROM M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_ProductionLine_ID=" + M_ProductionLine_ID + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=? AND M_AttributeSetInstance_ID=?", M_ProductionLine_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_ProductionLine_ID(M_ProductionLine_ID);
        } else {
            cd.setDeltaAmt(cd.getAmt().subtract(Amt));
            cd.setDeltaQty(cd.getQty().subtract(Qty));
            if (cd.isDelta()) {
                cd.setProcessed(false);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Ctx)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    private static MCostDetail get(Ctx ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, String trxName) {
        String sql = "SELECT * FROM M_CostDetail WHERE " + whereClause;
        MCostDetail retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ID);
            pstmt.setInt(2, M_AttributeSetInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCostDetail(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql + " - " + ID, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static boolean processProduct(MProduct product, String trxName) {
        String sql = "SELECT * FROM M_CostDetail WHERE M_Product_ID=? AND Processed='N' ORDER BY C_AcctSchema_ID, M_CostElement_ID, AD_Org_ID, M_AttributeSetInstance_ID, Created";
        int counterOK = 0;
        int counterError = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, product.getM_Product_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MCostDetail cd = new MCostDetail(product.getCtx(), rs, trxName);
                if (cd.process()) {
                    ++counterOK;
                    continue;
                }
                ++counterError;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
            ++counterError;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.config(product.getValue() + ": OK=" + counterOK + ", Errors=" + counterError);
        return counterError == 0;
    }

    public MCostDetail(Ctx ctx, int M_CostDetail_ID, String trxName) {
        super(ctx, M_CostDetail_ID, trxName);
        if (M_CostDetail_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setProcessed(false);
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setIsSOTrx(false);
            this.setDeltaAmt(Env.ZERO);
            this.setDeltaQty(Env.ZERO);
        }
    }

    public MCostDetail(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    public void setAmt(BigDecimal Amt) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Amt - processed");
        }
        if (Amt == null) {
            super.setAmt(Env.ZERO);
        } else {
            super.setAmt(Amt);
        }
    }

    public void setQty(BigDecimal Qty) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change Qty - processed");
        }
        if (Qty == null) {
            super.setQty(Env.ZERO);
        } else {
            super.setQty(Qty);
        }
    }

    public boolean isOrder() {
        return this.getC_OrderLine_ID() != 0;
    }

    public boolean isInvoice() {
        return this.getC_InvoiceLine_ID() != 0;
    }

    public boolean isShipment() {
        return this.isSOTrx() && this.getM_InOutLine_ID() != 0;
    }

    public boolean isDelta() {
        return this.getDeltaAmt().signum() != 0 || this.getDeltaQty().signum() != 0;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MCostDetail[");
        sb.append(this.get_ID());
        if (this.getC_OrderLine_ID() != 0) {
            sb.append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getC_InvoiceLine_ID() != 0) {
            sb.append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            sb.append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID());
        }
        if (this.getM_MovementLine_ID() != 0) {
            sb.append(",M_MovementLine_ID=").append(this.getM_MovementLine_ID());
        }
        if (this.getM_InventoryLine_ID() != 0) {
            sb.append(",M_InventoryLine_ID=").append(this.getM_InventoryLine_ID());
        }
        if (this.getM_ProductionLine_ID() != 0) {
            sb.append(",M_ProductionLine_ID=").append(this.getM_ProductionLine_ID());
        }
        sb.append(",Amt=").append(this.getAmt()).append(",Qty=").append(this.getQty());
        if (this.isDelta()) {
            sb.append(",DeltaAmt=").append(this.getDeltaAmt()).append(",DeltaQty=").append(this.getDeltaQty());
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized boolean process() {
        if (this.isProcessed()) {
            this.log.info("Already processed");
            return true;
        }
        boolean ok = false;
        MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
        String CostingLevel = as.getCostingLevel();
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), product.getM_Product_Category_ID(), this.getC_AcctSchema_ID(), null);
        if (pca.getCostingLevel() != null) {
            CostingLevel = pca.getCostingLevel();
        }
        int Org_ID = this.getAD_Org_ID();
        int M_ASI_ID = this.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            Org_ID = 0;
            M_ASI_ID = 0;
        } else if ("O".equals(CostingLevel)) {
            M_ASI_ID = 0;
        } else if ("B".equals(CostingLevel)) {
            Org_ID = 0;
        }
        if (this.getM_CostElement_ID() == 0) {
            MCostElement ce;
            MCostElement[] ces = MCostElement.getCostingMethods((PO)this);
            for (int i = 0; i < ces.length && (ok = this.process(as, product, ce = ces[i], Org_ID, M_ASI_ID)); ++i) {
            }
        } else {
            MCostElement ce = MCostElement.get((Ctx)this.getCtx(), (int)this.getM_CostElement_ID());
            ok = this.process(as, product, ce, Org_ID, M_ASI_ID);
        }
        if (ok) {
            this.setDeltaAmt(null);
            this.setDeltaQty(null);
            this.setProcessed(true);
            ok = this.save();
        }
        this.log.info(ok + " - " + this.toString());
        return ok;
    }

    private boolean process(MAcctSchema as, MProduct product, MCostElement ce, int Org_ID, int M_ASI_ID) {
        MCost cost = MCost.get(product, M_ASI_ID, as, Org_ID, ce.getM_CostElement_ID());
        BigDecimal qty = this.getQty();
        BigDecimal amt = this.getAmt();
        int precision = as.getCostingPrecision();
        BigDecimal price = amt;
        if (qty.signum() != 0) {
            price = amt.divide(qty, precision, 4);
        }
        if (this.getC_OrderLine_ID() != 0) {
            MOrderLine oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), null);
            boolean isReturnTrx = qty.signum() < 0;
            this.log.fine(" ");
            if (ce.isAveragePO()) {
                if (!isReturnTrx) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.add(amt, qty);
                }
                this.log.finer("PO - AveragePO - " + (Object)((Object)cost));
            } else if (ce.isLastPOPrice()) {
                if (!isReturnTrx) {
                    if (qty.signum() != 0) {
                        cost.setCurrentCostPrice(price);
                    } else {
                        BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                        cost.setCurrentCostPrice(cCosts);
                    }
                }
                cost.add(amt, qty);
                this.log.finer("PO - LastPO - " + (Object)((Object)cost));
            } else if (ce.isUserDefined()) {
                this.log.finer("PO - UserDef - " + (Object)((Object)cost));
            } else if (!ce.isCostingMethod()) {
                this.log.finer("PO - " + ce + " - " + (Object)((Object)cost));
            }
        } else if (this.getC_InvoiceLine_ID() != 0) {
            boolean isReturnTrx;
            boolean bl = isReturnTrx = qty.signum() < 0;
            if (ce.isAverageInvoice()) {
                if (!isReturnTrx) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.add(amt, qty);
                }
                this.log.finer("Inv - AverageInv - " + (Object)((Object)cost));
            } else if (ce.isFifo() || ce.isLifo()) {
                MCostQueue cq = MCostQueue.get(product, this.getM_AttributeSetInstance_ID(), as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
                cq.setCosts(amt, qty, precision);
                cq.save();
                MCostQueue[] cQueue = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, this.get_TrxName());
                if (cQueue != null && cQueue.length > 0) {
                    cost.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
                }
                cost.add(amt, qty);
                this.log.finer("Inv - FiFo/LiFo - " + (Object)((Object)cost));
            } else if (ce.isLastInvoice()) {
                if (!isReturnTrx) {
                    if (qty.signum() != 0) {
                        cost.setCurrentCostPrice(price);
                    } else {
                        BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                        cost.setCurrentCostPrice(cCosts);
                    }
                }
                cost.add(amt, qty);
                this.log.finer("Inv - LastInv - " + (Object)((Object)cost));
            } else if (ce.isStandardCosting()) {
                if (cost.getCurrentCostPrice().signum() == 0) {
                    cost.setCurrentCostPrice(price);
                    if (cost.getCurrentCostPrice().signum() == 0 && cost.get_ID() == 0) {
                        cost.setCurrentCostPrice(MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, ce.getCostingMethod(), this.getC_OrderLine_ID()));
                    }
                }
                cost.add(amt, qty);
                this.log.finer("Inv - Standard - " + (Object)((Object)cost));
            } else if (ce.isUserDefined()) {
                cost.add(amt, qty);
                this.log.finer("Inv - UserDef - " + (Object)((Object)cost));
            } else if (!ce.isCostingMethod()) {
                BigDecimal cCosts = cost.getCurrentCostPrice().add(amt);
                cost.setCurrentCostPrice(cCosts);
                cost.add(amt, qty);
                this.log.finer("Inv - none - " + (Object)((Object)cost));
            }
        } else if (this.getM_InOutLine_ID() != 0 || this.getM_MovementLine_ID() != 0 || this.getM_InventoryLine_ID() != 0 || this.getM_ProductionLine_ID() != 0 || this.getC_ProjectIssue_ID() != 0) {
            boolean addition;
            boolean bl = addition = qty.signum() > 0;
            if (ce.isAverageInvoice()) {
                if (addition) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - AverageInv - " + (Object)((Object)cost));
            } else if (ce.isAveragePO()) {
                if (addition) {
                    cost.setWeightedAverage(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - AveragePO - " + (Object)((Object)cost));
            } else if (ce.isFifo() || ce.isLifo()) {
                if (addition) {
                    MCostQueue cq = MCostQueue.get(product, this.getM_AttributeSetInstance_ID(), as, Org_ID, ce.getM_CostElement_ID(), this.get_TrxName());
                    cq.setCosts(amt, qty, precision);
                    cq.save();
                } else {
                    MCostQueue.adjustQty(product, M_ASI_ID, as, Org_ID, ce, qty.negate(), this.get_TrxName());
                }
                MCostQueue[] cQueue = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, this.get_TrxName());
                if (cQueue != null && cQueue.length > 0) {
                    cost.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
                }
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                this.log.finer("QtyAdjust - FiFo/Lifo - " + (Object)((Object)cost));
            } else if (ce.isLastInvoice()) {
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                this.log.finer("QtyAdjust - LastInv - " + (Object)((Object)cost));
            } else if (ce.isLastPOPrice()) {
                cost.setCurrentQty(cost.getCurrentQty().add(qty));
                this.log.finer("QtyAdjust - LastPO - " + (Object)((Object)cost));
            } else if (ce.isStandardCosting()) {
                if (addition) {
                    cost.add(amt, qty);
                    if (cost.getCurrentCostPrice().signum() == 0 && cost.get_ID() == 0) {
                        cost.setCurrentCostPrice(price);
                    }
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - Standard - " + (Object)((Object)cost));
            } else if (ce.isUserDefined()) {
                if (addition) {
                    cost.add(amt, qty);
                } else {
                    cost.setCurrentQty(cost.getCurrentQty().add(qty));
                }
                this.log.finer("QtyAdjust - UserDef - " + (Object)((Object)cost));
            } else if (!ce.isCostingMethod()) {
                this.log.finer("QtyAdjust - ?none? - " + (Object)((Object)cost));
            } else {
                this.log.warning("QtyAdjust - " + ce + " - " + (Object)((Object)cost));
            }
        } else {
            this.log.warning("Unknown Type: " + this.toString());
            return false;
        }
        return cost.save();
    }
}

