/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductLocator;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_InOutLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInOutLine
extends X_M_InOutLine {
    private static CLogger s_log = CLogger.getCLogger(MInOutLine.class);
    private MProduct m_product = null;
    private int m_M_Warehouse_ID = 0;
    private MInOut m_parent = null;
    private MMatchInv[] m_matchInv = null;
    private MMatchPO[] m_matchPO = null;

    public static MInOutLine[] getOfOrderLine(Ctx ctx, int C_OrderLine_ID, String where, String trxName) {
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        String sql = "SELECT * FROM M_InOutLine WHERE C_OrderLine_ID=?";
        if (where != null && where.length() > 0) {
            sql = sql + " AND " + where;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInOutLine(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MInOutLine[] retValue = new MInOutLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MInOutLine[] get(Ctx ctx, int C_OrderLine_ID, String trxName) {
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        String sql = "SELECT * FROM M_InOutLine WHERE C_OrderLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInOutLine(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MInOutLine[] retValue = new MInOutLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MInOutLine(Ctx ctx, int M_InOutLine_ID, String trxName) {
        super(ctx, M_InOutLine_ID, trxName);
        if (M_InOutLine_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setConfirmedQty(Env.ZERO);
            this.setPickedQty(Env.ZERO);
            this.setScrappedQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setIsInvoiced(false);
            this.setIsDescription(false);
        }
    }

    public MInOutLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLine(MInOut inout) {
        this(inout.getCtx(), 0, inout.get_TrxName());
        this.setClientOrg((PO)inout);
        this.setM_InOut_ID(inout.getM_InOut_ID());
        this.setM_Warehouse_ID(inout.getM_Warehouse_ID());
        this.setC_Project_ID(inout.getC_Project_ID());
        this.m_parent = inout;
    }

    public MInOut getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        MProduct product = oLine.getProduct();
        if (product == null) {
            this.setM_Product_ID(0);
            this.setM_AttributeSetInstance_ID(0);
            super.setM_Locator_ID(0);
        } else {
            this.setM_Product_ID(oLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
            if (product.isItem()) {
                if (M_Locator_ID == 0) {
                    this.setM_Locator_ID(Qty);
                } else {
                    this.setM_Locator_ID(M_Locator_ID);
                }
            } else {
                super.setM_Locator_ID(0);
            }
        }
        this.setC_Charge_ID(oLine.getC_Charge_ID());
        this.setDescription(oLine.getDescription());
        this.setIsDescription(oLine.isDescription());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
    }

    @UICallout
    public void setC_OrderLine_ID(String oldC_OrderLine_ID, String newC_OrderLine_ID, int windowNo) throws Exception {
        if (newC_OrderLine_ID == null || newC_OrderLine_ID.length() == 0) {
            return;
        }
        int C_OrderLine_ID = Integer.parseInt(newC_OrderLine_ID);
        if (C_OrderLine_ID == 0) {
            return;
        }
        MOrderLine ol = new MOrderLine(this.getCtx(), C_OrderLine_ID, null);
        if (ol.get_ID() != 0) {
            this.setC_OrderLine_ID(C_OrderLine_ID);
            BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
            this.setMovementQty(MovementQty);
            this.setOrderLine(ol, 0, MovementQty);
            BigDecimal QtyEntered = MovementQty;
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                QtyEntered = QtyEntered.multiply(ol.getQtyEntered()).divide(ol.getQtyOrdered(), 12, 4);
            }
            this.setQtyEntered(QtyEntered);
            if (ol.getParent().isReturnTrx()) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), ol.getOrig_InOutLine_ID(), null);
                this.setM_Locator_ID(ioLine.getM_Locator_ID());
            }
        }
    }

    public void setInvoiceLine(MInvoiceLine iLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        this.setLine(iLine.getLine());
        this.setC_UOM_ID(iLine.getC_UOM_ID());
        int M_Product_ID = iLine.getM_Product_ID();
        if (M_Product_ID == 0) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
        } else {
            this.setM_Product_ID(M_Product_ID);
            this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
            if (M_Locator_ID == 0) {
                this.setM_Locator_ID(Qty);
            } else {
                this.setM_Locator_ID(M_Locator_ID);
            }
        }
        this.setC_Charge_ID(iLine.getC_Charge_ID());
        this.setDescription(iLine.getDescription());
        this.setIsDescription(iLine.isDescription());
        this.setC_Project_ID(iLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(iLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(iLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(iLine.getC_Activity_ID());
        this.setC_Campaign_ID(iLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(iLine.getAD_OrgTrx_ID());
        this.setUser1_ID(iLine.getUser1_ID());
        this.setUser2_ID(iLine.getUser2_ID());
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            this.m_M_Warehouse_ID = this.getParent().getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    public void setM_Warehouse_ID(int warehouse_ID) {
        this.m_M_Warehouse_ID = warehouse_ID;
    }

    public void setM_Locator_ID(int M_Locator_ID) {
        if (M_Locator_ID < 0) {
            throw new IllegalArgumentException("M_Locator_ID is mandatory.");
        }
        this.set_Value("M_Locator_ID", new Integer(M_Locator_ID));
    }

    public void setM_Locator_ID(BigDecimal Qty) {
        MProduct product;
        if (this.getM_Locator_ID() != 0) {
            return;
        }
        if (this.getM_Product_ID() == 0) {
            this.set_ValueNoCheck("M_Locator_ID", null);
            return;
        }
        int M_Locator_ID = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), Qty, this.get_TrxName());
        if (M_Locator_ID == 0 && (M_Locator_ID = MProductLocator.getFirstM_Locator_ID(product = MProduct.get(this.getCtx(), this.getM_Product_ID()), this.getM_Warehouse_ID())) == 0) {
            MWarehouse wh = MWarehouse.get((Ctx)this.getCtx(), (int)this.getM_Warehouse_ID());
            M_Locator_ID = wh.getDefaultM_Locator_ID();
        }
        this.setM_Locator_ID(M_Locator_ID);
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setMovementQty(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setMovementQty(BigDecimal MovementQty) {
        MProduct product = this.getProduct();
        if (MovementQty != null && product != null) {
            int precision = product.getUOMPrecision();
            MovementQty = MovementQty.setScale(precision, 4);
        }
        super.setMovementQty(MovementQty);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        if (M_Product_ID != 0) {
            super.setM_Product_ID(M_Product_ID);
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
        this.m_product = null;
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int windowNo) throws Exception {
        boolean IsSOTrx;
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        if (M_Product_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            return;
        }
        super.setM_Product_ID(M_Product_ID);
        this.setC_Charge_ID(0);
        int M_Locator_ID = 0;
        if (this.getCtx().getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID && this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            this.setM_AttributeSetInstance_ID(this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID"));
            M_Locator_ID = this.getCtx().getContextAsInt(1113, 1113, "M_Locator_ID");
            if (M_Locator_ID != 0) {
                this.setM_Locator_ID(M_Locator_ID);
            }
        } else {
            this.setM_AttributeSetInstance_ID(0);
        }
        if (IsSOTrx = this.getCtx().isSOTrx(windowNo)) {
            return;
        }
        MProduct product = this.getProduct();
        this.setC_UOM_ID(product.getC_UOM_ID());
        BigDecimal QtyEntered = this.getQtyEntered();
        this.setMovementQty(QtyEntered);
        if (M_Locator_ID == 0) {
            int M_Warehouse_ID = this.getCtx().getContextAsInt(windowNo, "M_Warehouse_ID");
            M_Locator_ID = MProductLocator.getFirstM_Locator_ID(product, M_Warehouse_ID);
            if (M_Locator_ID != 0) {
                this.setM_Locator_ID(M_Locator_ID);
            } else {
                MWarehouse wh = MWarehouse.get((Ctx)this.getCtx(), (int)M_Warehouse_ID);
                this.setM_Locator_ID(wh.getDefaultM_Locator_ID());
            }
        }
    }

    @UICallout
    public void setM_AttributeSetInstance_ID(String oldM_AttributeSetInstance_ID, String newM_AttributeSetInstance_ID, int windowNo) throws Exception {
        int selectedM_Locator_ID;
        if (newM_AttributeSetInstance_ID == null || newM_AttributeSetInstance_ID.length() == 0) {
            return;
        }
        int M_AttributeSetInstance_ID = Integer.parseInt(newM_AttributeSetInstance_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        if (M_AttributeSetInstance_ID == 0) {
            return;
        }
        int M_Product_ID = this.getM_Product_ID();
        int M_Warehouse_ID = this.getCtx().getContextAsInt(windowNo, "M_Warehouse_ID");
        int M_Locator_ID = this.getM_Locator_ID();
        this.log.fine("M_Product_ID=" + M_Product_ID + ", M_ASI_ID=" + M_AttributeSetInstance_ID + " - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID);
        int M_ASI_ID = Env.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID");
        if (M_ASI_ID == M_AttributeSetInstance_ID && (selectedM_Locator_ID = Env.getCtx().getContextAsInt(1113, 1113, "M_Locator_ID")) != 0) {
            this.log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
            this.setM_Locator_ID(selectedM_Locator_ID);
        }
    }

    @UICallout
    public void setC_UOM_ID(String oldC_UOM_ID, String newC_UOM_ID, int windowNo) throws Exception {
        if (newC_UOM_ID == null || newC_UOM_ID.length() == 0) {
            return;
        }
        int C_UOM_ID = Integer.parseInt(newC_UOM_ID);
        if (C_UOM_ID == 0) {
            return;
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setQty(windowNo, "C_UOM_ID");
    }

    @UICallout
    public void setQtyEntered(String oldQtyEntered, String newQtyEntered, int windowNo) throws Exception {
        if (newQtyEntered == null || newQtyEntered.length() == 0) {
            return;
        }
        BigDecimal QtyEntered = new BigDecimal(newQtyEntered);
        super.setQtyEntered(QtyEntered);
        this.setQty(windowNo, "QtyEntered");
    }

    @UICallout
    public void setMovementQty(String oldMovementQty, String newMovementQty, int windowNo) throws Exception {
        if (newMovementQty == null || newMovementQty.length() == 0) {
            return;
        }
        BigDecimal MovementQty = new BigDecimal(newMovementQty);
        super.setMovementQty(MovementQty);
        this.setQty(windowNo, "MovementQty");
    }

    private void setQty(int windowNo, String columnName) {
        BigDecimal MovementQty;
        BigDecimal QtyEntered;
        int M_Product_ID = this.getM_Product_ID();
        int C_UOM_To_ID = this.getC_UOM_ID();
        if (M_Product_ID == 0) {
            QtyEntered = this.getQtyEntered();
            this.setMovementQty(QtyEntered);
        } else if (columnName.equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            QtyEntered = this.getQtyEntered();
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(this.getCtx(), C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                this.setQtyEntered(QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "UOMConversion", conversion);
            this.setMovementQty(MovementQty);
        } else if (C_UOM_To_ID == 0) {
            QtyEntered = this.getQtyEntered();
            this.setMovementQty(QtyEntered);
        } else if (columnName.equals("QtyEntered")) {
            BigDecimal QtyEntered1;
            QtyEntered = this.getQtyEntered();
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(this.getCtx(), C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                this.setQtyEntered(QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "UOMConversion", conversion);
            this.setMovementQty(MovementQty);
        } else if (columnName.equals("MovementQty")) {
            int precision;
            BigDecimal MovementQty1;
            MovementQty = this.getMovementQty();
            if (MovementQty.compareTo(MovementQty1 = MovementQty.setScale(precision = MProduct.get(this.getCtx(), M_Product_ID).getUOMPrecision(), 4)) != 0) {
                this.log.fine("Corrected MovementQty " + MovementQty + "->" + MovementQty1);
                MovementQty = MovementQty1;
                this.setMovementQty(MovementQty);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, MovementQty)) == null) {
                QtyEntered = MovementQty;
            }
            boolean conversion = MovementQty.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + MovementQty + " -> " + conversion + " QtyEntered=" + QtyEntered);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "UOMConversion", conversion);
            this.setQtyEntered(QtyEntered);
        }
        boolean IsReturnTrx = this.getParent().isReturnTrx();
        if (M_Product_ID != 0 && IsReturnTrx) {
            MInOutLine orig_IOLine;
            BigDecimal shippedQty;
            Integer orig_IOLine_ID;
            Integer oLine_ID = this.getC_OrderLine_ID();
            MOrderLine oLine = new MOrderLine(this.getCtx(), oLine_ID, null);
            if (oLine.get_ID() != 0 && (orig_IOLine_ID = Integer.valueOf(oLine.getOrig_InOutLine_ID())) != 0 && (shippedQty = (orig_IOLine = new MInOutLine(this.getCtx(), orig_IOLine_ID, null)).getMovementQty()).compareTo(MovementQty = this.getMovementQty()) < 0) {
                if (this.getCtx().isSOTrx(windowNo)) {
                    this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"QtyShippedLessThanQtyReturned", (Object)shippedQty));
                } else {
                    this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"QtyReceivedLessThanQtyReturned", (Object)shippedQty));
                }
                this.setMovementQty(shippedQty);
                MovementQty = shippedQty;
                QtyEntered = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, MovementQty);
                if (QtyEntered == null) {
                    QtyEntered = MovementQty;
                }
                this.setQtyEntered(QtyEntered);
                this.log.fine("QtyEntered : " + QtyEntered.toString() + "MovementQty : " + MovementQty.toString());
            }
        }
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    public MMatchPO[] getMatchPO() {
        if (this.m_matchPO == null) {
            this.m_matchPO = MMatchPO.get(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
        }
        return this.m_matchPO;
    }

    public BigDecimal getMatchPODifference() {
        if (this.isDescription()) {
            return Env.ZERO;
        }
        BigDecimal retValue = this.getMovementQty();
        MMatchPO[] po = this.getMatchPO();
        for (int i = 0; i < po.length; ++i) {
            MMatchPO matchPO = po[i];
            retValue = retValue.subtract(matchPO.getQty());
        }
        this.log.finer("#" + retValue);
        return retValue;
    }

    public boolean isMatchPOPosted() {
        MMatchPO[] po = this.getMatchPO();
        for (int i = 0; i < po.length; ++i) {
            MMatchPO matchPO = po[i];
            if (matchPO.isPosted()) continue;
            return false;
        }
        return true;
    }

    public MMatchInv[] getMatchInv() {
        if (this.m_matchInv == null) {
            this.m_matchInv = MMatchInv.get(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
        }
        return this.m_matchInv;
    }

    public BigDecimal getMatchInvDifference() {
        if (this.isDescription()) {
            return Env.ZERO;
        }
        BigDecimal retValue = this.getMovementQty();
        MMatchInv[] inv = this.getMatchInv();
        for (int i = 0; i < inv.length; ++i) {
            MMatchInv matchInv = inv[i];
            retValue = retValue.subtract(matchInv.getQty());
        }
        this.log.finer("#" + retValue);
        return retValue;
    }

    public boolean isMatchInvPosted() {
        MMatchInv[] inv = this.getMatchInv();
        for (int i = 0; i < inv.length; ++i) {
            MMatchInv matchInv = inv[i];
            if (matchInv.isPosted()) continue;
            return false;
        }
        return true;
    }

    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        this.log.fine("");
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_InOutLine WHERE M_InOut_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getM_InOut_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.getCtx().getContextAsInt("#C_UOM_ID"));
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("MovementQty")) {
            this.setMovementQty(this.getMovementQty());
        }
        if (this.getC_OrderLine_ID() == 0 && this.getParent().isSOTrx()) {
            this.log.saveError("FillMandatory", Msg.translate((Ctx)this.getCtx(), (String)"C_Order_ID"));
            return false;
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.getParent().getDocStatus().equals("DR")) {
            return true;
        }
        this.log.saveError("Error", Msg.getMsg((Ctx)this.getCtx(), (String)"CannotDelete"));
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutLine[").append(this.get_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",QtyEntered=").append(this.getQtyEntered()).append(",MovementQty=").append(this.getMovementQty()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    public BigDecimal getBase(String CostDistribution) {
        if ("C".equals(CostDistribution)) {
            this.log.severe("Not Implemented yet - Cost");
            return Env.ZERO;
        }
        if ("L".equals(CostDistribution)) {
            return Env.ONE;
        }
        if ("Q".equals(CostDistribution)) {
            return this.getMovementQty();
        }
        if ("V".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getVolume());
        }
        if ("W".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getWeight());
        }
        this.log.severe("Invalid Criteria: " + CostDistribution);
        return Env.ZERO;
    }
}

