/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.X_C_LandedCost;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MLandedCost
extends X_C_LandedCost {
    private static CLogger s_log = CLogger.getCLogger(MLandedCost.class);

    public static MLandedCost[] getLandedCosts(MInvoiceLine il) {
        ArrayList<MLandedCost> list = new ArrayList<MLandedCost>();
        String sql = "SELECT * FROM C_LandedCost WHERE C_InvoiceLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)il.get_TrxName());
            pstmt.setInt(1, il.getC_InvoiceLine_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLandedCost(il.getCtx(), rs, il.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MLandedCost[] retValue = new MLandedCost[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MLandedCost(Ctx ctx, int C_LandedCost_ID, String trxName) {
        super(ctx, C_LandedCost_ID, trxName);
        if (C_LandedCost_ID == 0) {
            this.setLandedCostDistribution("Q");
        }
    }

    public MLandedCost(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_Product_ID() == 0 && this.getM_InOut_ID() == 0 && this.getM_InOutLine_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)"@NotFound@ @M_Product_ID@ | @M_InOut_ID@ | @M_InOutLine_ID@"));
            return false;
        }
        if (this.getM_InOutLine_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        return true;
    }

    public String allocateCosts() {
        MInvoiceLine il = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        return il.allocateLandedCosts();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MLandedCost[");
        sb.append(this.get_ID()).append(",CostDistribution=").append(this.getLandedCostDistribution()).append(",M_CostElement_ID=").append(this.getM_CostElement_ID());
        if (this.getM_InOut_ID() != 0) {
            sb.append(",M_InOut_ID=").append(this.getM_InOut_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getM_Product_ID() != 0) {
            sb.append(",M_Product_ID=").append(this.getM_Product_ID());
        }
        sb.append("]");
        return sb.toString();
    }
}

