/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.compiere.Compiere;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClientInfo;
import org.compiere.model.MContactInterest;
import org.compiere.model.MLocation;
import org.compiere.model.MProject;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MStatus;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_C_Lead;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLead
extends X_C_Lead {
    private MBPartner m_bp = null;
    private MUser m_user = null;
    private MRequest m_request = null;
    private MProject m_project = null;
    private MStatus m_Status = null;

    public MLead(Ctx ctx, int C_Lead_ID, String trxName) {
        super(ctx, C_Lead_ID, trxName);
        if (C_Lead_ID == 0) {
            this.setProcessed(false);
        }
    }

    public MLead(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLead(Ctx ctx, Map<String, String> map, String trxName) {
        this(ctx, 0, trxName);
        this.load(map);
        this.setIsActive(true);
        this.setProcessed(false);
    }

    public void setAD_User_ID() {
        if (this.getAD_User_ID() != 0) {
            return;
        }
        String email = this.getEMail();
        if (email != null && email.length() > 0) {
            this.m_user = MUser.get((Ctx)this.getCtx(), (String)email, (String)this.get_TrxName());
            if (this.m_user != null) {
                super.setAD_User_ID(this.m_user.getAD_User_ID());
                if (this.getC_BPartner_ID() == 0) {
                    this.setC_BPartner_ID(this.m_user.getC_BPartner_ID());
                } else if (this.m_user.getC_BPartner_ID() != this.getC_BPartner_ID()) {
                    this.log.warning("@C_BPartner_ID@ (ID=" + this.getC_BPartner_ID() + ") <> @AD_User_ID@ @C_BPartner_ID@ (ID=" + this.m_user.getC_BPartner_ID() + ")");
                }
            }
        }
    }

    public void setAD_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
        this.getUser();
    }

    public MUser getUser() {
        if (this.getAD_User_ID() == 0) {
            this.m_user = null;
        } else if (this.m_user == null || this.m_user.getAD_User_ID() != this.getAD_User_ID()) {
            this.m_user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
        }
        return this.m_user;
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
        this.getBPartner();
    }

    public MBPartner getBPartner() {
        if (this.getC_BPartner_ID() == 0) {
            this.m_bp = null;
        } else if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != this.getC_BPartner_ID()) {
            this.m_bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        }
        return this.m_bp;
    }

    public void setR_Request_ID(int R_Request_ID) {
        super.setR_Request_ID(R_Request_ID);
        this.getRequest();
    }

    public MRequest getRequest() {
        if (this.getR_Request_ID() == 0) {
            this.m_request = null;
        } else if (this.m_request == null || this.m_request.getR_Request_ID() != this.getR_Request_ID()) {
            this.m_request = new MRequest(this.getCtx(), this.getR_Request_ID(), this.get_TrxName());
        }
        return this.m_request;
    }

    public void setR_Status_ID(int R_Status_ID) {
        if (this.isR_Status_IDValid(R_Status_ID)) {
            super.setR_Status_ID(R_Status_ID);
        } else {
            super.setR_Status_ID(0);
        }
        this.getStatus();
    }

    public boolean isR_Status_IDValid(int R_Status_ID) {
        if (R_Status_ID == 0) {
            return true;
        }
        this.m_Status = MStatus.get(this.getCtx(), R_Status_ID);
        int R_StatusCategory_ID = this.m_Status.getR_StatusCategory_ID();
        int R_RequestType_ID = this.getR_RequestType_ID();
        if (R_RequestType_ID == 0) {
            this.log.warning("No Client Request Type");
            return false;
        }
        MRequestType rt = MRequestType.get(this.getCtx(), R_RequestType_ID);
        if (rt.getR_StatusCategory_ID() != R_StatusCategory_ID) {
            this.log.warning("Status Category different - Status(" + R_StatusCategory_ID + ") <> RequestType(" + rt.getR_StatusCategory_ID() + ")");
            return false;
        }
        return true;
    }

    private int getR_RequestType_ID() {
        MClientInfo ci = MClientInfo.get((Ctx)this.getCtx(), (int)this.getAD_Client_ID());
        int R_RequestType_ID = ci.getR_RequestType_ID();
        if (R_RequestType_ID != 0) {
            return R_RequestType_ID;
        }
        this.log.warning("Set Request Type in Window Client Info");
        MRequestType rt = MRequestType.getDefault(this.getCtx());
        if (rt != null) {
            R_RequestType_ID = rt.getR_RequestType_ID();
            return R_RequestType_ID;
        }
        return 0;
    }

    public MStatus getStatus() {
        if (this.getR_Status_ID() == 0) {
            this.m_Status = null;
        } else if (this.m_Status == null || this.m_Status.getR_Status_ID() != this.getR_Status_ID()) {
            this.m_Status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        }
        return this.m_Status;
    }

    public void setC_Project_ID(int C_Project_ID) {
        super.setC_Project_ID(C_Project_ID);
        this.getProject();
    }

    public MProject getProject() {
        if (this.getC_Project_ID() == 0) {
            this.m_project = null;
        } else if (this.m_project == null || this.m_project.getC_Project_ID() != this.getC_Project_ID()) {
            this.m_project = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
        }
        return this.m_project;
    }

    public String getName() {
        String name = super.getName();
        if (name == null && (name = this.getBPName()) == null && (name = this.getContactName()) == null && (name = this.getDocumentNo()) == null) {
            name = "Lead";
        }
        return name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MLead[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public String createBP() {
        String error;
        if (this.getC_BPartner_ID() != 0 && this.getAD_User_ID() != 0 && this.getC_BPartner_Location_ID() == 0) {
            return "@AlreadyExists@: @C_BPartner_ID@ (ID=" + this.getC_BPartner_ID() + ")";
        }
        if (this.getC_BPartner_ID() == 0 && this.getBPName() != null && this.getBPName().length() > 0) {
            this.m_user = this.getUser();
            if (this.m_user != null && this.m_user.getC_BPartner_ID() != 0) {
                this.setC_BPartner_ID(this.m_user.getC_BPartner_ID());
                this.log.info("Set to BPartner of User - " + this.m_user);
                return this.createBPLocation();
            }
            this.m_bp = new MBPartner(this.getCtx(), this.get_TrxName());
            this.m_bp.setAD_Org_ID(this.getAD_Org_ID());
            this.m_bp.setValue(this.getBPName());
            this.m_bp.setName(this.getBPName());
            this.m_bp.setIsCustomer(true);
            if (this.getC_BP_Group_ID() != 0) {
                this.m_bp.setC_BP_Group_ID(this.getC_BP_Group_ID());
            }
            if (this.getC_BP_Size_ID() != 0) {
                this.m_bp.setC_BP_Size_ID(this.getC_BP_Size_ID());
            }
            if (this.getC_BP_Status_ID() != 0) {
                this.m_bp.setC_BP_Status_ID(this.getC_BP_Status_ID());
            }
            if (this.getC_IndustryCode_ID() != 0) {
                this.m_bp.setC_IndustryCode_ID(this.getC_IndustryCode_ID());
            }
            if (this.getNAICS() != null) {
                this.m_bp.setNAICS(this.getNAICS());
            }
            if (this.getDUNS() != null) {
                this.m_bp.setDUNS(this.getDUNS());
            }
            if (this.getNumberEmployees() != 0) {
                this.m_bp.setNumberEmployees(this.getNumberEmployees());
            }
            if (this.getSalesVolume() != 0) {
                this.m_bp.setSalesVolume(this.getSalesVolume());
            }
            if (this.getSalesRep_ID() != 0) {
                this.m_bp.setSalesRep_ID(this.getSalesRep_ID());
            }
            if (!this.m_bp.save()) {
                return "@SaveError@";
            }
            if (this.m_user != null && this.m_user.getC_BPartner_ID() == 0) {
                this.m_user.setC_BPartner_ID(this.m_bp.getC_BPartner_ID());
                this.m_user.save();
            }
            this.setC_BPartner_ID(this.m_bp.getC_BPartner_ID());
        }
        if ((error = this.createBPContact()) != null && error.length() > 0) {
            return error;
        }
        return this.createBPLocation();
    }

    private String createBPContact() {
        if (this.getAD_User_ID() != 0) {
            return null;
        }
        if (this.getContactName() == null || this.getContactName().length() <= 0) {
            this.log.fine("No BP Contact Info to save");
            return null;
        }
        if (this.m_user == null) {
            this.m_user = this.m_bp == null ? new MUser(this.getCtx(), 0, this.get_TrxName()) : new MUser((X_C_BPartner)this.m_bp);
        }
        this.m_user.setName(this.getContactName());
        if (this.getC_Job_ID() != 0) {
            this.m_user.setC_Job_ID(this.getC_Job_ID());
        }
        if (this.getEMail() != null) {
            this.m_user.setEMail(this.getEMail());
        }
        if (this.getC_Greeting_ID() != 0) {
            this.m_user.setC_Greeting_ID(this.getC_Greeting_ID());
        }
        if (this.getPhone() != null) {
            this.m_user.setPhone(this.getPhone());
        }
        if (this.getPhone2() != null) {
            this.m_user.setPhone2(this.getPhone2());
        }
        if (this.getFax() != null) {
            this.m_user.setFax(this.getFax());
        }
        if (!this.m_user.save()) {
            this.log.warning("Contact not saved");
        } else {
            this.setAD_User_ID(this.m_user.getAD_User_ID());
        }
        return null;
    }

    private String createBPLocation() {
        if (this.getC_BPartner_Location_ID() != 0 || this.getC_Country_ID() == 0) {
            return null;
        }
        if (!(this.getAddress1() != null && this.getAddress1().length() > 0 || this.getPostal() != null && this.getPostal().length() > 0 || this.getCity() != null && this.getCity().length() > 0 || this.getRegionName() != null && this.getRegionName().length() > 0)) {
            this.log.fine("No BP Location Info to save");
            return null;
        }
        MLocation location = new MLocation(this.getCtx(), this.getC_Country_ID(), this.getC_Region_ID(), this.getCity(), this.get_TrxName());
        location.setAddress1(this.getAddress1());
        location.setAddress2(this.getAddress2());
        location.setPostal(this.getPostal());
        location.setPostal_Add(this.getPostal_Add());
        location.setRegionName(this.getRegionName());
        if (location.save()) {
            MBPartnerLocation bpl = new MBPartnerLocation(this.m_bp);
            bpl.setC_Location_ID(location.getC_Location_ID());
            bpl.setPhone(this.getPhone());
            bpl.setPhone2(this.getPhone2());
            bpl.setFax(this.getFax());
            if (bpl.save()) {
                this.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
            }
        }
        return null;
    }

    public String createProject(int C_ProjectType_ID) {
        String retValue;
        if (this.getC_Project_ID() != 0) {
            return "@AlreadyExists@: @C_Project_ID@ (ID=" + this.getC_Project_ID() + ")";
        }
        if (this.getC_BPartner_ID() == 0 && (retValue = this.createBP()) != null) {
            return retValue;
        }
        this.m_project = new MProject(this.getCtx(), 0, this.get_TrxName());
        this.m_project.setAD_Org_ID(this.getAD_Org_ID());
        this.m_project.setProjectLineLevel("P");
        this.m_project.setName(this.getName());
        this.m_project.setDescription(this.getDescription());
        this.m_project.setNote(this.getHelp());
        this.m_project.setC_BPartner_ID(this.getC_BPartner_ID());
        this.m_project.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
        this.m_project.setAD_User_ID(this.getAD_User_ID());
        this.m_project.setC_BPartnerSR_ID(this.getC_BPartnerSR_ID());
        this.m_project.setC_Campaign_ID(this.getC_Campaign_ID());
        this.m_project.setC_ProjectType_ID(C_ProjectType_ID);
        this.m_project.setSalesRep_ID(this.getSalesRep_ID());
        this.m_project.setC_SalesRegion_ID(this.getC_SalesRegion_ID());
        if (!this.m_project.save()) {
            return "@SaveError@";
        }
        if (this.getRequest() != null) {
            this.m_request.setC_Project_ID(this.m_project.getC_Project_ID());
            this.m_request.save();
        }
        this.setC_Project_ID(this.m_project.getC_Project_ID());
        return null;
    }

    public String createRequest() {
        int R_RequestType_ID = this.getR_RequestType_ID();
        if (R_RequestType_ID == 0) {
            return "@NotFound@: @R_RequestType_ID@ (@AD_Client_ID@)";
        }
        return this.createRequest(R_RequestType_ID);
    }

    private String createRequest(int R_RequestType_ID) {
        String retValue;
        if (this.getR_Request_ID() != 0) {
            return "@AlreadyExists@: @R_Request_ID@ (ID=" + this.getR_Request_ID() + ")";
        }
        if (this.getC_BPartner_ID() == 0 && (retValue = this.createBP()) != null) {
            return retValue;
        }
        this.m_request = new MRequest(this.getCtx(), 0, this.get_TrxName());
        this.m_request.setAD_Org_ID(this.getAD_Org_ID());
        String summary = this.getName();
        if (summary == null) {
            summary = this.getHelp();
        }
        if (summary == null) {
            summary = this.getSummary();
        }
        if (summary == null) {
            summary = this.getDescription();
        }
        this.m_request.setSummary(summary);
        this.m_request.setR_RequestType_ID(R_RequestType_ID);
        if (this.isR_Status_IDValid(this.getR_Status_ID())) {
            this.m_request.setR_Status_ID(this.getR_Status_ID());
        } else {
            this.m_request.setR_Status_ID();
        }
        this.m_request.setC_Lead_ID(this.getC_Lead_ID());
        this.m_request.setC_BPartner_ID(this.getC_BPartner_ID());
        this.m_request.setAD_User_ID(this.getAD_User_ID());
        this.m_request.setC_Project_ID(this.getC_Project_ID());
        this.m_request.setC_Campaign_ID(this.getC_Campaign_ID());
        this.m_request.setR_Source_ID(this.getR_Source_ID());
        this.m_request.setC_BPartnerSR_ID(this.getC_BPartnerSR_ID());
        this.m_request.setC_SalesRegion_ID(this.getC_SalesRegion_ID());
        this.m_request.setSalesRep_ID(this.getSalesRep_ID());
        if (!this.m_request.save()) {
            return "@SaveError@";
        }
        this.setR_Request_ID(this.m_request.getR_Request_ID());
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getEMail() != null && this.getAD_User_ID() == 0) {
            this.setAD_User_ID();
        }
        if (newRecord || this.is_ValueChanged("R_Status_ID")) {
            if (!this.isR_Status_IDValid(this.getR_Status_ID())) {
                this.setR_Status_ID(0);
            } else if (this.m_Status != null) {
                this.setProcessed(this.m_Status.isClosed());
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.getAD_User_ID() != 0 && this.getR_InterestArea_ID() != 0 && (this.is_ValueChanged("AD_User_ID") || this.is_ValueChanged("R_InterestArea_ID"))) {
            MContactInterest ci = MContactInterest.get(this.getCtx(), this.getR_InterestArea_ID(), this.getAD_User_ID(), true, this.get_TrxName());
            ci.save();
        }
        return true;
    }

    public static void main(String[] args) {
        Compiere.startup((boolean)true);
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("EMail", "test1");
        parameter.put("SalesRep_ID", "0");
        parameter.put("AD_Org_ID", "0");
        parameter.put("Submit", "Submit");
        parameter.put("ForwardTo", "http://www.compiere.com");
        parameter.put("ContactName", "Test 1");
        parameter.put("Name", "Test 1");
        parameter.put("AD_Client_ID", "11");
        parameter.put("R_Source_ID", "100");
        MLead lead = new MLead(Env.getCtx(), parameter, null);
        lead.save();
        System.out.println((Object)lead);
    }
}

