/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MReturnPolicy;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class MOrderLine
extends X_C_OrderLine {
    private static CLogger s_log = CLogger.getCLogger(MOrderLine.class);
    private int m_M_PriceList_ID = 0;
    private boolean m_IsSOTrx = true;
    private MProductPricing m_productPrice = null;
    private Integer m_precision = null;
    private MProduct m_product = null;
    private MOrder m_parent = null;

    public static BigDecimal getNotReserved(Ctx ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int excludeC_OrderLine_ID) {
        BigDecimal retValue = Env.ZERO;
        String sql = "SELECT SUM(QtyOrdered-QtyDelivered-QtyReserved) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.M_Warehouse_ID=? AND M_Product_ID=? AND o.IsSOTrx='Y' AND o.DocStatus='DR' AND QtyOrdered-QtyDelivered-QtyReserved<>0 AND ol.C_OrderLine_ID<>?";
        if (M_AttributeSetInstance_ID != 0) {
            sql = sql + " AND M_AttributeSetInstance_ID=?";
        }
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            pstmt.setInt(3, excludeC_OrderLine_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(4, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.fine("-");
        } else {
            s_log.fine(retValue.toString());
        }
        return retValue;
    }

    public MOrderLine(Ctx ctx, int C_OrderLine_ID, String trxName) {
        super(ctx, C_OrderLine_ID, trxName);
        if (C_OrderLine_ID == 0) {
            this.setFreightAmt(Env.ZERO);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setQtyEntered(Env.ZERO);
            this.setQtyOrdered(Env.ZERO);
            this.setQtyDelivered(Env.ZERO);
            this.setQtyInvoiced(Env.ZERO);
            this.setQtyReserved(Env.ZERO);
            this.setIsDescription(false);
            this.setProcessed(false);
            this.setLine(0);
        }
    }

    public MOrderLine(MOrder order) {
        this(order.getCtx(), 0, order.get_TrxName());
        if (order.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setOrder(order);
    }

    public MOrderLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setOrder(MOrder order) {
        this.setClientOrg((PO)order);
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.setDateOrdered(order.getDateOrdered());
        this.setDatePromised(order.getDatePromised());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setHeaderInfo(order);
    }

    public void setHeaderInfo(MOrder order) {
        this.m_parent = order;
        this.m_precision = new Integer(order.getPrecision());
        this.m_M_PriceList_ID = order.getM_PriceList_ID();
        this.m_IsSOTrx = order.isSOTrx();
    }

    public MOrder getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new IllegalStateException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        this.log.fine(this.toString() + " - M_PriceList_ID=" + M_PriceList_ID);
        this.getProductPricing(M_PriceList_ID);
        this.setPriceActual(this.m_productPrice.getPriceStd());
        this.setPriceList(this.m_productPrice.getPriceList());
        this.setPriceLimit(this.m_productPrice.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyOrdered()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyOrdered().divide(this.getQtyEntered(), 12, 4)));
        }
        this.setDiscount(this.m_productPrice.getDiscount());
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPrice.getC_UOM_ID());
        }
    }

    private MProductPricing getProductPricing(int M_PriceList_ID) {
        this.m_productPrice = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), this.getM_Product_ID(), this.getC_BPartner_ID(), this.getQtyOrdered(), this.m_IsSOTrx);
        this.m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPrice.setPriceDate(this.getDateOrdered());
        this.m_productPrice.calculatePrice();
        return this.m_productPrice;
    }

    public boolean setTax() {
        int ii = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.getDateOrdered(), this.getDateOrdered(), this.getAD_Org_ID(), this.getM_Warehouse_ID(), this.getC_BPartner_Location_ID(), this.getC_BPartner_Location_ID(), this.m_IsSOTrx);
        if (ii == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(ii);
        return true;
    }

    private boolean setTax(int windowNo, String columnName) {
        int M_Product_ID = this.getM_Product_ID();
        int C_Charge_ID = this.getC_Charge_ID();
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.setAmt(windowNo, columnName);
        }
        int shipC_BPartner_Location_ID = this.getC_BPartner_Location_ID();
        if (shipC_BPartner_Location_ID == 0) {
            return this.setAmt(windowNo, columnName);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        Timestamp billDate = this.getDateOrdered();
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = this.getDatePromised();
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = this.getAD_Org_ID();
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = this.getM_Warehouse_ID();
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int billC_BPartner_Location_ID = this.getCtx().getContextAsInt(windowNo, "Bill_Location_ID");
        if (billC_BPartner_Location_ID == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        int C_Tax_ID = Tax.get(this.getCtx(), M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, this.getCtx().isSOTrx(windowNo));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            ValueNamePair pp = CLogger.retrieveError();
            if (pp != null) {
                this.p_changeVO.addError(pp.getValue());
            } else {
                this.p_changeVO.addError("Tax Error");
            }
        } else {
            super.setC_Tax_ID(C_Tax_ID);
        }
        return this.setAmt(windowNo, columnName);
    }

    public void setLineNetAmt() {
        BigDecimal bd = this.getPriceActual().multiply(this.getQtyOrdered());
        if (bd.scale() > this.getPrecision()) {
            bd = bd.setScale(this.getPrecision(), 4);
        }
        super.setLineNetAmt(bd);
    }

    public int getPrecision() {
        MCurrency cur;
        if (this.m_precision != null) {
            return this.m_precision;
        }
        if (this.getC_Currency_ID() == 0) {
            this.setOrder(this.getParent());
            if (this.m_precision != null) {
                return this.m_precision;
            }
        }
        if (this.getC_Currency_ID() != 0 && (cur = MCurrency.get((Ctx)this.getCtx(), (int)this.getC_Currency_ID())).get_ID() != 0) {
            this.m_precision = new Integer(cur.getStdPrecision());
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Order x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Order_ID=?";
        int i = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
        this.m_precision = new Integer(i);
        return this.m_precision;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        if (C_UOM_ID != 0) {
            super.setC_UOM_ID(C_UOM_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int windowNo) throws Exception {
        MProduct product;
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            this.setM_AttributeSetInstance_ID(0);
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        super.setM_Product_ID(M_Product_ID);
        if (M_Product_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            return;
        }
        if (this.getParent().isReturnTrx()) {
            return;
        }
        this.setC_Charge_ID(0);
        int M_AttributeSetInstance_ID = this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID");
        if (this.getCtx().getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID && M_AttributeSetInstance_ID != 0) {
            this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        } else {
            this.setM_AttributeSetInstance_ID(0);
        }
        int C_BPartner_ID = this.getCtx().getContextAsInt(windowNo, "C_BPartner_ID");
        BigDecimal Qty = this.getQtyOrdered();
        boolean IsSOTrx = this.getCtx().isSOTrx(windowNo);
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp orderDate = this.getDateOrdered();
        pp.setPriceDate(orderDate);
        this.setPriceList(pp.getPriceList());
        this.setPriceLimit(pp.getPriceLimit());
        this.setPriceActual(pp.getPriceStd());
        this.setPriceEntered(pp.getPriceStd());
        this.setC_Currency_ID(pp.getC_Currency_ID());
        this.setDiscount(pp.getDiscount());
        this.setC_UOM_ID(pp.getC_UOM_ID());
        this.setQtyOrdered(this.getQtyEntered());
        if (this.p_changeVO != null) {
            this.p_changeVO.setContext(this.getCtx(), windowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit());
            this.p_changeVO.setContext(this.getCtx(), windowNo, "DiscountSchema", pp.isDiscountSchema());
        }
        if (IsSOTrx && (product = this.getProduct()).isStocked()) {
            BigDecimal QtyOrdered = this.getQtyOrdered();
            int M_Warehouse_ID = this.getM_Warehouse_ID();
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID = this.getM_AttributeSetInstance_ID(), null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"NoQtyAvailable", (Object)"0"));
            } else if (available.compareTo(QtyOrdered) < 0) {
                this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"InsufficientQtyAvailable", (Object)available.toString()));
            } else {
                BigDecimal total;
                int C_OrderLine_ID = this.getC_OrderLine_ID();
                BigDecimal notReserved = MOrderLine.getNotReserved(this.getCtx(), M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID);
                if (notReserved == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Ctx)this.getCtx(), (String)("@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total));
                    this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"InsufficientQtyAvailable", (Object)info));
                }
            }
        }
        this.setTax(windowNo, "M_Product_ID");
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", new Integer(0));
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        if (this.getM_Warehouse_ID() > 0 && this.getM_Warehouse_ID() != M_Warehouse_ID && !this.canChangeWarehouse()) {
            this.log.severe("Ignored - Already Delivered/Invoiced/Reserved");
        } else {
            super.setM_Warehouse_ID(M_Warehouse_ID);
        }
    }

    @UICallout
    public void setC_BPartner_Location_ID(String oldC_BPartner_Location_ID, String newC_BPartner_Location_ID, int windowNo) throws Exception {
        if (newC_BPartner_Location_ID == null || newC_BPartner_Location_ID.length() == 0) {
            return;
        }
        int C_BPartner_Location_ID = Integer.parseInt(newC_BPartner_Location_ID);
        if (C_BPartner_Location_ID == 0) {
            return;
        }
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        this.setTax(windowNo, "C_BPartner_Location_ID");
    }

    @UICallout
    public void setC_UOM_ID(String oldC_UOM_ID, String newC_UOM_ID, int windowNo) throws Exception {
        if (newC_UOM_ID == null || newC_UOM_ID.length() == 0) {
            return;
        }
        int C_UOM_ID = Integer.parseInt(newC_UOM_ID);
        if (C_UOM_ID == 0) {
            return;
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setQty(windowNo, "C_UOM_ID");
        this.setAmt(windowNo, "C_UOM_ID");
    }

    @UICallout
    public void setM_AttributeSetInstance_ID(String oldM_AttributeSetInstance_ID, String newM_AttributeSetInstance_ID, int windowNo) throws Exception {
        if (newM_AttributeSetInstance_ID == null || newM_AttributeSetInstance_ID.length() == 0) {
            return;
        }
        int M_AttributeSetInstance_ID = Integer.parseInt(newM_AttributeSetInstance_ID);
        if (M_AttributeSetInstance_ID == 0) {
            return;
        }
        super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setQty(windowNo, "M_AttributeSetInstance_ID");
    }

    @UICallout
    public void setDiscount(String oldDiscount, String newDiscount, int windowNo) throws Exception {
        if (newDiscount == null || newDiscount.length() == 0) {
            return;
        }
        BigDecimal Discount = new BigDecimal(newDiscount);
        super.setDiscount(Discount);
        this.setAmt(windowNo, "Discount");
    }

    @UICallout
    public void setPriceActual(String oldPriceActual, String newPriceActual, int windowNo) throws Exception {
        if (newPriceActual == null || newPriceActual.length() == 0) {
            return;
        }
        BigDecimal PriceActual = new BigDecimal(newPriceActual);
        super.setPriceActual(PriceActual);
        this.setAmt(windowNo, "PriceActual");
    }

    @UICallout
    public void setPriceEntered(String oldPriceEntered, String newPriceEntered, int windowNo) throws Exception {
        if (newPriceEntered == null || newPriceEntered.length() == 0) {
            return;
        }
        BigDecimal PriceEntered = new BigDecimal(newPriceEntered);
        super.setPriceEntered(PriceEntered);
        this.setAmt(windowNo, "PriceEntered");
    }

    @UICallout
    public void setPriceList(String oldPriceList, String newPriceList, int windowNo) throws Exception {
        if (newPriceList == null || newPriceList.length() == 0) {
            return;
        }
        BigDecimal PriceList = new BigDecimal(newPriceList);
        super.setPriceList(PriceList);
        this.setAmt(windowNo, "PriceList");
    }

    @UICallout
    public void setQtyEntered(String oldQtyEntered, String newQtyEntered, int windowNo) throws Exception {
        if (newQtyEntered == null || newQtyEntered.length() == 0) {
            return;
        }
        BigDecimal QtyEntered = new BigDecimal(newQtyEntered);
        super.setQtyEntered(QtyEntered);
        this.setQty(windowNo, "QtyEntered");
        this.setAmt(windowNo, "QtyEntered");
    }

    @UICallout
    public void setQtyOrdered(String oldQtyOrdered, String newQtyOrdered, int windowNo) throws Exception {
        if (newQtyOrdered == null || newQtyOrdered.length() == 0) {
            return;
        }
        BigDecimal QtyOrdered = new BigDecimal(newQtyOrdered);
        super.setQtyOrdered(QtyOrdered);
        this.setQty(windowNo, "QtyOrdered");
        this.setAmt(windowNo, "QtyOrdered");
    }

    @UICallout
    public void setS_ResourceAssignment_ID(String oldS_ResourceAssignment_ID, String newS_ResourceAssignment_ID, int windowNo) throws Exception {
        if (newS_ResourceAssignment_ID == null || newS_ResourceAssignment_ID.length() == 0) {
            return;
        }
        int S_ResourceAssignment_ID = Integer.parseInt(newS_ResourceAssignment_ID);
        if (S_ResourceAssignment_ID == 0) {
            return;
        }
        super.setS_ResourceAssignment_ID(S_ResourceAssignment_ID);
        int M_Product_ID = 0;
        String Name = null;
        String Description = null;
        BigDecimal Qty = null;
        String sql = "SELECT p.M_Product_ID, ra.Name, ra.Description, ra.Qty FROM S_ResourceAssignment ra INNER JOIN M_Product p ON (p.S_Resource_ID=ra.S_Resource_ID) WHERE ra.S_ResourceAssignment_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, S_ResourceAssignment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_Product_ID = rs.getInt(1);
                Name = rs.getString(2);
                Description = rs.getString(3);
                Qty = rs.getBigDecimal(4);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("S_ResourceAssignment_ID=" + S_ResourceAssignment_ID + " - M_Product_ID=" + M_Product_ID);
        if (M_Product_ID != 0) {
            this.setM_Product_ID(M_Product_ID);
            if (Description != null) {
                Name = Name + " (" + Description + ")";
            }
            if (!".".equals(Name)) {
                this.setDescription(Name);
            }
            if (Qty != null) {
                this.setQtyOrdered(Qty);
            }
        }
    }

    private boolean setAmt(int windowNo, String columnName) {
        BigDecimal LineNetAmt;
        boolean enforce;
        int C_UOM_To_ID = this.getC_UOM_ID();
        int M_Product_ID = this.getM_Product_ID();
        int M_PriceList_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_ID");
        int StdPrecision = MPriceList.getPricePrecision(this.getCtx(), M_PriceList_ID);
        BigDecimal QtyEntered = this.getQtyEntered();
        BigDecimal QtyOrdered = this.getQtyOrdered();
        this.log.fine("QtyEntered=" + QtyEntered + ", Ordered=" + QtyOrdered + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = this.getPriceEntered();
        BigDecimal PriceActual = this.getPriceActual();
        BigDecimal Discount = this.getDiscount();
        BigDecimal PriceLimit = this.getPriceLimit();
        BigDecimal PriceList = this.getPriceList();
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        if ((columnName.equals("QtyOrdered") || columnName.equals("QtyEntered") || columnName.equals("M_Product_ID")) && !"N".equals(this.getCtx().getContext(windowNo, "DiscountSchema"))) {
            int C_BPartner_ID = this.getC_BPartner_ID();
            if (columnName.equals("QtyEntered")) {
                QtyOrdered = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (QtyOrdered == null) {
                QtyOrdered = QtyEntered;
            }
            boolean IsSOTrx = this.getCtx().isSOTrx(windowNo);
            MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, QtyOrdered, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = this.getCtx().getContextAsInt(windowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp date = this.getDateOrdered();
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            PriceActual = pp.getPriceStd();
            this.setPriceActual(PriceActual);
            this.setDiscount(pp.getDiscount());
            this.setPriceEntered(PriceEntered);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "DiscountSchema", pp.isDiscountSchema());
        } else if (columnName.equals("PriceActual")) {
            PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            this.setPriceEntered(PriceEntered);
        } else if (columnName.equals("PriceEntered")) {
            PriceActual = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            this.setPriceActual(PriceActual);
        }
        if (columnName.equals("Discount")) {
            PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            this.setPriceActual(PriceActual);
            this.setPriceEntered(PriceEntered);
        } else {
            Discount = PriceList.intValue() == 0 ? Env.ZERO : new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
            if (Discount.scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
            this.setDiscount(Discount);
        }
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        boolean epl = "Y".equals(this.getCtx().getContext(windowNo, "EnforcePriceLimit"));
        boolean bl = enforce = epl && this.getCtx().isSOTrx(windowNo);
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            this.setPriceActual(PriceLimit);
            this.setPriceEntered(PriceEntered);
            this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"UnderLimitPrice"));
            if (PriceList.intValue() != 0) {
                Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                this.setDiscount(Discount);
            }
        }
        if ((LineNetAmt = QtyOrdered.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("LineNetAmt=" + LineNetAmt);
        this.setLineNetAmt(LineNetAmt);
        return true;
    }

    private boolean setQty(int windowNo, String columnName) {
        MProduct product;
        MInOutLine inOutLine;
        BigDecimal shippedQty;
        Integer inOutLine_ID;
        int M_Product_ID = this.getM_Product_ID();
        BigDecimal QtyOrdered = Env.ZERO;
        BigDecimal QtyEntered = null;
        int C_UOM_To_ID = this.getC_UOM_ID();
        boolean IsReturnTrx = this.getParent().isReturnTrx();
        if (M_Product_ID == 0) {
            QtyOrdered = QtyEntered = this.getQtyEntered();
            this.setQtyOrdered(QtyOrdered);
        } else if (columnName.equals("C_UOM_ID") || columnName.equals("Orig_InOutLine_ID")) {
            BigDecimal QtyEntered1;
            QtyEntered = this.getQtyEntered();
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(this.getCtx(), C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                this.setQtyEntered(QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = this.getPriceActual();
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "UOMConversion", conversion);
            this.setQtyOrdered(QtyOrdered);
            this.setPriceEntered(PriceEntered);
        } else if (columnName.equals("QtyEntered")) {
            BigDecimal QtyEntered1;
            QtyEntered = this.getQtyEntered();
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(this.getCtx(), C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                this.setQtyEntered(QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "UOMConversion", conversion);
            this.setQtyOrdered(QtyOrdered);
        } else if (columnName.equals("QtyOrdered")) {
            int precision;
            BigDecimal QtyOrdered1;
            QtyOrdered = this.getQtyOrdered();
            if (QtyOrdered.compareTo(QtyOrdered1 = QtyOrdered.setScale(precision = this.getProduct().getUOMPrecision(), 4)) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                this.setQtyOrdered(QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            this.p_changeVO.setContext(this.getCtx(), windowNo, "UOMConversion", conversion);
            this.setQtyEntered(QtyEntered);
        } else {
            QtyOrdered = this.getQtyOrdered();
        }
        if (M_Product_ID != 0 && IsReturnTrx && (inOutLine_ID = Integer.valueOf(this.getOrig_InOutLine_ID())) != 0 && (shippedQty = (inOutLine = new MInOutLine(this.getCtx(), inOutLine_ID, null)).getMovementQty()).compareTo(QtyOrdered = this.getQtyOrdered()) < 0) {
            if (this.getCtx().isSOTrx(windowNo)) {
                this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"QtyShippedLessThanQtyReturned", (Object)shippedQty));
            } else {
                this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"QtyReceivedLessThanQtyReturned", (Object)shippedQty));
            }
            this.setQtyOrdered(shippedQty);
            QtyOrdered = shippedQty;
            QtyEntered = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyOrdered);
            if (QtyEntered == null) {
                QtyEntered = QtyOrdered;
            }
            this.setQtyEntered(QtyEntered);
            this.log.fine("QtyEntered : " + QtyEntered.toString() + "QtyOrdered : " + QtyOrdered.toString());
        }
        if (M_Product_ID != 0 && this.getCtx().isSOTrx(windowNo) && QtyOrdered.signum() > 0 && !IsReturnTrx && (product = this.getProduct()).isStocked()) {
            int M_AttributeSetInstance_ID;
            int M_Warehouse_ID = this.getM_Warehouse_ID();
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID = this.getM_AttributeSetInstance_ID(), null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"NoQtyAvailable"));
            } else if (available.compareTo(QtyOrdered) < 0) {
                this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"InsufficientQtyAvailable", (Object)available));
            } else {
                BigDecimal total;
                int C_OrderLine_ID = this.getC_OrderLine_ID();
                BigDecimal notReserved = MOrderLine.getNotReserved(this.getCtx(), M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID);
                if (notReserved == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Ctx)this.getCtx(), (String)("@QtyAvailable@=" + available + "  -  @QtyNotReserved@=" + notReserved + "  =  " + total));
                    this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"InsufficientQtyAvailable", (Object)info));
                }
            }
        }
        return true;
    }

    public boolean canChangeWarehouse() {
        if (this.getQtyDelivered().signum() != 0) {
            this.log.saveError("Error", Msg.translate((Ctx)this.getCtx(), (String)"QtyDelivered") + "=" + this.getQtyDelivered());
            return false;
        }
        if (this.getQtyInvoiced().signum() != 0) {
            this.log.saveError("Error", Msg.translate((Ctx)this.getCtx(), (String)"QtyInvoiced") + "=" + this.getQtyInvoiced());
            return false;
        }
        if (this.getQtyReserved().signum() != 0) {
            this.log.saveError("Error", Msg.translate((Ctx)this.getCtx(), (String)"QtyReserved") + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MOrderLine[").append(this.get_ID()).append(",Line=").append(this.getLine()).append(",Ordered=").append(this.getQtyOrdered()).append(",Delivered=").append(this.getQtyDelivered()).append(",Invoiced=").append(this.getQtyInvoiced()).append(",Reserved=").append(this.getQtyReserved()).append(", LineNet=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public String getName() {
        this.getProduct();
        if (this.m_product != null) {
            return this.m_product.getName();
        }
        if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            return charge.getName();
        }
        return "";
    }

    public void setC_Charge_ID(int C_Charge_ID) {
        super.setC_Charge_ID(C_Charge_ID);
        if (C_Charge_ID > 0) {
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
    }

    @UICallout
    public void setC_Charge_ID(String oldC_Charge_ID, String newC_Charge_ID, int windowNo) throws Exception {
        if (newC_Charge_ID == null || newC_Charge_ID.length() == 0) {
            return;
        }
        int C_Charge_ID = Integer.parseInt(newC_Charge_ID);
        if (C_Charge_ID == 0) {
            return;
        }
        if (this.getParent().isReturnTrx()) {
            return;
        }
        if (this.getM_Product_ID() != 0) {
            super.setC_Charge_ID(0);
            this.p_changeVO.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"ChargeExclusively"));
            return;
        }
        super.setC_Charge_ID(C_Charge_ID);
        this.setM_AttributeSetInstance_ID(0);
        this.setS_ResourceAssignment_ID(0);
        this.setC_UOM_ID(100);
        this.p_changeVO.setContext(this.getCtx(), windowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.setPriceEntered(rs.getBigDecimal(1));
                this.setPriceActual(rs.getBigDecimal(1));
                this.setPriceLimit(Env.ZERO);
                this.setPriceList(Env.ZERO);
                this.setDiscount(Env.ZERO);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.setTax(windowNo, "C_Charge_ID");
    }

    public void setDiscount() {
        BigDecimal list = this.getPriceList();
        if (Env.ZERO.compareTo(list) == 0) {
            return;
        }
        BigDecimal discount = list.subtract(this.getPriceActual()).multiply(new BigDecimal(100)).divide(list, this.getPrecision(), 4);
        this.setDiscount(discount);
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_ID FROM C_Order WHERE C_Order_ID=?", (int)this.getC_Order_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    public void setQty(BigDecimal Qty) {
        super.setQtyEntered(Qty);
        super.setQtyOrdered(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setQtyOrdered(BigDecimal QtyOrdered) {
        MProduct product = this.getProduct();
        if (QtyOrdered != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, 4);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    public void setOrigOrderLine(MOrderLine origOrderLine) {
        if (origOrderLine == null || origOrderLine.get_ID() == 0) {
            return;
        }
        this.setOrig_InOutLine_ID(-1);
        this.setC_Tax_ID(origOrderLine.getC_Tax_ID());
        this.setPriceList(origOrderLine.getPriceList());
        this.setPriceLimit(origOrderLine.getPriceLimit());
        this.setPriceActual(origOrderLine.getPriceActual());
        this.setPriceEntered(origOrderLine.getPriceEntered());
        this.setC_Currency_ID(origOrderLine.getC_Currency_ID());
        this.setDiscount(origOrderLine.getDiscount());
    }

    @UICallout
    public void setOrig_OrderLine_ID(String oldOrig_OrderLine_ID, String newOrig_OrderLine_ID, int windowNo) throws Exception {
        if (newOrig_OrderLine_ID == null || newOrig_OrderLine_ID.length() == 0) {
            return;
        }
        int Orig_OrderLine_ID = Integer.parseInt(newOrig_OrderLine_ID);
        if (Orig_OrderLine_ID == 0) {
            return;
        }
        this.p_changeVO.setContext(this.getCtx(), windowNo, "EnforcePriceLimit", false);
        this.p_changeVO.setContext(this.getCtx(), windowNo, "DiscountSchema", false);
        MOrderLine oLine = new MOrderLine(this.getCtx(), Orig_OrderLine_ID, null);
        if (oLine.get_ID() != 0) {
            this.setOrigOrderLine(oLine);
        }
    }

    public void setOrigInOutLine(MInOutLine Orig_InOutLine) {
        if (Orig_InOutLine == null || Orig_InOutLine.get_ID() == 0) {
            return;
        }
        this.setC_Project_ID(Orig_InOutLine.getC_Project_ID());
        this.setC_Campaign_ID(Orig_InOutLine.getC_Campaign_ID());
        this.setM_Product_ID(Orig_InOutLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(Orig_InOutLine.getM_AttributeSetInstance_ID());
        this.setC_UOM_ID(Orig_InOutLine.getC_UOM_ID());
    }

    @UICallout
    public void setOrig_InOutLine_ID(String oldOrig_InOutLine_ID, String newOrig_InOutLine_ID, int windowNo) throws Exception {
        if (newOrig_InOutLine_ID == null || newOrig_InOutLine_ID.length() == 0) {
            return;
        }
        int Orig_InOutLine_ID = Integer.parseInt(newOrig_InOutLine_ID);
        if (Orig_InOutLine_ID == 0) {
            return;
        }
        MInOutLine ioLine = new MInOutLine(this.getCtx(), Orig_InOutLine_ID, null);
        if (ioLine.get_ID() != 0) {
            this.setOrigInOutLine(ioLine);
        }
        this.setQty(windowNo, "Orig_InOutLine_ID");
    }

    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        int C_UOM_ID;
        if (this.getC_BPartner_ID() == 0 || this.getC_BPartner_Location_ID() == 0 || this.getM_Warehouse_ID() == 0 || this.getC_Currency_ID() == 0) {
            this.setOrder(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo(this.getParent());
        }
        if (!newRecord && (this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_Warehouse_ID")) && !this.canChangeWarehouse()) {
            return false;
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        } else {
            if (this.m_productPrice == null && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            if (this.m_productPrice == null) {
                this.getProductPricing(this.m_M_PriceList_ID);
            }
            if (!this.m_productPrice.isCalculated()) {
                this.log.saveError("Error", Msg.getMsg((Ctx)this.getCtx(), (String)"ProductNotOnPriceList"));
                return false;
            }
        }
        if (this.getC_UOM_ID() == 0 && (this.getM_Product_ID() != 0 || this.getPriceEntered().compareTo(Env.ZERO) != 0 || this.getC_Charge_ID() != 0) && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyOrdered")) {
            this.setQtyOrdered(this.getQtyOrdered());
        }
        if (this.m_IsSOTrx && this.getM_AttributeSetInstance_ID() != 0 && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_AttributeSetInstance_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (product = this.getProduct()).isStocked()) {
            boolean isInstance;
            int M_AttributeSet_ID = product.getM_AttributeSet_ID();
            boolean bl = isInstance = M_AttributeSet_ID != 0;
            if (isInstance) {
                MAttributeSet mas = MAttributeSet.get(this.getCtx(), M_AttributeSet_ID);
                isInstance = mas.isInstanceAttribute();
            }
            if (isInstance) {
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), M_AttributeSet_ID, false, null, true, this.get_TrxName());
                BigDecimal qty = Env.ZERO;
                for (int i = 0; i < storages.length; ++i) {
                    if (storages[i].getM_AttributeSetInstance_ID() != this.getM_AttributeSetInstance_ID()) continue;
                    qty = qty.add(storages[i].getQtyOnHand());
                }
                if (this.getQtyOrdered().compareTo(qty) > 0) {
                    this.log.warning("Qty - Stock=" + qty + ", Ordered=" + this.getQtyOrdered());
                    this.log.saveError("QtyInsufficient", "=" + qty);
                    return false;
                }
            }
        }
        if (Env.ZERO.compareTo(this.getFreightAmt()) != 0) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_OrderLine WHERE C_Order_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
            this.setLine(ii);
        }
        this.setLineNetAmt();
        this.setDiscount();
        MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        boolean isReturnTrx = order.isReturnTrx();
        if (isReturnTrx) {
            Boolean withinPolicy = true;
            if (order.getM_ReturnPolicy_ID() == 0) {
                order.setM_ReturnPolicy_ID();
            }
            if (order.getM_ReturnPolicy_ID() == 0) {
                withinPolicy = false;
            } else {
                MInOut origInOut = new MInOut(this.getCtx(), order.getOrig_InOut_ID(), this.get_TrxName());
                MReturnPolicy rpolicy = new MReturnPolicy(this.getCtx(), order.getM_ReturnPolicy_ID(), this.get_TrxName());
                this.log.fine("RMA Date : " + order.getDateOrdered() + " Shipment Date : " + origInOut.getMovementDate());
                withinPolicy = rpolicy.checkReturnPolicy(origInOut.getMovementDate(), order.getDateOrdered(), this.getM_Product_ID());
            }
            if (!withinPolicy.booleanValue()) {
                if (!MRole.getDefault().isOverrideReturnPolicy()) {
                    this.log.saveError("Error", Msg.getMsg((Ctx)this.getCtx(), (String)"ReturnPolicyExceeded"));
                    return false;
                }
                this.log.saveWarning("Warning", Msg.getMsg((Ctx)this.getCtx(), (String)"ReturnPolicyExceeded"));
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (Env.ZERO.compareTo(this.getQtyDelivered()) != 0) {
            this.log.saveError("DeleteError", Msg.translate((Ctx)this.getCtx(), (String)"QtyDelivered") + "=" + this.getQtyDelivered());
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyInvoiced()) != 0) {
            this.log.saveError("DeleteError", Msg.translate((Ctx)this.getCtx(), (String)"QtyInvoiced") + "=" + this.getQtyInvoiced());
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyReserved()) != 0) {
            this.log.saveError("DeleteError", Msg.translate((Ctx)this.getCtx(), (String)"QtyReserved") + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!this.isProcessed()) {
            MOrderTax tax;
            if (!newRecord && this.is_ValueChanged("C_Tax_ID") && (tax = MOrderTax.get(this, this.getPrecision(), true, this.get_TrxName())) != null) {
                if (!tax.calculateTaxFromLines()) {
                    return false;
                }
                if (!tax.save(this.get_TrxName())) {
                    return false;
                }
            }
            if (!this.updateHeaderTax()) {
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("QtyInvoiced")) {
            MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
            MOrderLine[] oLines = order.getLines(true, null);
            boolean isInvoiced = true;
            for (int i = 0; i < oLines.length; ++i) {
                MOrderLine line = oLines[i];
                if (line.getQtyInvoiced().compareTo(line.getQtyOrdered()) >= 0) continue;
                isInvoiced = false;
                break;
            }
            order.setIsInvoiced(isInvoiced);
            if (!order.save()) {
                return false;
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getS_ResourceAssignment_ID() != 0) {
            MResourceAssignment ra = new MResourceAssignment(this.getCtx(), this.getS_ResourceAssignment_ID(), this.get_TrxName());
            ra.delete(true);
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        MOrderTax tax = MOrderTax.get(this, this.getPrecision(), false, this.get_TrxName());
        if (!tax.calculateTaxFromLines()) {
            return false;
        }
        if (!tax.save(this.get_TrxName())) {
            return false;
        }
        String sql = "UPDATE C_Order i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_OrderLine il WHERE i.C_Order_ID=il.C_Order_ID) WHERE C_Order_ID=" + this.getC_Order_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = this.isTaxIncluded() ? "UPDATE C_Order i SET GrandTotal=TotalLines WHERE C_Order_ID=" + this.getC_Order_ID() : "UPDATE C_Order i SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_OrderTax it WHERE i.C_Order_ID=it.C_Order_ID) WHERE C_Order_ID=" + this.getC_Order_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }
}

