/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.model.X_AD_Schedule;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.Ctx;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MSchedule
extends X_AD_Schedule {
    private static CCache<Integer, MSchedule> s_cache = new CCache("AD_Schedule", 20);

    public static MSchedule get(Ctx ctx, int AD_Schedule_ID) {
        Integer key = new Integer(AD_Schedule_ID);
        MSchedule retValue = (MSchedule)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MSchedule(ctx, AD_Schedule_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MSchedule(Ctx ctx, int AD_Schedule_ID, String trxName) {
        super(ctx, AD_Schedule_ID, trxName);
        if (AD_Schedule_ID == 0) {
            this.setScheduleType("F");
            this.setFrequencyType("D");
            this.setFrequency(1);
            this.setOnMonday(true);
            this.setOnTuesday(true);
            this.setOnWednesday(true);
            this.setOnThursday(true);
            this.setOnFriday(true);
            this.setOnSaturday(false);
            this.setOnSunday(false);
            this.setRunOnlySpecifiedTime(false);
        }
    }

    public MSchedule(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int getMonthDay() {
        int day = super.getMonthDay();
        if (day < 1) {
            day = 1;
        } else if (day > 31) {
            day = 31;
        }
        return day;
    }

    public String getWeekDay() {
        String wd = super.getWeekDay();
        if (wd == null || this.isWeekDayValid(wd)) {
            wd = "1";
        }
        return wd;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getScheduleType() == null) {
            this.setScheduleType("F");
        }
        if ("F".equals(this.getScheduleType())) {
            if (this.getFrequencyType() == null) {
                this.setFrequencyType("D");
            }
            if (this.getFrequency() < 1) {
                this.setFrequency(1);
            }
        } else if ("M".equals(this.getScheduleType())) {
            if (super.getMonthDay() < 1 || super.getMonthDay() > 31) {
                this.setMonthDay(1);
            }
        } else {
            if (this.getScheduleType() == null) {
                this.setScheduleType("W");
            }
            if (super.getWeekDay() == null) {
                this.setWeekDay("1");
            }
        }
        if (this.getScheduleHour() > 23 || this.getScheduleHour() < 0) {
            this.setScheduleHour(0);
        }
        if (this.getScheduleMinute() > 59 || this.getScheduleMinute() < 0) {
            this.setScheduleMinute(0);
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MSchedule[");
        sb.append(this.get_ID()).append("-").append(this.getName());
        String scheduleType = this.getScheduleType();
        sb.append(",Type=").append(scheduleType);
        if ("F".equals(scheduleType)) {
            sb.append(",Frequency=").append(this.getFrequencyType()).append("*").append(this.getFrequency());
            if (this.isOnMonday()) {
                sb.append(",Mo");
            }
            if (this.isOnTuesday()) {
                sb.append(",Tu");
            }
            if (this.isOnWednesday()) {
                sb.append(",We");
            }
            if (this.isOnThursday()) {
                sb.append(",Th");
            }
            if (this.isOnFriday()) {
                sb.append(",Fr");
            }
            if (this.isOnSaturday()) {
                sb.append(",Sa");
            }
            if (this.isOnSunday()) {
                sb.append(",Su");
            }
        } else if ("M".equals(scheduleType)) {
            sb.append(",Day=").append(this.getMonthDay());
        } else {
            sb.append(",Day=").append(this.getWeekDay());
        }
        sb.append(",HH=").append(this.getScheduleHour()).append(",MM=").append(this.getScheduleMinute());
        sb.append("]");
        return sb.toString();
    }

    public boolean isOKtoRunOnIP() {
        String ipOnly = this.getRunOnlyOnIP();
        if (ipOnly == null || ipOnly.length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(ipOnly, ";");
        while (st.hasMoreElements()) {
            String ip = st.nextToken();
            if (!this.checkIP(ip)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIP(String ipOnly) {
        try {
            InetAddress box = InetAddress.getLocalHost();
            String ip = box.getHostAddress();
            if (ipOnly.indexOf(ip) == -1) {
                this.log.fine("Not allowed here - IP=" + ip + " does not match " + ipOnly);
                return false;
            }
            this.log.fine("Allowed here - IP=" + ip + " matches " + ipOnly);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            return false;
        }
        return true;
    }

    public long getNextRunMS(long last) {
        Calendar calNow = GregorianCalendar.getInstance();
        calNow.setTimeInMillis(last);
        Calendar calNext = GregorianCalendar.getInstance();
        calNext.setTimeInMillis(last);
        calNext.set(13, 0);
        calNext.set(14, 0);
        int hour = this.getScheduleHour();
        int minute = this.getScheduleMinute();
        String scheduleType = this.getScheduleType();
        if ("F".equals(scheduleType)) {
            String frequencyType = this.getFrequencyType();
            int frequency = this.getFrequency();
            if ("D".equals(frequencyType)) {
                calNext.set(11, hour);
                calNext.set(12, minute);
                calNext.add(6, frequency);
            } else if ("H".equals(frequencyType)) {
                calNext.set(12, minute);
                calNext.add(11, frequency);
            } else if ("M".equals(frequencyType)) {
                calNext.add(12, frequency);
            }
        } else if ("M".equals(scheduleType)) {
            calNext.set(10, hour);
            calNext.set(12, minute);
            int day = this.getMonthDay();
            int dd = calNext.get(5);
            int max = calNext.getActualMaximum(5);
            int dayUsed = Math.min(day, max);
            if (dd < dayUsed) {
                calNext.set(5, dayUsed);
            } else {
                if (calNext.get(2) == 11) {
                    calNext.add(1, 1);
                    calNext.set(2, 0);
                } else {
                    calNext.add(2, 1);
                }
                max = calNext.getActualMaximum(5);
                dayUsed = Math.min(day, max);
                calNext.set(5, dayUsed);
            }
        } else {
            String weekDay = this.getWeekDay();
            int dayOfWeek = 0;
            if ("1".equals(weekDay)) {
                dayOfWeek = 2;
            } else if ("2".equals(weekDay)) {
                dayOfWeek = 3;
            } else if ("3".equals(weekDay)) {
                dayOfWeek = 4;
            } else if ("4".equals(weekDay)) {
                dayOfWeek = 5;
            } else if ("5".equals(weekDay)) {
                dayOfWeek = 6;
            } else if ("6".equals(weekDay)) {
                dayOfWeek = 7;
            } else if ("7".equals(weekDay)) {
                dayOfWeek = 1;
            }
            calNext.set(7, dayOfWeek);
            calNext.set(10, hour);
            calNext.set(12, minute);
            calNext.set(13, 0);
            calNext.set(14, 0);
            if (!calNext.after(calNow)) {
                calNext.add(3, 1);
            }
        }
        long delta = calNext.getTimeInMillis() - calNow.getTimeInMillis();
        String info = "Now=" + calNow.getTime().toString() + ", Next=" + calNext.getTime().toString() + ", Delta=" + delta + " " + this.toString();
        if (delta < 0L) {
            this.log.warning(info);
        } else {
            this.log.info(info);
        }
        return calNext.getTimeInMillis();
    }

    public Timestamp[] getNext(Timestamp start, int iterations) {
        Timestamp[] nexts = new Timestamp[iterations];
        long startMS = start.getTime();
        for (int i = 0; i < nexts.length; ++i) {
            Timestamp next = new Timestamp(this.getNextRunMS(startMS));
            startMS = next.getTime();
            nexts[i] = next;
        }
        return nexts;
    }

    public static void main(String[] args) {
        Compiere.startup((boolean)true);
        CLogMgt.setLevel((Level)Level.FINE);
        MSchedule s = null;
        Timestamp start = TimeUtil.getDay((int)2007, (int)12, (int)1);
        s = new MSchedule(Env.getCtx(), 0, null);
        s.log.info("*** Day 2 ***");
        s.setScheduleType("F");
        s.setFrequencyType("D");
        s.setFrequency(2);
        s.getNext(start, 10);
        s = new MSchedule(Env.getCtx(), 0, null);
        s.log.info("*** Hour 5 ***");
        s.setScheduleType("F");
        s.setFrequencyType("H");
        s.setFrequency(5);
        s.getNext(start, 10);
        s = new MSchedule(Env.getCtx(), 0, null);
        s.log.info("*** Minute 15 ***");
        s.setScheduleType("F");
        s.setFrequencyType("M");
        s.setFrequency(15);
        s.getNext(start, 10);
        s = new MSchedule(Env.getCtx(), 0, null);
        s.log.info("*** WeekDay Mo ***");
        s.setScheduleType("W");
        s.setWeekDay("1");
        s.getNext(start, 92);
        s = new MSchedule(Env.getCtx(), 0, null);
        s.log.info("*** MonthDay 31 ***");
        s.setScheduleType("M");
        s.setMonthDay(31);
        s.getNext(start, 14);
    }
}

