/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.cm.CacheHandler;
import org.compiere.model.MAd;
import org.compiere.model.MCStage;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_Template;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTemplate
extends X_CM_Template {
    private MWebProject m_project = null;
    private StringBuffer m_preBuildTemplate;
    private static CLogger s_log = CLogger.getCLogger(MTemplate.class);
    private boolean m_isUseAd = false;
    private StringBuffer m_adTemplates = new StringBuffer();
    private boolean m_isNews = false;
    private boolean m_isRequest = false;
    private boolean m_hasSubtemplates = true;
    private ArrayList<String> m_subTemplates = null;

    public static MTemplate get(Ctx ctx, int CM_Template_ID, String trxName) {
        MTemplate retValue = new MTemplate(ctx, CM_Template_ID, trxName);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTemplate(ctx, CM_Template_ID, null);
        return retValue;
    }

    public MTemplate(Ctx ctx, int CM_Template_ID, String trxName) {
        super(ctx, CM_Template_ID, trxName);
    }

    public MTemplate(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MTemplate getByName(Ctx ctx, String name, int projectID, String trxName) {
        String sql = "SELECT * FROM CM_Template WHERE Value LIKE ? AND CM_WebProject_ID=?";
        MTemplate thisElement = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setString(1, name);
            pstmt.setInt(2, projectID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                thisElement = new MTemplate(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getByName", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return thisElement;
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = MWebProject.get(this.getCtx(), this.getCM_WebProject_ID());
        }
        return this.m_project;
    }

    public int getAD_Tree_ID() {
        return this.getWebProject().getAD_TreeCMT_ID();
    }

    public boolean isUseAd(boolean includeSub) {
        if (!includeSub) {
            return this.isUseAd();
        }
        if (this.m_preBuildTemplate == null) {
            this.rebuildTemplate();
        }
        if (!this.m_isUseAd && this.isUseAd()) {
            this.m_isUseAd = this.isUseAd();
        }
        if (this.isUseAd()) {
            this.m_adTemplates.append(this.get_ID() + ",");
        }
        return this.m_isUseAd;
    }

    public boolean isNews(boolean includeSub) {
        if (!includeSub) {
            return this.isNews();
        }
        if (this.m_preBuildTemplate == null) {
            this.rebuildTemplate();
        }
        if (this.m_isNews != this.isNews()) {
            this.m_isNews = this.isNews();
        }
        return this.m_isNews;
    }

    public boolean isRequest(boolean includeSub) {
        if (this.m_preBuildTemplate == null) {
            this.rebuildTemplate();
        }
        return this.m_isRequest;
    }

    public StringBuffer getPreBuildTemplate() {
        if (this.m_preBuildTemplate == null) {
            this.rebuildTemplate();
        }
        return this.m_preBuildTemplate;
    }

    public void rebuildTemplate() {
        this.m_preBuildTemplate = new StringBuffer(this.getTemplateXST());
        if (this.m_preBuildTemplate.indexOf("<xsl:call-template") >= 0) {
            StringBuffer subTemplates = new StringBuffer();
            int pos = 0;
            ArrayList<String> subTemplateNames = new ArrayList<String>();
            while (this.m_preBuildTemplate.indexOf("<xsl:call-template", pos) >= 0) {
                String thisName = null;
                int beginPos = this.m_preBuildTemplate.indexOf("<xsl:call-template", pos);
                int endPos = this.m_preBuildTemplate.indexOf("/>", beginPos);
                if (this.m_preBuildTemplate.indexOf(">", beginPos) < endPos) {
                    endPos = this.m_preBuildTemplate.indexOf(">", beginPos) + 1;
                }
                String tempTemplate = this.m_preBuildTemplate.substring(beginPos, endPos);
                pos = this.m_preBuildTemplate.indexOf("<xsl:call-template", pos) + tempTemplate.length();
                if (tempTemplate.indexOf("name=") < 0 || subTemplateNames.contains(thisName = tempTemplate.substring(tempTemplate.indexOf("name=\"") + 6, tempTemplate.indexOf("\"", tempTemplate.indexOf("name=\"") + 7)))) continue;
                subTemplateNames.add(thisName);
            }
            for (int i = 0; i < subTemplateNames.size(); ++i) {
                MTemplate subTemplate = MTemplate.getByName(this.getCtx(), (String)subTemplateNames.get(i), this.getCM_WebProject_ID(), this.get_TrxName());
                if (subTemplate == null) continue;
                if (subTemplate.containsSubtemplates(true, subTemplateNames)) {
                    subTemplateNames = subTemplate.getSubTemplateList();
                }
                subTemplates.append(subTemplate.getTemplateXST());
                if (subTemplate.isUseAd()) {
                    this.m_isUseAd = true;
                    this.m_adTemplates.append(subTemplate.get_ID() + ",");
                }
                if (!subTemplate.isNews()) continue;
                this.m_isNews = true;
            }
            this.m_preBuildTemplate.append(subTemplates);
            this.m_preBuildTemplate = new StringBuffer(this.m_preBuildTemplate.substring(0, this.m_preBuildTemplate.indexOf("</xsl:stylesheet>")) + subTemplates.toString() + "\n</xsl:stylesheet>");
            if (this.m_preBuildTemplate.indexOf("/webCM/requestTables/") >= 0) {
                this.m_isRequest = true;
            }
        }
    }

    private ArrayList<String> getSubTemplateList() {
        return this.m_subTemplates;
    }

    private boolean containsSubtemplates(boolean refresh, ArrayList<String> existingSubTemplates) {
        if (refresh) {
            this.m_subTemplates = null;
        }
        if (this.m_subTemplates != null) {
            return this.m_hasSubtemplates;
        }
        this.m_subTemplates = new ArrayList();
        if (existingSubTemplates != null) {
            for (int i = 0; i < existingSubTemplates.size(); ++i) {
                String thisTemplate = existingSubTemplates.get(i);
                this.m_subTemplates.add(thisTemplate);
            }
        }
        if (this.getTemplateXST().indexOf("<xsl:call-template") >= 0) {
            int pos = 0;
            while (this.getTemplateXST().indexOf("<xsl:call-template", pos) >= 0) {
                String thisName = null;
                int beginPos = this.getTemplateXST().indexOf("<xsl:call-template", pos);
                int endPos = this.getTemplateXST().indexOf("/>", beginPos);
                if (this.getTemplateXST().indexOf(">", beginPos) < endPos) {
                    endPos = this.getTemplateXST().indexOf(">", beginPos) + 1;
                }
                String tempTemplate = this.getTemplateXST().substring(beginPos, endPos);
                pos = this.getTemplateXST().indexOf("<xsl:call-template", pos) + tempTemplate.length();
                if (tempTemplate.indexOf("name=") < 0 || this.m_subTemplates.contains(thisName = tempTemplate.substring(tempTemplate.indexOf("name=\"") + 6, tempTemplate.indexOf("\"", tempTemplate.indexOf("name=\"") + 7)))) continue;
                this.m_subTemplates.add(thisName);
            }
            this.m_hasSubtemplates = true;
        } else {
            this.m_hasSubtemplates = false;
        }
        return this.m_hasSubtemplates;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!this.isValid()) {
            this.setIsValid(true);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            StringBuffer sb = new StringBuffer("INSERT INTO AD_TreeNodeCMT (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (").append(this.getAD_Client_ID()).append(",0, 'Y', SysDate, 0, SysDate, 0,").append(this.getAD_Tree_ID()).append(",").append(this.get_ID()).append(", 0, 999)");
            int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            if (no > 0) {
                this.log.fine("#" + no + " - TreeType=CMT");
            } else {
                this.log.warning("#" + no + " - TreeType=CMT");
            }
            return no > 0;
        }
        if (!newRecord) {
            CacheHandler thisHandler = new CacheHandler(CacheHandler.convertJNPURLToCacheURL(this.getCtx().getContext("java.naming.provider.url")), this.log, this.getCtx(), this.get_TrxName());
            if (!this.isInclude()) {
                thisHandler.cleanTemplate(this.get_ID());
                MCStage[] theseStages = MCStage.getStagesByTemplate(this.getWebProject(), this.get_ID());
                for (int i = 0; i < theseStages.length; ++i) {
                    theseStages[i].checkElements();
                }
            } else {
                thisHandler.emptyTemplate();
            }
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM AD_TreeNodeCMT ").append(" WHERE Node_ID=").append(this.get_IDOld()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID());
        int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=CMT");
        } else {
            this.log.warning("#" + no + " - TreeType=CMT");
        }
        return no > 0;
    }

    public MAd[] getAds() {
        int[] AdCats = null;
        String sql = "SELECT count(*) FROM CM_Template_AD_Cat WHERE CM_Template_ID IN (" + this.m_adTemplates.toString().substring(0, this.m_adTemplates.length() - 1) + ")";
        CPreparedStatement pstmt = null;
        try {
            int numberAdCats = 0;
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                numberAdCats = rs.getInt(1);
            }
            rs.close();
            AdCats = new int[numberAdCats];
            int i = 0;
            sql = "SELECT CM_Ad_Cat_ID FROM CM_Template_AD_Cat WHERE CM_Template_ID IN (" + this.m_adTemplates.toString().substring(0, this.m_adTemplates.length() - 1) + ")";
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                AdCats[i] = rs.getInt(1);
                ++i;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (AdCats != null && AdCats.length > 0) {
            MAd[] returnAds = new MAd[AdCats.length];
            for (int i = 0; i < AdCats.length; ++i) {
                MAd thisAd = MAd.getNext(this.getCtx(), AdCats[i], this.get_TrxName());
                if (thisAd == null) continue;
                returnAds[i] = thisAd;
            }
            return returnAds;
        }
        return null;
    }
}

