/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBOM;
import org.compiere.model.MBOMProduct;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class BOMValidate
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private boolean p_IsReValidate = false;
    private MProduct m_product = null;
    private ArrayList<MProduct> m_products = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("IsReValidate")) {
                this.p_IsReValidate = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_Product_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_M_Product_ID != 0) {
            this.log.info("M_Product_ID=" + this.p_M_Product_ID);
            return this.validateProduct(new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName()));
        }
        this.log.info("M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", IsReValidate=" + this.p_IsReValidate);
        int counter = 0;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM M_Product WHERE IsBOM='Y' AND ";
        sql = this.p_M_Product_Category_ID == 0 ? sql + "AD_Client_ID=? " : sql + "M_Product_Category_ID=? ";
        if (!this.p_IsReValidate) {
            sql = sql + "AND IsVerified<>'Y' ";
        }
        sql = sql + "ORDER BY Name";
        int AD_Client_ID = this.getCtx().getAD_Client_ID();
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            if (this.p_M_Product_Category_ID == 0) {
                pstmt.setInt(1, AD_Client_ID);
            } else {
                pstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String info = this.validateProduct(new MProduct(this.getCtx(), rs, this.get_TrxName()));
                this.addLog(0, null, null, info);
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "#" + counter;
    }

    private String validateProduct(MProduct product) {
        if (!product.isBOM()) {
            return product.getName() + " @NotValid@ @M_BOM_ID@";
        }
        this.m_product = product;
        this.log.config(this.m_product.getName());
        this.m_products = new ArrayList();
        if (!this.validateOldProduct(this.m_product)) {
            this.m_product.setIsVerified(false);
            this.m_product.save();
            return this.m_product.getName() + " @NotValid@";
        }
        MBOM[] boms = MBOM.getOfProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName(), null);
        for (int i = 0; i < boms.length; ++i) {
            this.m_products = new ArrayList();
            if (this.validateBOM(boms[i])) continue;
            this.m_product.setIsVerified(false);
            this.m_product.save();
            return this.m_product.getName() + " " + boms[i].getName() + " @NotValid@";
        }
        this.m_product.setIsVerified(true);
        this.m_product.save();
        return this.m_product.getName() + " @IsValid@";
    }

    private boolean validateOldProduct(MProduct product) {
        if (!product.isBOM()) {
            return true;
        }
        if (this.m_products.contains((Object)product)) {
            this.log.warning(this.m_product.getName() + " recursively includes " + product.getName());
            return false;
        }
        this.m_products.add(product);
        this.log.fine(product.getName());
        MProductBOM[] productsBOMs = MProductBOM.getBOMLines(product);
        for (int i = 0; i < productsBOMs.length; ++i) {
            MProductBOM productsBOM = productsBOMs[i];
            MProduct pp = new MProduct(this.getCtx(), productsBOM.getM_ProductBOM_ID(), this.get_TrxName());
            if (!pp.isBOM()) {
                this.log.finer(pp.getName());
                continue;
            }
            if (this.validateOldProduct(pp)) continue;
            return false;
        }
        return true;
    }

    private boolean validateBOM(MBOM bom) {
        MBOMProduct[] BOMproducts = MBOMProduct.getOfBOM(bom);
        for (int i = 0; i < BOMproducts.length; ++i) {
            MBOMProduct BOMproduct = BOMproducts[i];
            MProduct pp = new MProduct(this.getCtx(), BOMproduct.getM_BOMProduct_ID(), this.get_TrxName());
            if (!pp.isBOM()) continue;
            return this.validateProduct(pp, bom.getBOMType(), bom.getBOMUse());
        }
        return true;
    }

    private boolean validateProduct(MProduct product, String BOMType, String BOMUse) {
        if (!product.isBOM()) {
            return true;
        }
        String restriction = "BOMType='" + BOMType + "' AND BOMUse='" + BOMUse + "'";
        MBOM[] boms = MBOM.getOfProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName(), restriction);
        if (boms.length != 1) {
            this.log.warning(restriction + " - Length=" + boms.length);
            return false;
        }
        if (this.m_products.contains((Object)product)) {
            this.log.warning(this.m_product.getName() + " recursively includes " + product.getName());
            return false;
        }
        this.m_products.add(product);
        this.log.fine(product.getName());
        MBOM bom = boms[0];
        MBOMProduct[] BOMproducts = MBOMProduct.getOfBOM(bom);
        for (int i = 0; i < BOMproducts.length; ++i) {
            MBOMProduct BOMproduct = BOMproducts[i];
            MProduct pp = new MProduct(this.getCtx(), BOMproduct.getM_BOMProduct_ID(), this.get_TrxName());
            if (!pp.isBOM()) continue;
            return this.validateProduct(pp, bom.getBOMType(), bom.getBOMUse());
        }
        return true;
    }
}

